/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.memory;

import java.util.ArrayList;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.memory.CacheManager;

public abstract class CachedObject<T>
implements CacheManager.CachedData {
    protected T object;
    protected int usage = 0;
    protected long expiration;
    protected long lastUsage = System.currentTimeMillis();
    protected ArrayList<Object> users = null;

    public CachedObject(T object, long expiration) {
        this.object = object;
        this.expiration = expiration;
        if (LCCore.getApplication().isDebugMode()) {
            this.users = new ArrayList(2);
        }
    }

    public T get() {
        return this.object;
    }

    public synchronized void use(Object user) {
        ++this.usage;
        this.lastUsage = System.currentTimeMillis();
        if (this.users != null) {
            this.users.add(user);
        }
    }

    public synchronized void release(Object user) {
        --this.usage;
        if (this.users != null && !this.users.remove(user)) {
            LCCore.getApplication().getDefaultLogger().error("CachedObject released by " + user + " but not in users list", new Exception());
        }
    }

    public int getUsage() {
        return this.usage;
    }

    public long getLastUsage() {
        return this.lastUsage;
    }

    public long getExpiration() {
        return this.expiration;
    }

    public void close() {
        this.closeCachedObject(this.object);
        this.object = null;
    }

    protected abstract void closeCachedObject(T var1);

    @Override
    public int cachedDataCurrentUsage() {
        return this.usage;
    }

    @Override
    public long cachedDataLastUsage() {
        return this.lastUsage;
    }
}

