/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.math;

import java.text.ParseException;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.StringParser;

public class RangeInteger {
    public int min;
    public int max;

    public RangeInteger(int min, int max) {
        this.min = min;
        this.max = max;
    }

    public RangeInteger(RangeInteger copy) {
        this.min = copy.min;
        this.max = copy.max;
    }

    @StringParser.Parse
    public RangeInteger(String string) throws ParseException, NumberFormatException {
        if (string == null || string.isEmpty()) {
            throw new ParseException("Empty string", 0);
        }
        char c = string.charAt(0);
        if (c == ']' || c == '[') {
            int sep = string.indexOf(45);
            if (sep < 0) {
                throw new ParseException("Must start with [ or ], followed by a number, a -, a number, and finally [ or ]", 1);
            }
            this.min = Integer.parseInt(string.substring(1, sep));
            if (c == ']') {
                ++this.min;
            }
            if ((c = string.charAt(string.length() - 1)) != ']' && c != '[') {
                throw new ParseException("Must start with [ or ], followed by a number, a -, a number, and finally [ or ]", string.length() - 1);
            }
            this.max = Integer.parseInt(string.substring(sep + 1, string.length() - 1));
            if (c == '[') {
                --this.max;
            }
            if (this.max < this.min) {
                int i = this.min;
                this.min = this.max;
                this.max = i;
            }
        } else {
            this.min = this.max = Integer.parseInt(string);
        }
    }

    public RangeInteger copy() {
        return new RangeInteger(this.min, this.max);
    }

    public boolean equals(Object obj) {
        if (obj == null || !(obj instanceof RangeInteger)) {
            return false;
        }
        RangeInteger r = (RangeInteger)obj;
        return r.min == this.min && r.max == this.max;
    }

    public int hashCode() {
        return this.min + this.max;
    }

    public boolean contains(int value) {
        return value >= this.min && value <= this.max;
    }

    public RangeInteger intersect(RangeInteger r) {
        if (this.min > r.max) {
            return null;
        }
        if (this.max < r.min) {
            return null;
        }
        return new RangeInteger(Math.max(this.min, r.min), Math.min(this.max, r.max));
    }

    public Pair<RangeInteger, RangeInteger> removeIntersect(RangeInteger o) {
        if (o.max < this.min || o.min > this.max) {
            return new Pair<RangeInteger, Object>(this.copy(), null);
        }
        if (o.min <= this.min) {
            if (o.max >= this.max) {
                return new Pair<Object, Object>(null, null);
            }
            return new Pair<Object, RangeInteger>(null, new RangeInteger(o.max + 1, this.max));
        }
        if (o.max >= this.max) {
            return new Pair<RangeInteger, Object>(new RangeInteger(this.min, o.min - 1), null);
        }
        return new Pair<RangeInteger, RangeInteger>(new RangeInteger(this.min, o.min - 1), new RangeInteger(o.max + 1, this.max));
    }

    public int getLength() {
        return this.max - this.min + 1;
    }

    public String toString() {
        return "[" + this.min + "-" + this.max + "]";
    }

    public static class Parser
    implements StringParser<RangeInteger> {
        @Override
        public RangeInteger parse(String string) throws ParseException {
            return new RangeInteger(string);
        }
    }
}

