/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.util;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public class BroadcastIO
extends ConcurrentCloseable
implements IO.Writable {
    private IO.Writable[] ios;
    private byte priority;
    private boolean closeIOs;

    public BroadcastIO(IO.Writable[] ios, byte priority, boolean closeIOs) {
        this.ios = ios;
        this.closeIOs = closeIOs;
        this.setPriority(priority);
    }

    @Override
    public byte getPriority() {
        return this.priority;
    }

    @Override
    public void setPriority(byte priority) {
        this.priority = priority;
        for (int i = 0; i < this.ios.length; ++i) {
            this.ios[i].setPriority(priority);
        }
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    @Override
    public String getSourceDescription() {
        return "BroadcastIO";
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        if (!this.closeIOs) {
            return new SynchronizationPoint<boolean>(true);
        }
        JoinPoint jp = new JoinPoint();
        for (int i = 0; i < this.ios.length; ++i) {
            jp.addToJoin(this.ios[i].closeAsync());
        }
        jp.start();
        return jp;
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.ios = null;
        ondone.unblock();
    }

    @Override
    public ISynchronizationPoint<IOException> canStartWriting() {
        JoinPoint<IOException> jp = new JoinPoint<IOException>();
        for (int i = 0; i < this.ios.length; ++i) {
            jp.addToJoin(this.ios[i].canStartWriting());
        }
        jp.start();
        return jp;
    }

    @Override
    public int writeSync(final ByteBuffer buffer) throws IOException {
        final JoinPoint jp = new JoinPoint();
        jp.addToJoin(this.ios.length);
        for (int i = 0; i < this.ios.length; ++i) {
            this.ios[i].writeAsync(buffer.duplicate()).listenInline(new AsyncWork.AsyncWorkListener<Integer, IOException>(){

                @Override
                public void ready(Integer result) {
                    if (result.intValue() != buffer.remaining()) {
                        jp.error(new IOException("Only " + result + " byte(s) written instead of " + buffer.remaining()));
                    } else {
                        jp.joined();
                    }
                }

                @Override
                public void error(IOException error) {
                    jp.error(error);
                }

                @Override
                public void cancelled(CancelException event) {
                    jp.cancel(event);
                }
            });
        }
        jp.start();
        jp.blockException(0L);
        return buffer.remaining();
    }

    @Override
    public AsyncWork<Integer, IOException> writeAsync(final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
        new Task.Cpu.FromRunnable("BroadcastIO.writeAsync", this.priority, () -> {
            final JoinPoint jp = new JoinPoint();
            jp.addToJoin(this.ios.length);
            for (int i = 0; i < this.ios.length; ++i) {
                this.ios[i].writeAsync(buffer.duplicate()).listenInline(new AsyncWork.AsyncWorkListener<Integer, IOException>(){

                    @Override
                    public void ready(Integer result) {
                        if (result.intValue() != buffer.remaining()) {
                            jp.error(new IOException("Only " + result + " byte(s) written instead of " + buffer.remaining()));
                        } else {
                            jp.joined();
                        }
                    }

                    @Override
                    public void error(IOException error) {
                        jp.error(error);
                    }

                    @Override
                    public void cancelled(CancelException event) {
                        jp.cancel(event);
                    }
                });
            }
            jp.start();
            jp.listenInline(() -> result.unblockSuccess(buffer.remaining()), result);
        }).start();
        return result;
    }
}

