/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.EOFException;
import java.io.IOException;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class TextLineStream
extends ConcurrentCloseable {
    private ICharacterStream.Readable.Buffered input;

    public TextLineStream(ICharacterStream.Readable.Buffered input) {
        this.input = input;
    }

    public UnprotectedStringBuffer nextLine() throws IOException {
        if (this.input.endReached()) {
            return null;
        }
        UnprotectedStringBuffer line = new UnprotectedStringBuffer();
        boolean prevCR = false;
        try {
            char c;
            while ((c = this.input.read()) != '\n') {
                if (c == '\r' && !prevCR) {
                    prevCR = true;
                    continue;
                }
                if (prevCR) {
                    line.append('\r');
                    prevCR = false;
                }
                if (c == '\r') {
                    prevCR = true;
                    continue;
                }
                line.append(c);
            }
        }
        catch (EOFException e) {
        }
        return line;
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.input.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.input = null;
        ondone.unblock();
    }

    @Override
    public byte getPriority() {
        return this.input.getPriority();
    }
}

