/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.IOException;
import java.nio.CharBuffer;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.IString;

public class CharacterStreamWritePool {
    private ICharacterStream.Writable stream;
    private ISynchronizationPoint<IOException> lastWrite = new SynchronizationPoint<boolean>(true);

    public CharacterStreamWritePool(ICharacterStream.Writable stream) {
        this.stream = stream;
    }

    public ISynchronizationPoint<IOException> write(char c) {
        if (!(this.stream instanceof ICharacterStream.Writable.Buffered)) {
            return this.write(new char[]{c}, 0, 1);
        }
        ISynchronizationPoint<IOException> last = this.lastWrite;
        if (last.isUnblocked()) {
            this.lastWrite = ((ICharacterStream.Writable.Buffered)this.stream).writeAsync(c);
            return this.lastWrite;
        }
        SynchronizationPoint<IOException> ours = new SynchronizationPoint<IOException>();
        this.lastWrite = ours;
        last.listenInline(() -> ((ICharacterStream.Writable.Buffered)this.stream).writeAsync(c).listenInline(ours), ours);
        return ours;
    }

    public ISynchronizationPoint<IOException> write(char[] chars) {
        return this.write(chars, 0, chars.length);
    }

    public ISynchronizationPoint<IOException> write(char[] chars, int offset, int length) {
        ISynchronizationPoint<IOException> last = this.lastWrite;
        if (length == 0) {
            return last;
        }
        if (last.isUnblocked()) {
            this.lastWrite = this.stream.writeAsync(chars, offset, length);
            return this.lastWrite;
        }
        SynchronizationPoint<IOException> ours = new SynchronizationPoint<IOException>();
        this.lastWrite = ours;
        last.listenInline(() -> this.stream.writeAsync(chars, offset, length).listenInline(ours), ours);
        return ours;
    }

    public ISynchronizationPoint<IOException> write(CharBuffer chars) {
        return this.write(chars.array(), chars.position(), chars.remaining());
    }

    public ISynchronizationPoint<IOException> write(CharBuffer[] chars) {
        ISynchronizationPoint<IOException> last = this.lastWrite;
        for (int i = 0; i < chars.length; ++i) {
            last = this.write(chars[i]);
        }
        return last;
    }

    public ISynchronizationPoint<IOException> write(String s) {
        return this.write(s.toCharArray());
    }

    public ISynchronizationPoint<IOException> write(IString s) {
        return this.write(s.asCharBuffers());
    }

    public ISynchronizationPoint<IOException> write(CharSequence s) {
        return this.write(s.toString());
    }

    public ISynchronizationPoint<IOException> flush() {
        return this.lastWrite;
    }
}

