/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.text;

import java.io.EOFException;
import java.io.IOException;
import java.nio.charset.Charset;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.text.ICharacterStream;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.UnprotectedString;

public class BufferedReadableCharacterStreamLocation
extends ConcurrentCloseable
implements ICharacterStream.Readable.Buffered {
    private ICharacterStream.Readable.Buffered stream;
    private int line;
    private int pos;
    private int lastLinePos;

    public BufferedReadableCharacterStreamLocation(ICharacterStream.Readable.Buffered stream) {
        this(stream, 1, 0);
    }

    public BufferedReadableCharacterStreamLocation(ICharacterStream.Readable.Buffered stream, int line, int posInLine) {
        this.stream = stream;
        this.line = line;
        this.lastLinePos = this.pos = posInLine;
    }

    public int getLine() {
        return this.line;
    }

    public int getPositionInLine() {
        return this.pos;
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        return this.stream.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.stream = null;
        ondone.unblock();
    }

    @Override
    public String getDescription() {
        return this.stream.getDescription();
    }

    @Override
    public Charset getEncoding() {
        return this.stream.getEncoding();
    }

    @Override
    public byte getPriority() {
        return this.stream.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.stream.setPriority(priority);
    }

    @Override
    public char read() throws EOFException, IOException {
        char c = this.stream.read();
        if (c == '\n') {
            ++this.line;
            this.lastLinePos = this.pos;
            this.pos = 0;
        } else if (c != '\r') {
            ++this.pos;
        }
        return c;
    }

    @Override
    public int readSync(char[] buf, int offset, int length) throws IOException {
        int nb = this.stream.readSync(buf, offset, length);
        for (int i = 0; i < nb; ++i) {
            if (buf[offset + i] == '\n') {
                ++this.line;
                this.lastLinePos = this.pos;
                this.pos = 0;
                continue;
            }
            if (buf[offset + i] == '\r') continue;
            ++this.pos;
        }
        return nb;
    }

    @Override
    public void back(char c) {
        if (c == '\n') {
            --this.line;
            this.pos = this.lastLinePos;
        } else {
            --this.pos;
        }
        this.stream.back(c);
    }

    @Override
    public int readAsync() throws IOException {
        int c = this.stream.readAsync();
        if (c < 0) {
            return c;
        }
        if (c == 10) {
            ++this.line;
            this.lastLinePos = this.pos;
            this.pos = 0;
        } else if (c != 13) {
            ++this.pos;
        }
        return c;
    }

    @Override
    public AsyncWork<Integer, IOException> readAsync(final char[] buf, final int offset, int length) {
        final AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
        final AsyncWork<Integer, IOException> read = this.stream.readAsync(buf, offset, length);
        read.listenAsync(this.operation(new Task.Cpu<Void, NoException>("Calculate new location of BufferedReadableCharacterStreamLocation", this.stream.getPriority()){

            @Override
            public Void run() {
                if (read.hasError()) {
                    result.error(read.getError());
                } else if (read.isCancelled()) {
                    result.cancel(read.getCancelEvent());
                } else {
                    int nb = (Integer)read.getResult();
                    for (int i = 0; i < nb; ++i) {
                        if (buf[offset + i] == '\n') {
                            BufferedReadableCharacterStreamLocation.this.line++;
                            BufferedReadableCharacterStreamLocation.this.lastLinePos = BufferedReadableCharacterStreamLocation.this.pos;
                            BufferedReadableCharacterStreamLocation.this.pos = 0;
                            continue;
                        }
                        if (buf[offset + i] == '\r') continue;
                        BufferedReadableCharacterStreamLocation.this.pos++;
                    }
                    result.unblockSuccess(read.getResult());
                }
                return null;
            }
        }), true);
        return result;
    }

    @Override
    public AsyncWork<UnprotectedString, IOException> readNextBufferAsync() {
        AsyncWork<UnprotectedString, IOException> result = new AsyncWork<UnprotectedString, IOException>();
        AsyncWork<UnprotectedString, IOException> read = this.readNextBufferAsync();
        read.listenAsync(new Task.Cpu.FromRunnable("Calculate new location of BufferedReadableCharacterStreamLocation", this.stream.getPriority(), () -> {
            UnprotectedString str = (UnprotectedString)read.getResult();
            if (str == null) {
                result.unblockSuccess(null);
                return;
            }
            char[] buf = str.charArray();
            int offset = str.charArrayStart();
            int len = str.length();
            for (int i = 0; i < len; ++i) {
                if (buf[offset + i] == '\n') {
                    ++this.line;
                    this.lastLinePos = this.pos;
                    this.pos = 0;
                    continue;
                }
                if (buf[offset + i] == '\r') continue;
                ++this.pos;
            }
            result.unblockSuccess(str);
        }), result);
        return result;
    }

    @Override
    public boolean endReached() {
        return this.stream.endReached();
    }

    @Override
    public ISynchronizationPoint<IOException> canStartReading() {
        return this.stream.canStartReading();
    }
}

