/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.lang.reflect.GenericArrayType;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.lang.reflect.WildcardType;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import net.lecousin.framework.collections.CollectionsUtil;

public class TypeDefinition {
    private Class<?> base;
    private List<TypeDefinition> parameters;

    public TypeDefinition(TypeDefinition containerType, Type type) {
        if (type instanceof Class) {
            this.base = (Class)type;
            this.parameters = new ArrayList<TypeDefinition>(0);
        } else if (type instanceof ParameterizedType) {
            ParameterizedType pt = (ParameterizedType)type;
            this.base = (Class)pt.getRawType();
            Type[] params = pt.getActualTypeArguments();
            this.parameters = new ArrayList<TypeDefinition>(params.length);
            for (Type p : params) {
                this.parameters.add(new TypeDefinition(containerType, p));
            }
        } else {
            if (type instanceof TypeVariable && containerType != null) {
                String name = ((TypeVariable)type).getName();
                TypeVariable<Class<?>>[] params = containerType.getBase().getTypeParameters();
                if (containerType.parameters.size() != params.length) {
                    throw new IllegalArgumentException("Cannot resolve type variable " + name + " using parameters of " + containerType.base.getName());
                }
                for (int i = 0; i < params.length; ++i) {
                    if (!params[i].getName().equals(name)) continue;
                    this.base = containerType.parameters.get((int)i).base;
                    this.parameters = new ArrayList<TypeDefinition>(containerType.parameters.get((int)i).parameters);
                    return;
                }
                throw new IllegalArgumentException("Unexpected type " + type.getClass() + ": " + type.toString());
            }
            if (type instanceof WildcardType) {
                this.base = Object.class;
                this.parameters = new ArrayList<TypeDefinition>(0);
            } else if (type instanceof GenericArrayType) {
                this.base = Object.class;
                this.parameters = new ArrayList<TypeDefinition>(0);
            } else {
                throw new IllegalArgumentException("Unexpected type " + type.getClass() + ": " + type.toString());
            }
        }
    }

    public TypeDefinition(Class<?> base, TypeDefinition ... parameters) {
        this.base = base;
        this.parameters = Arrays.asList(parameters);
    }

    public TypeDefinition(Class<?> base, List<TypeDefinition> parameters) {
        this.base = base;
        this.parameters = new ArrayList<TypeDefinition>(parameters);
    }

    public static TypeDefinition from(Class<?> instanceType, TypeDefinition definition) {
        if (instanceType.equals(definition.getBase())) {
            return definition;
        }
        TypeVariable[] types = instanceType.getTypeParameters();
        if (types.length == 0) {
            return new TypeDefinition(instanceType, new TypeDefinition[0]);
        }
        TypeDefinition[] params = new TypeDefinition[types.length];
        Type superClass = instanceType.getGenericSuperclass();
        if (superClass != null && TypeDefinition.getTypeParameters(superClass, definition, types, params)) {
            return new TypeDefinition(instanceType, params);
        }
        for (Type superInt : instanceType.getGenericInterfaces()) {
            if (!TypeDefinition.getTypeParameters(superInt, definition, types, params)) continue;
            return new TypeDefinition(instanceType, params);
        }
        return new TypeDefinition(instanceType, new TypeDefinition[0]);
    }

    public static boolean getTypeParameters(Type superType, TypeDefinition finalType, TypeVariable[] vars, TypeDefinition[] params) {
        if (superType instanceof ParameterizedType) {
            TypeDefinition[] superParams;
            Type[] args = ((ParameterizedType)superType).getActualTypeArguments();
            Type raw = ((ParameterizedType)superType).getRawType();
            if (!(raw instanceof Class)) {
                throw new IllegalArgumentException("Unexpected raw type " + raw);
            }
            Class superClass = (Class)raw;
            if (superClass.equals(finalType.getBase())) {
                block0: for (int i = 0; i < vars.length; ++i) {
                    for (int j = 0; j < args.length; ++j) {
                        if (!(args[j] instanceof TypeVariable) || !((TypeVariable)args[j]).getName().equals(vars[i].getName())) continue;
                        params[i] = finalType.getParameters().get(j);
                        continue block0;
                    }
                }
                return true;
            }
            Type superSuperClass = superClass.getGenericSuperclass();
            if (superSuperClass != null && TypeDefinition.getTypeParameters(superSuperClass, finalType, (TypeVariable[])args, superParams = new TypeDefinition[args.length])) {
                block2: for (int i = 0; i < vars.length; ++i) {
                    for (int j = 0; j < args.length; ++j) {
                        if (!(args[j] instanceof TypeVariable) || !((TypeVariable)args[j]).getName().equals(vars[i].getName())) continue;
                        params[i] = superParams[j];
                        continue block2;
                    }
                }
                return true;
            }
            for (Type superInt : superClass.getGenericInterfaces()) {
                TypeDefinition[] superParams2 = new TypeDefinition[args.length];
                if (!TypeDefinition.getTypeParameters(superInt, finalType, (TypeVariable[])args, superParams2)) continue;
                block5: for (int i = 0; i < vars.length; ++i) {
                    for (int j = 0; j < args.length; ++j) {
                        if (!(args[j] instanceof TypeVariable) || !((TypeVariable)args[j]).getName().equals(vars[i].getName())) continue;
                        params[i] = superParams2[j];
                        continue block5;
                    }
                }
                return true;
            }
        }
        return false;
    }

    public Class<?> getBase() {
        return this.base;
    }

    public List<TypeDefinition> getParameters() {
        return this.parameters;
    }

    public boolean equals(Object obj) {
        if (!(obj instanceof TypeDefinition)) {
            return false;
        }
        TypeDefinition o = (TypeDefinition)obj;
        if (!o.base.equals(this.base)) {
            return false;
        }
        return CollectionsUtil.equals(this.parameters, o.parameters);
    }

    public int hashCode() {
        return this.base.hashCode();
    }
}

