/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.serialization;

import java.lang.annotation.Annotation;
import java.lang.reflect.AccessibleObject;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.ParameterizedType;
import java.lang.reflect.Type;
import java.lang.reflect.TypeVariable;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import net.lecousin.framework.io.serialization.SerializationContext;
import net.lecousin.framework.io.serialization.TypeDefinition;
import net.lecousin.framework.io.serialization.rules.SerializationRule;

public class SerializationClass {
    private TypeDefinition type;
    private List<Attribute> attributes = new ArrayList<Attribute>();

    public SerializationClass(TypeDefinition type) {
        this.type = type;
        this.populateAttributes();
    }

    public TypeDefinition getType() {
        return this.type;
    }

    public List<Attribute> getAttributes() {
        return this.attributes;
    }

    public Attribute getAttributeByName(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getName())) continue;
            return a;
        }
        return null;
    }

    public Attribute getAttributeByOriginalName(String name) {
        for (Attribute a : this.attributes) {
            if (!name.equals(a.getOriginalName())) continue;
            return a;
        }
        return null;
    }

    public void replaceAttribute(Attribute original, Attribute newAttribute) {
        ListIterator<Attribute> it = this.attributes.listIterator();
        while (it.hasNext()) {
            if (!it.next().equals(original)) continue;
            it.set(newAttribute);
            break;
        }
    }

    public void apply(List<SerializationRule> rules, SerializationContext context, boolean serializing) throws Exception {
        for (SerializationRule rule : rules) {
            if (rule.apply(this, context, rules, serializing)) break;
        }
    }

    private void populateAttributes() {
        this.populateAttributes(this.type.getBase(), this.type.getParameters());
        this.filterAttributes();
    }

    private void populateAttributes(Class<?> type, List<TypeDefinition> params) {
        String name;
        Attribute a;
        if (Object.class.equals(type)) {
            return;
        }
        for (Field field : type.getDeclaredFields()) {
            if ((field.getModifiers() & 0x18) != 0 || (a = this.getAttributeByOriginalName(name = field.getName())) != null) continue;
            a = new Attribute(this, field);
            this.attributes.add(a);
        }
        for (AccessibleObject accessibleObject : type.getDeclaredMethods()) {
            Class<?> returnType;
            if ((((Method)accessibleObject).getModifiers() & 1) == 0) continue;
            name = ((Method)accessibleObject).getName();
            if (name.startsWith("get")) {
                if (name.length() == 3) continue;
                name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
                if (((Method)accessibleObject).getParameterCount() != 0 || (returnType = ((Method)accessibleObject).getReturnType()) == null || Void.class.equals(returnType) || Void.TYPE.equals(returnType)) continue;
                Attribute a2 = this.getAttributeByOriginalName(name);
                if (a2 == null) {
                    a2 = new Attribute(this, name, new TypeDefinition(new TypeDefinition(type, params), ((Method)accessibleObject).getGenericReturnType()));
                    this.attributes.add(a2);
                }
                if (a2.getter != null) continue;
                a2.getter = accessibleObject;
                continue;
            }
            if (name.startsWith("is")) {
                if (name.length() == 2) continue;
                name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
                if (((Method)accessibleObject).getParameterCount() != 0 || (returnType = ((Method)accessibleObject).getReturnType()) == null || Void.class.equals(returnType) || Void.TYPE.equals(returnType) || !returnType.equals(Boolean.TYPE) && !returnType.equals(Boolean.class)) continue;
                Attribute a2 = this.getAttributeByOriginalName(name);
                if (a2 == null) {
                    a2 = new Attribute(this, name, new TypeDefinition(returnType, new TypeDefinition[0]));
                    this.attributes.add(a2);
                }
                if (a2.getter != null) continue;
                a2.getter = accessibleObject;
                continue;
            }
            if (!name.startsWith("set") || name.length() == 3) continue;
            name = Character.toLowerCase(name.charAt(3)) + name.substring(4);
            if (((Method)accessibleObject).getParameterCount() != 1) continue;
            a = this.getAttributeByOriginalName(name);
            if (a == null) {
                a = new Attribute(this, name, new TypeDefinition(new TypeDefinition(type, params), ((Method)accessibleObject).getGenericParameterTypes()[0]));
            }
            if (a.setter != null) continue;
            a.setter = accessibleObject;
        }
        if (type.getSuperclass() != null) {
            Type t = type.getGenericSuperclass();
            LinkedList<TypeDefinition> superParams = new LinkedList<TypeDefinition>();
            if (t instanceof ParameterizedType) {
                block2: for (Type arg : ((ParameterizedType)t).getActualTypeArguments()) {
                    if (arg instanceof TypeVariable) {
                        TypeVariable<Class<?>>[] typeArgs = type.getTypeParameters();
                        for (int i = 0; i < typeArgs.length; ++i) {
                            if (!typeArgs[i].getName().equals(((TypeVariable)arg).getName())) continue;
                            superParams.add(params.get(i));
                            continue block2;
                        }
                        continue;
                    }
                    superParams.add(new TypeDefinition(null, arg));
                }
            }
            this.populateAttributes(type.getSuperclass(), superParams);
        }
    }

    private void filterAttributes() {
        Iterator<Attribute> it = this.attributes.iterator();
        while (it.hasNext()) {
            Attribute a = it.next();
            if (a.canGet() || a.canSet()) continue;
            it.remove();
        }
    }

    public static TypeDefinition searchAttributeType(TypeDefinition containerType, String attributeName) {
        Class<?> returnType;
        Method m2;
        try {
            Field f = containerType.getBase().getField(attributeName);
            if ((f.getModifiers() & 0x18) != 0) {
                return new TypeDefinition(containerType, f.getGenericType());
            }
        }
        catch (Throwable f) {
            // empty catch block
        }
        try {
            m2 = containerType.getBase().getMethod("get" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1), new Class[0]);
            returnType = m2.getReturnType();
            if (returnType != null && !Void.class.equals(returnType) && !Void.TYPE.equals(returnType)) {
                return new TypeDefinition(containerType, m2.getGenericReturnType());
            }
        }
        catch (Throwable m2) {
            // empty catch block
        }
        try {
            m2 = containerType.getBase().getMethod("is" + Character.toUpperCase(attributeName.charAt(0)) + attributeName.substring(1), new Class[0]);
            returnType = m2.getReturnType();
            if (Boolean.TYPE.equals(returnType) || Boolean.class.equals(returnType)) {
                return new TypeDefinition(containerType, m2.getGenericReturnType());
            }
        }
        catch (Throwable throwable) {
            // empty catch block
        }
        return null;
    }

    public static Object instantiate(Class<?> type) throws Exception {
        if (type.isAssignableFrom(ArrayList.class)) {
            return new ArrayList();
        }
        if (type.isAssignableFrom(LinkedList.class)) {
            return new LinkedList();
        }
        if (type.isAssignableFrom(HashSet.class)) {
            return new HashSet();
        }
        if (type.isAssignableFrom(HashMap.class)) {
            return new HashMap();
        }
        return type.newInstance();
    }

    public static Object instantiate(TypeDefinition type, SerializationContext context, List<SerializationRule> rules, boolean forceType) throws Exception {
        Object instance = null;
        for (SerializationRule rule : rules) {
            if (!rule.canInstantiate(type, context)) continue;
            instance = rule.instantiate(type, context);
            break;
        }
        if (instance == null) {
            instance = context instanceof SerializationContext.AttributeContext && !forceType ? ((SerializationContext.AttributeContext)context).getAttribute().instantiate((SerializationContext.AttributeContext)context) : SerializationClass.instantiate(type.getBase());
        }
        for (SerializationRule rule : rules) {
            rule.onInstantiation(type, instance, context);
        }
        return instance;
    }

    public static class Attribute {
        protected SerializationClass parent;
        protected String name;
        protected String originalName;
        protected Field field;
        protected Method getter;
        protected Method setter;
        protected TypeDefinition type;
        protected TypeDefinition originalType;
        protected boolean ignore = false;

        public Attribute(SerializationClass parent, String name, TypeDefinition type) {
            this.parent = parent;
            this.name = this.originalName = name;
            this.type = this.originalType = type;
        }

        public Attribute(SerializationClass parent, Field f) {
            this.parent = parent;
            this.field = f;
            this.name = this.originalName = f.getName();
            this.type = this.originalType = new TypeDefinition(parent.getType(), f.getGenericType());
            if ((f.getModifiers() & 0x80) != 0) {
                this.ignore = true;
            }
        }

        public Attribute(Attribute copy) {
            this.parent = copy.parent;
            this.name = copy.name;
            this.originalName = copy.originalName;
            this.field = copy.field;
            this.getter = copy.getter;
            this.setter = copy.setter;
            this.type = copy.type;
            this.originalType = copy.originalType;
            this.ignore = copy.ignore;
        }

        public SerializationClass getParent() {
            return this.parent;
        }

        public String getName() {
            return this.name;
        }

        public String getOriginalName() {
            return this.originalName;
        }

        public Field getField() {
            return this.field;
        }

        public Method getGetter() {
            return this.getter;
        }

        public Method getSetter() {
            return this.setter;
        }

        public TypeDefinition getType() {
            return this.type;
        }

        public TypeDefinition getOriginalType() {
            return this.originalType;
        }

        public boolean ignore() {
            return this.ignore;
        }

        public void ignore(boolean ignore) {
            this.ignore = ignore;
        }

        public void renameTo(String newName) {
            this.name = newName;
        }

        public void setType(TypeDefinition type) {
            this.type = type;
        }

        public Class<?> getDeclaringClass() {
            if (this.field != null) {
                return this.field.getDeclaringClass();
            }
            if (this.getter != null) {
                return this.getter.getDeclaringClass();
            }
            return this.setter.getDeclaringClass();
        }

        public boolean canGet() {
            if (this.getter != null) {
                return true;
            }
            return this.field != null && (this.field.getModifiers() & 1) != 0;
        }

        public boolean canSet() {
            if (this.setter != null) {
                return true;
            }
            return this.field != null && (this.field.getModifiers() & 1) != 0;
        }

        public Object getValue(Object instance) throws Exception {
            Object val = this.getter != null ? this.getter.invoke(instance, new Object[0]) : this.field.get(instance);
            return val;
        }

        public void setValue(Object instance, Object value) throws Exception {
            if (this.setter != null) {
                this.setter.invoke(instance, value);
            } else {
                this.field.set(instance, value);
            }
        }

        public Object instantiate(SerializationContext.AttributeContext context) throws Exception {
            return SerializationClass.instantiate(context.getAttribute().getType().getBase());
        }

        public boolean hasCustomInstantiation() {
            return false;
        }

        public <T extends Annotation> T getAnnotation(boolean onGet, Class<T> annotationType) {
            T a;
            if (this.field != null && (a = this.field.getAnnotation(annotationType)) != null) {
                return a;
            }
            if (onGet && this.getter != null && (a = this.getter.getAnnotation(annotationType)) != null) {
                return a;
            }
            if (!onGet && this.setter != null && (a = this.setter.getAnnotation(annotationType)) != null) {
                return a;
            }
            return null;
        }

        public List<Annotation> getAnnotations(boolean onGet) {
            LinkedList<Annotation> list = new LinkedList<Annotation>();
            if (this.field != null) {
                Collections.addAll(list, this.field.getAnnotations());
            }
            if (onGet && this.getter != null) {
                Collections.addAll(list, this.getter.getAnnotations());
            }
            if (!onGet && this.setter != null) {
                Collections.addAll(list, this.setter.getAnnotations());
            }
            return list;
        }
    }
}

