/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.provider;

import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.HashMap;
import java.util.Map;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.provider.FileIOProvider;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFrom;

public class IOProviderFromURL
implements IOProviderFrom<URL> {
    private static IOProviderFromURL instance = new IOProviderFromURL();
    private Map<String, IOProviderFrom<URL>> protocols = new HashMap<String, IOProviderFrom<URL>>();

    public static IOProviderFromURL getInstance() {
        return instance;
    }

    public void registerProtocol(String protocol, IOProviderFrom<URL> provider) {
        this.protocols.put(protocol.toLowerCase(), provider);
    }

    private IOProviderFromURL() {
        this.protocols.put("file", new IOProviderFrom<URL>(){

            @Override
            public IOProvider get(URL from) {
                File file;
                try {
                    file = new File(from.toURI());
                }
                catch (Exception e) {
                    return null;
                }
                if (!file.exists()) {
                    return null;
                }
                return new FileIOProvider(file);
            }
        });
    }

    @Override
    public IOProvider get(final URL from) {
        String protocol = from.getProtocol().toLowerCase();
        IOProviderFrom<URL> p = this.protocols.get(protocol);
        if (p != null) {
            return p.get(from);
        }
        return new IOProvider.Readable(){

            @Override
            public String getDescription() {
                return from.toString();
            }

            @Override
            public IO.Readable provideIOReadable(byte priority) throws IOException {
                InputStream in = from.openStream();
                return new IOFromInputStream(in, from.toString(), Threading.getUnmanagedTaskManager(), priority);
            }
        };
    }
}

