/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.provider;

import java.io.FileNotFoundException;
import java.io.InputStream;
import java.lang.reflect.Method;
import java.net.URL;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFrom;
import net.lecousin.framework.util.ClassUtil;

public class IOProviderFromPathUsingClassloader
implements IOProviderFrom.Readable<String> {
    private ClassLoader loader;

    public IOProviderFromPathUsingClassloader(ClassLoader loader) {
        this.loader = loader;
    }

    @Override
    public IOProvider.Readable get(String path) {
        URL url;
        Method m;
        if (path.startsWith("/")) {
            path = path.substring(1);
        }
        if (this.loader instanceof IOProviderFrom.Readable && (m = ClassUtil.getMethodFor(this.loader.getClass(), "get", String.class)) != null) {
            IOProvider.Readable provider;
            try {
                provider = (IOProvider.Readable)m.invoke((Object)this.loader, path);
            }
            catch (Throwable t) {
                provider = null;
            }
            if (provider != null) {
                return provider;
            }
        }
        if ((url = this.loader.getResource(path)) == null) {
            return null;
        }
        final String p = path;
        return new IOProvider.Readable(){

            @Override
            public IO.Readable provideIOReadable(byte priority) throws FileNotFoundException {
                InputStream in = IOProviderFromPathUsingClassloader.this.loader.getResourceAsStream(p);
                if (in == null) {
                    throw new FileNotFoundException(p);
                }
                return new IOFromInputStream(in, p, Threading.getUnmanagedTaskManager(), priority);
            }

            @Override
            public String getDescription() {
                return p;
            }
        };
    }
}

