/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io.buffering;

import java.io.IOException;
import java.nio.ByteBuffer;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.util.ConcurrentCloseable;

public class BufferedReverseIOReading
extends ConcurrentCloseable
implements IO.ReadableByteStream {
    private IO.Readable.Seekable io;
    private byte[] buffer;
    private IOException error = null;
    private long fileSize;
    private long bufferPosInFile;
    private int posInBuffer = 0;
    private int minInBuffer = 0;
    private int maxInBuffer = 0;
    private SynchronizationPoint<IOException> canRead = new SynchronizationPoint();
    private AsyncWork<Integer, IOException> currentRead = null;

    public <T extends IO.Readable.Seekable & IO.KnownSize> BufferedReverseIOReading(final T io, int bufferSize) {
        this.io = io;
        this.buffer = new byte[bufferSize];
        ((IO.KnownSize)io).getSizeAsync().listenInline(new AsyncWork.AsyncWorkListener<Long, IOException>(){

            @Override
            public void ready(Long result) {
                BufferedReverseIOReading.this.operation(new Task.Cpu.FromRunnable("Read last buffer", io.getPriority(), () -> {
                    BufferedReverseIOReading bufferedReverseIOReading = BufferedReverseIOReading.this;
                    synchronized (bufferedReverseIOReading) {
                        BufferedReverseIOReading.this.fileSize = (BufferedReverseIOReading.this.bufferPosInFile = result);
                        BufferedReverseIOReading.this.readBufferBack();
                    }
                }).start().getOutput());
            }

            @Override
            public void error(IOException error) {
                BufferedReverseIOReading.this.error = error;
            }

            @Override
            public void cancelled(CancelException event) {
            }
        });
    }

    public SynchronizationPoint<IOException> canStartReading() {
        return this.canRead;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void stop() {
        BufferedReverseIOReading bufferedReverseIOReading = this;
        synchronized (bufferedReverseIOReading) {
            if (this.currentRead != null) {
                this.currentRead.unblockCancel(new CancelException("BufferedReverseIO stopped"));
            }
        }
        this.canRead.block(0L);
    }

    public long getSize() {
        return this.fileSize;
    }

    @Override
    public byte getPriority() {
        return this.io.getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        this.io.setPriority(priority);
    }

    @Override
    public IO getWrappedIO() {
        return this.io;
    }

    @Override
    public String getSourceDescription() {
        return this.io.getSourceDescription();
    }

    @Override
    public TaskManager getTaskManager() {
        return Threading.getCPUTaskManager();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        BufferedReverseIOReading bufferedReverseIOReading = this;
        synchronized (bufferedReverseIOReading) {
            if (this.currentRead != null) {
                this.currentRead.unblockCancel(new CancelException("BufferedReverseIO stopped"));
            }
        }
        return this.io.closeAsync();
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.buffer = null;
        this.io = null;
        if (!this.canRead.isUnblocked()) {
            this.canRead.cancel(new CancelException("IO Closed"));
        }
        ondone.unblock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public int readReverse() throws IOException {
        int b;
        do {
            this.canRead.block(0L);
            BufferedReverseIOReading bufferedReverseIOReading = this;
            synchronized (bufferedReverseIOReading) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.io == null) {
                    throw new IOException("IO closed");
                }
                if (this.bufferPosInFile == 0L && this.posInBuffer == this.minInBuffer) {
                    return -1;
                }
                if (this.posInBuffer == this.minInBuffer) {
                    if (this.currentRead != null) {
                        this.canRead.restart();
                    } else {
                        this.readBufferBack();
                    }
                    b = -1;
                } else {
                    b = this.buffer[--this.posInBuffer] & 0xFF;
                    if (this.currentRead == null && this.posInBuffer < this.buffer.length / 2 && this.bufferPosInFile > 0L) {
                        this.readBufferBack();
                    }
                }
            }
        } while (b == -1);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int read() throws IOException {
        int b;
        do {
            this.canRead.block(0L);
            BufferedReverseIOReading bufferedReverseIOReading = this;
            synchronized (bufferedReverseIOReading) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.io == null) {
                    throw new IOException("IO closed");
                }
                if (this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer) == this.fileSize && this.posInBuffer == this.maxInBuffer) {
                    return -1;
                }
                if (this.posInBuffer == this.maxInBuffer) {
                    if (this.currentRead != null) {
                        this.canRead.restart();
                    } else {
                        this.readBufferForward();
                    }
                    b = -1;
                } else {
                    b = this.buffer[this.posInBuffer++] & 0xFF;
                    if (this.currentRead == null && this.posInBuffer > this.buffer.length / 2 && this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer) < this.fileSize) {
                        this.readBufferForward();
                    }
                }
            }
        } while (b == -1);
        return b;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public int read(byte[] buffer, int offset, int len) throws IOException {
        while (true) {
            this.canRead.block(0L);
            BufferedReverseIOReading bufferedReverseIOReading = this;
            synchronized (bufferedReverseIOReading) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.io == null) {
                    throw new IOException("IO closed");
                }
                if (this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer) == this.fileSize && this.posInBuffer == this.maxInBuffer) {
                    return -1;
                }
                if (this.posInBuffer != this.maxInBuffer) break;
                if (this.currentRead != null) {
                    this.canRead.restart();
                } else {
                    this.readBufferForward();
                }
            }
        }
        {
            if (len > this.maxInBuffer - this.posInBuffer) {
                len = this.maxInBuffer - this.posInBuffer;
            }
            System.arraycopy(this.buffer, this.posInBuffer, buffer, offset, len);
            this.posInBuffer += len;
            if (this.currentRead == null && this.posInBuffer > buffer.length / 2 && this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer) < this.fileSize) {
                this.readBufferForward();
            }
            return len;
        }
    }

    @Override
    public int readFully(byte[] buffer) throws IOException {
        return IOUtil.readFully(this, buffer);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public int skip(int skip) throws IOException {
        int done = 0;
        while (true) {
            this.canRead.block(0L);
            BufferedReverseIOReading bufferedReverseIOReading = this;
            synchronized (bufferedReverseIOReading) {
                if (this.error != null) {
                    throw this.error;
                }
                if (this.io == null) {
                    throw new IOException("IO closed");
                }
                if (this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer) == this.fileSize && this.posInBuffer == this.maxInBuffer) {
                    return done;
                }
                if (this.posInBuffer == this.maxInBuffer) {
                    if (this.currentRead != null) {
                        this.canRead.restart();
                    } else {
                        this.readBufferForward();
                    }
                    continue;
                }
                int len = skip - done;
                if (len > this.maxInBuffer - this.posInBuffer) {
                    len = this.maxInBuffer - this.posInBuffer;
                }
                this.posInBuffer += len;
                done += len;
                if (this.currentRead == null && this.posInBuffer > this.buffer.length / 2 && this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer) < this.fileSize) {
                    this.readBufferForward();
                }
                if (done == skip) {
                    return done;
                }
            }
        }
    }

    private void readBufferBack() {
        int start;
        int len;
        if (this.posInBuffer > this.minInBuffer) {
            len = this.buffer.length - (this.posInBuffer - this.minInBuffer);
            System.arraycopy(this.buffer, this.minInBuffer, this.buffer, len, this.posInBuffer - this.minInBuffer);
            this.minInBuffer = len;
            this.posInBuffer = this.buffer.length;
            this.maxInBuffer = this.buffer.length;
        } else {
            len = this.buffer.length;
            this.minInBuffer = this.buffer.length;
            this.maxInBuffer = this.buffer.length;
            this.posInBuffer = this.buffer.length;
            this.canRead.restart();
        }
        if (this.bufferPosInFile - (long)len < 0L) {
            start = (int)((long)len - this.bufferPosInFile);
            len = (int)this.bufferPosInFile;
        } else {
            start = 0;
        }
        ByteBuffer buf = ByteBuffer.wrap(this.buffer, start, len);
        this.currentRead = this.io.readFullyAsync(this.bufferPosInFile - (long)len, buf);
        this.currentRead.listenAsync(this.operation(new Task.Cpu.FromRunnable("New buffer ready", this.io.getPriority(), () -> {
            BufferedReverseIOReading bufferedReverseIOReading = this;
            synchronized (bufferedReverseIOReading) {
                if (!this.currentRead.isSuccessful()) {
                    this.error = this.currentRead.getError();
                } else {
                    int nb = this.currentRead.getResult();
                    this.bufferPosInFile -= (long)nb;
                    this.minInBuffer -= nb;
                }
                this.currentRead = null;
            }
            this.canRead.unblock();
        })), true);
    }

    private void readBufferForward() {
        int start;
        if (this.posInBuffer < this.maxInBuffer) {
            start = this.maxInBuffer - this.posInBuffer;
            System.arraycopy(this.buffer, this.posInBuffer, this.buffer, 0, start);
            this.maxInBuffer = start;
            this.bufferPosInFile += (long)(this.posInBuffer - this.minInBuffer);
            this.posInBuffer = 0;
            this.minInBuffer = 0;
        } else {
            start = 0;
            this.bufferPosInFile += (long)(this.maxInBuffer - this.minInBuffer);
            this.minInBuffer = 0;
            this.maxInBuffer = 0;
            this.posInBuffer = 0;
            this.canRead.reset();
        }
        int len = this.buffer.length - start;
        if (this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer) + (long)len > this.fileSize) {
            len = (int)(this.fileSize - (this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer)));
        }
        ByteBuffer buf = ByteBuffer.wrap(this.buffer, start, len);
        this.currentRead = this.io.readFullyAsync(this.bufferPosInFile + (long)(this.maxInBuffer - this.minInBuffer), buf);
        this.currentRead.listenAsync(this.operation(new Task.Cpu.FromRunnable("New buffer ready", this.io.getPriority(), () -> {
            BufferedReverseIOReading bufferedReverseIOReading = this;
            synchronized (bufferedReverseIOReading) {
                if (!this.currentRead.isSuccessful()) {
                    this.error = this.currentRead.getError();
                } else {
                    int nb = this.currentRead.getResult();
                    this.maxInBuffer += nb;
                }
                this.currentRead = null;
            }
            this.canRead.unblock();
        })), true);
    }
}

