/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.mutable.MutableLong;
import net.lecousin.framework.util.ConcurrentCloseable;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

public abstract class LinkedIO
extends ConcurrentCloseable
implements IO {
    protected String description;
    protected ArrayList<IO> ios;
    protected ArrayList<Long> sizes;
    protected int ioIndex = 0;
    protected long pos = 0L;
    protected long posInIO = 0L;

    protected LinkedIO(String description, IO[] ios) {
        this.description = description;
        this.ios = new ArrayList(ios.length);
        this.sizes = new ArrayList(ios.length);
        for (int i = 0; i < ios.length; ++i) {
            this.ios.add(ios[i]);
            if (ios[i] instanceof IO.KnownSize) {
                try {
                    this.sizes.add(((IO.KnownSize)ios[i]).getSizeSync());
                }
                catch (IOException e) {
                    this.sizes.add(null);
                }
                continue;
            }
            this.sizes.add(null);
        }
    }

    @Override
    public byte getPriority() {
        return this.ios.isEmpty() ? (byte)4 : this.ios.get(0).getPriority();
    }

    @Override
    public void setPriority(byte priority) {
        for (IO io : this.ios) {
            io.setPriority(priority);
        }
    }

    @Override
    public String getSourceDescription() {
        return this.description;
    }

    @Override
    public TaskManager getTaskManager() {
        return this.ios.isEmpty() ? Threading.getCPUTaskManager() : this.ios.get(0).getTaskManager();
    }

    @Override
    public IO getWrappedIO() {
        return null;
    }

    @Override
    protected ISynchronizationPoint<?> closeUnderlyingResources() {
        JoinPoint jp = new JoinPoint();
        for (IO io : this.ios) {
            jp.addToJoin(io.closeAsync());
        }
        jp.start();
        return jp;
    }

    @Override
    protected void closeResources(SynchronizationPoint<Exception> ondone) {
        this.ios = null;
        this.sizes = null;
        ondone.unblock();
    }

    protected abstract void nextIOSync() throws IOException;

    protected abstract void previousIOSync() throws IOException;

    protected abstract void nextIOAsync(Runnable var1, ISynchronizationPoint<IOException> var2, RunnableWithParameter var3);

    protected abstract void previousIOAsync(Runnable var1, ISynchronizationPoint<IOException> var2, RunnableWithParameter var3);

    protected void nextIOSyncStream() {
        ++this.ioIndex;
        this.posInIO = 0L;
    }

    protected void previousIOSyncStream() {
        --this.ioIndex;
        this.posInIO = this.sizes.get(this.ioIndex);
    }

    protected void nextIOAsyncStream(Runnable ondone) {
        ++this.ioIndex;
        this.posInIO = 0L;
        ondone.run();
    }

    protected void previousIOAsyncStream(Runnable ondone) {
        --this.ioIndex;
        this.posInIO = this.sizes.get(this.ioIndex);
        ondone.run();
    }

    protected void nextIOSyncSeekable() throws IOException {
        ++this.ioIndex;
        this.posInIO = 0L;
        if (this.ioIndex == this.ios.size()) {
            return;
        }
        ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
    }

    protected void previousIOSyncSeekable() throws IOException {
        --this.ioIndex;
        this.posInIO = this.sizes.get(this.ioIndex);
        ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekSync(IO.Seekable.SeekType.FROM_END, 0L);
    }

    protected void nextIOAsyncSeekable(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
        ++this.ioIndex;
        this.posInIO = 0L;
        AsyncWork<Long, IOException> seek = ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
        seek.listenInline(() -> {
            if (seek.hasError()) {
                if (rp != null) {
                    rp.run(new Pair(null, seek.getError()));
                }
                onerror.error((IOException)seek.getError());
            } else {
                ondone.run();
            }
        });
        this.operation(seek);
    }

    protected void previousIOAsyncSeekable(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
        --this.ioIndex;
        this.posInIO = this.sizes.get(this.ioIndex);
        AsyncWork<Long, IOException> seek = ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekAsync(IO.Seekable.SeekType.FROM_END, 0L);
        seek.listenInline(() -> {
            if (seek.hasError()) {
                if (rp != null) {
                    rp.run(new Pair(null, seek.getError()));
                }
                onerror.error((IOException)seek.getError());
            } else {
                ondone.run();
            }
        });
        this.operation(seek);
    }

    protected int readSync(ByteBuffer buffer) throws IOException {
        if (this.ioIndex == this.ios.size()) {
            return -1;
        }
        IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
        int nb = io.readSync(buffer);
        if (nb <= 0) {
            if (this.sizes.get(this.ioIndex) == null) {
                this.sizes.set(this.ioIndex, this.posInIO);
            }
            this.nextIOSync();
            return this.readSync(buffer);
        }
        this.posInIO += (long)nb;
        this.pos += (long)nb;
        return nb;
    }

    protected int readFullySync(ByteBuffer buffer) throws IOException {
        return IOUtil.readFully((IO.Readable)((Object)this), buffer);
    }

    protected AsyncWork<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (this.ioIndex == this.ios.size()) {
            return IOUtil.success(-1, ondone);
        }
        IO.Readable.Buffered io = (IO.Readable.Buffered)this.ios.get(this.ioIndex);
        AsyncWork<Integer, IOException> r = io.readFullySyncIfPossible(buffer);
        if (r.isUnblocked()) {
            if (!r.isSuccessful()) {
                if (ondone != null && r.hasError()) {
                    ondone.run(new Pair<Object, IOException>(null, r.getError()));
                }
                return r;
            }
            int nb3 = r.getResult();
            if (nb3 <= 0) {
                if (this.sizes.get(this.ioIndex) == null) {
                    this.sizes.set(this.ioIndex, this.posInIO);
                }
                return this.readFullyAsync(buffer, ondone);
            }
            this.posInIO += (long)nb3;
            this.pos += (long)nb3;
            if (!buffer.hasRemaining()) {
                if (ondone != null) {
                    ondone.run(new Pair<Integer, Object>(r.getResult(), null));
                }
                return r;
            }
            AsyncWork<Integer, IOException> r2 = new AsyncWork<Integer, IOException>();
            this.readFullySyncIfPossible(buffer, res -> {
                if (ondone == null) {
                    return;
                }
                if (res.getValue1() == null) {
                    ondone.run((Pair<Integer, IOException>)res);
                } else {
                    int n = (Integer)res.getValue1();
                    n = n < 0 ? nb3 : nb3 + n;
                    ondone.run(new Pair<Integer, Object>(n, null));
                }
            }).listenInline(nb2 -> {
                int n = nb2;
                n = n < 0 ? nb3 : nb3 + n;
                r2.unblockSuccess(n);
            }, r2);
            return r2;
        }
        AsyncWork<Integer, IOException> r2 = new AsyncWork<Integer, IOException>();
        r.listenInline(nb -> {
            int n = nb;
            if (n > 0) {
                this.posInIO += (long)n;
                this.pos += (long)n;
            }
            if (!buffer.hasRemaining()) {
                if (ondone != null) {
                    ondone.run(new Pair<Integer, Object>((Integer)nb, null));
                }
                r2.unblockSuccess((Integer)nb);
            } else {
                this.readFullyAsync(buffer, res -> {
                    if (ondone == null) {
                        return;
                    }
                    if (res.getValue1() == null) {
                        ondone.run((Pair<Integer, IOException>)res);
                    } else {
                        int n2;
                        int n1 = n;
                        if (n1 < 0) {
                            n1 = 0;
                        }
                        n2 = (n2 = ((Integer)res.getValue1()).intValue()) < 0 ? n1 : (n2 += n1);
                        ondone.run(new Pair<Integer, Object>(n2, null));
                    }
                }).listenInline(nb2 -> {
                    int n2;
                    int n1 = n;
                    if (n1 < 0) {
                        n1 = 0;
                    }
                    n2 = (n2 = nb2.intValue()) < 0 ? n1 : (n2 += n1);
                    r2.unblockSuccess(n2);
                }, (ISynchronizationPoint<IOException>)r2);
            }
        }, r2);
        return r2;
    }

    protected int readAsync() throws IOException {
        if (this.ioIndex == this.ios.size()) {
            return -1;
        }
        IO.Readable.Buffered io = (IO.Readable.Buffered)this.ios.get(this.ioIndex);
        int i = io.readAsync();
        if (i == -1) {
            if (this.sizes.get(this.ioIndex) == null) {
                this.sizes.set(this.ioIndex, this.posInIO);
            }
            this.nextIOSync();
            return this.readAsync();
        }
        if (i == -2) {
            return -2;
        }
        ++this.posInIO;
        ++this.pos;
        return i;
    }

    protected AsyncWork<Integer, IOException> readAsync(final ByteBuffer buffer, final RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        if (this.ioIndex == this.ios.size()) {
            return IOUtil.success(-1, ondone);
        }
        final AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
        IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
        AsyncWork<Integer, IOException> read = io.readAsync(buffer);
        this.operation(read).listenInline(new AsyncWork.AsyncWorkListenerReady((nb, that) -> {
            if (nb <= 0) {
                if (this.sizes.get(this.ioIndex) == null) {
                    this.sizes.set(this.ioIndex, this.posInIO);
                }
                if (this.ioIndex == this.ios.size() - 1) {
                    ++this.ioIndex;
                    this.posInIO = 0L;
                    IOUtil.success(-1, result, ondone);
                    return;
                }
                this.nextIOAsync(new Runnable(){

                    @Override
                    public void run() {
                        LinkedIO.this.readAsync(buffer, ondone).listenInline(result);
                    }
                }, result, ondone);
                return;
            }
            this.posInIO += (long)nb.intValue();
            this.pos += (long)nb.intValue();
            if (ondone != null) {
                ondone.run(new Pair<Integer, Object>((Integer)nb, null));
            }
            result.unblockSuccess((Integer)nb);
        }, result, ondone));
        return result;
    }

    protected AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync((IO.Readable)((Object)this), buffer, ondone);
    }

    protected AsyncWork<ByteBuffer, IOException> readNextBufferAsync(final RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
        if (this.ioIndex == this.ios.size()) {
            return IOUtil.success(null, ondone);
        }
        IO.Readable.Buffered io = (IO.Readable.Buffered)this.ios.get(this.ioIndex);
        final AsyncWork<ByteBuffer, IOException> result = new AsyncWork<ByteBuffer, IOException>();
        AsyncWork<ByteBuffer, IOException> read = io.readNextBufferAsync();
        this.operation(read).listenInline(new AsyncWork.AsyncWorkListenerReady((buf, that) -> {
            if (buf == null) {
                if (this.sizes.get(this.ioIndex) == null) {
                    this.sizes.set(this.ioIndex, this.posInIO);
                }
                if (this.ioIndex == this.ios.size() - 1) {
                    ++this.ioIndex;
                    this.posInIO = 0L;
                    IOUtil.success(null, result, ondone);
                    return;
                }
                this.nextIOAsync(new Runnable(){

                    @Override
                    public void run() {
                        LinkedIO.this.readNextBufferAsync(ondone).listenInline(result);
                    }
                }, result, ondone);
                return;
            }
            this.posInIO += (long)buf.remaining();
            this.pos += (long)buf.remaining();
            if (ondone != null) {
                ondone.run(new Pair<ByteBuffer, Object>((ByteBuffer)buf, null));
            }
            result.unblockSuccess((ByteBuffer)buf);
        }, result, ondone));
        return result;
    }

    protected long skipSync(long n) throws IOException {
        if (n == 0L) {
            return 0L;
        }
        if (n > 0L) {
            if (this.ioIndex == this.ios.size()) {
                return 0L;
            }
            IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
            long nb = io.skipSync(n);
            this.posInIO += nb;
            this.pos += nb;
            if (nb == n) {
                return n;
            }
            if (this.sizes.get(this.ioIndex) == null) {
                this.sizes.set(this.ioIndex, this.posInIO);
            }
            this.nextIOSync();
            return nb + this.skipSync(n - nb);
        }
        if (!(this instanceof IO.Readable.Seekable)) {
            return 0L;
        }
        if (this.posInIO == 0L) {
            if (this.ioIndex == 0) {
                return 0L;
            }
            this.previousIOSync();
            return this.skipSync(n);
        }
        IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
        long nb = io.skipSync(n);
        if (nb == 0L) {
            return 0L;
        }
        this.posInIO += nb;
        this.pos += nb;
        if (nb == n) {
            return n;
        }
        if (this.posInIO == 0L) {
            if (this.ioIndex == 0) {
                return nb;
            }
            this.previousIOSync();
        }
        return nb + this.skipSync(n - nb);
    }

    protected AsyncWork<Long, IOException> skipAsync(final long n, final RunnableWithParameter<Pair<Long, IOException>> ondone) {
        if (n == 0L) {
            return IOUtil.success(0L, ondone);
        }
        if (n > 0L) {
            if (this.ioIndex == this.ios.size()) {
                return IOUtil.success(0L, ondone);
            }
            IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
            final MutableLong done = new MutableLong(0L);
            AsyncWork<Long, IOException> skip = io.skipAsync(n);
            AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
            this.operation(skip).listenInline(new AsyncWork.AsyncWorkListenerReady((nb, that) -> {
                this.posInIO += nb.longValue();
                this.pos += (long)nb.intValue();
                done.add((long)nb);
                if (done.get() == n) {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(n, null));
                    }
                    result.unblockSuccess(n);
                    return;
                }
                if (this.sizes.get(this.ioIndex) == null) {
                    this.sizes.set(this.ioIndex, this.posInIO);
                }
                if (this.ioIndex == this.ios.size() - 1) {
                    ++this.ioIndex;
                    this.posInIO = 0L;
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(done.get(), null));
                    }
                    result.unblockSuccess(done.get());
                    return;
                }
                this.nextIOAsync(new Runnable(){

                    @Override
                    public void run() {
                        ((AsyncWork)LinkedIO.this.operation(((IO.Readable)LinkedIO.this.ios.get(LinkedIO.this.ioIndex)).skipAsync(n - done.get(), null))).listenInline(that);
                    }
                }, result, ondone);
            }, result, ondone));
            return result;
        }
        if (!(this instanceof IO.Readable.Seekable)) {
            return IOUtil.success(0L, ondone);
        }
        if (this.posInIO == 0L) {
            if (this.ioIndex == 0) {
                return IOUtil.success(0L, ondone);
            }
            final AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
            this.previousIOAsync(new Runnable(){

                @Override
                public void run() {
                    LinkedIO.this.skipAsync(n, ondone).listenInline(result);
                }
            }, result, ondone);
            return result;
        }
        IO.Readable io = (IO.Readable)this.ios.get(this.ioIndex);
        AsyncWork<Long, IOException> skip = io.skipAsync(n);
        final MutableLong done = new MutableLong(0L);
        final AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
        this.operation(skip).listenInline(new AsyncWork.AsyncWorkListener<Long, IOException>(){

            @Override
            public void ready(Long nb) {
                LinkedIO.this.posInIO += nb.longValue();
                LinkedIO.this.pos += (long)nb.intValue();
                done.add(nb);
                if (done.get() == n) {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(n, null));
                    }
                    result.unblockSuccess(n);
                    return;
                }
                if (LinkedIO.this.ioIndex == 0) {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(done.get(), null));
                    }
                    result.unblockSuccess(done.get());
                    return;
                }
                final 5 l = this;
                LinkedIO.this.previousIOAsync(new Runnable(){

                    @Override
                    public void run() {
                        ((IO.Readable)LinkedIO.this.ios.get(LinkedIO.this.ioIndex)).skipAsync(n - done.get(), null).listenInline(l);
                    }
                }, result, ondone);
            }

            @Override
            public void error(IOException error) {
                IOUtil.error(error, result, ondone);
            }

            @Override
            public void cancelled(CancelException event) {
                result.unblockCancel(event);
            }
        });
        return result;
    }

    protected int read() throws IOException {
        if (this.ioIndex == this.ios.size()) {
            return -1;
        }
        IO.Readable.Buffered io = (IO.Readable.Buffered)this.ios.get(this.ioIndex);
        int i = io.read();
        if (i < 0) {
            if (this.sizes.get(this.ioIndex) == null) {
                this.sizes.set(this.ioIndex, this.posInIO);
            }
            this.nextIOSync();
            return this.read();
        }
        ++this.posInIO;
        ++this.pos;
        return i;
    }

    protected int read(byte[] buf, int off, int len) throws IOException {
        return this.readFullySync(ByteBuffer.wrap(buf, off, len));
    }

    protected int readFully(byte[] buffer) throws IOException {
        return this.readFullySync(ByteBuffer.wrap(buffer));
    }

    protected int skip(int n) throws IOException {
        return (int)this.skipSync(n);
    }

    protected ISynchronizationPoint<IOException> canStartReading() {
        if (this.ioIndex == this.ios.size()) {
            return new SynchronizationPoint<boolean>(true);
        }
        return ((IO.Readable)this.ios.get(this.ioIndex)).canStartReading();
    }

    protected ISynchronizationPoint<IOException> canStartWriting() {
        if (this.ioIndex == this.ios.size()) {
            return new SynchronizationPoint<boolean>(true);
        }
        return ((IO.Writable)this.ios.get(this.ioIndex)).canStartWriting();
    }

    protected long getSizeSync() throws IOException {
        long total = 0L;
        for (IO io : this.ios) {
            total += ((IO.KnownSize)io).getSizeSync();
        }
        return total;
    }

    protected AsyncWork<Long, IOException> getSizeAsync() {
        AsyncWork[] sizes = new AsyncWork[this.ios.size()];
        for (int i = 0; i < this.ios.size(); ++i) {
            sizes[i] = ((IO.KnownSize)this.ios.get(i)).getSizeAsync();
        }
        JoinPoint jp = JoinPoint.fromSynchronizationPointsSimilarError(sizes);
        AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
        this.operation(jp).listenInline(() -> {
            long total = 0L;
            for (int i = 0; i < sizes.length; ++i) {
                total += ((Long)sizes[i].getResult()).longValue();
            }
            result.unblockSuccess(total);
        }, result);
        return result;
    }

    protected long getPosition() {
        return this.pos;
    }

    protected long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
        switch (type) {
            case FROM_CURRENT: {
                move += this.pos;
                break;
            }
            case FROM_BEGINNING: {
                break;
            }
            case FROM_END: {
                long p = 0L;
                for (int i = 0; i < this.ios.size(); ++i) {
                    if (this.sizes.get(i) == null) {
                        IO.Readable.Seekable io = (IO.Readable.Seekable)this.ios.get(i);
                        this.sizes.set(i, io.seekSync(IO.Seekable.SeekType.FROM_END, 0L));
                    }
                    p += this.sizes.get(i).longValue();
                }
                move = p - move;
                break;
            }
        }
        if (move < 0L) {
            move = 0L;
        }
        this.pos = 0L;
        this.ioIndex = 0;
        this.posInIO = 0L;
        if (move == 0L) {
            if (!this.ios.isEmpty()) {
                ((IO.Readable.Seekable)this.ios.get(0)).seekSync(IO.Seekable.SeekType.FROM_BEGINNING, 0L);
            }
            return 0L;
        }
        while (this.ioIndex < this.ios.size()) {
            Long s = this.sizes.get(this.ioIndex);
            if (s == null) {
                IO.Readable.Seekable io = (IO.Readable.Seekable)this.ios.get(this.ioIndex);
                s = io.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
                this.sizes.set(this.ioIndex, s);
            }
            if (this.pos + s > move) {
                this.posInIO = move - this.pos;
                this.pos = move;
                ((IO.Readable.Seekable)this.ios.get(this.ioIndex)).seekSync(IO.Seekable.SeekType.FROM_BEGINNING, this.posInIO);
                return move;
            }
            this.pos += s.longValue();
            ++this.ioIndex;
        }
        return this.pos;
    }

    protected AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        return this.operation(IOUtil.seekAsyncUsingSync((IO.Readable.Seekable)((Object)this), type, move, ondone).getOutput());
    }

    protected int readSync(long pos, ByteBuffer buffer) throws IOException {
        long p = 0L;
        for (int i = 0; i < this.ios.size(); ++i) {
            IO.Readable.Seekable io;
            Long s = this.sizes.get(i);
            if (s == null) {
                io = (IO.Readable.Seekable)this.ios.get(i);
                s = io.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
                this.sizes.set(i, s);
            }
            if (p + s > pos) {
                io = (IO.Readable.Seekable)this.ios.get(i);
                return io.readSync(pos - p, buffer);
            }
            p += s.longValue();
        }
        return -1;
    }

    protected AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        long p = 0L;
        for (int i = 0; i < this.ios.size(); ++i) {
            IO.Readable.Seekable io;
            Long s = this.sizes.get(i);
            if (s == null) {
                io = (IO.Readable.Seekable)this.ios.get(i);
                AsyncWork<Long, IOException> seek = io.seekAsync(IO.Seekable.SeekType.FROM_END, 0L);
                if (!seek.isUnblocked()) {
                    AsyncWork result = new AsyncWork();
                    int ii = i;
                    seek.listenAsync(new Task.Cpu.FromRunnable("LinkedIO.readAsync", this.getPriority(), () -> {
                        this.sizes.set(ii, (Long)seek.getResult());
                        this.readAsync(pos, buffer, ondone).listenInline(result);
                    }), result);
                    return this.operation(result);
                }
                s = seek.getResult();
                this.sizes.set(i, s);
            }
            if (p + s > pos) {
                io = (IO.Readable.Seekable)this.ios.get(i);
                return this.operation(io.readAsync(pos - p, buffer, ondone));
            }
            p += s.longValue();
        }
        if (ondone != null) {
            ondone.run(new Pair<Integer, Object>(-1, null));
        }
        return new AsyncWork<Integer, Object>(-1, null);
    }

    protected int readFullySync(long pos, ByteBuffer buffer) throws IOException {
        return IOUtil.readFullySync((IO.Readable.Seekable)((Object)this), pos, buffer);
    }

    protected AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return this.operation(IOUtil.readFullyAsync((IO.Readable.Seekable)((Object)this), pos, buffer, ondone));
    }

    protected int writeSync(ByteBuffer buffer) throws IOException {
        int done = 0;
        while (this.ioIndex < this.ios.size()) {
            Long s = this.sizes.get(this.ioIndex);
            IO.Writable.Seekable io = (IO.Writable.Seekable)this.ios.get(this.ioIndex);
            if (s == null) {
                s = io.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
                this.sizes.set(this.ioIndex, s);
                io.seekSync(IO.Seekable.SeekType.FROM_BEGINNING, this.posInIO);
            }
            if (this.posInIO < s) {
                int len = (int)(s - this.posInIO);
                int limit = buffer.limit();
                if (buffer.remaining() > len) {
                    buffer.limit(limit - (buffer.remaining() - len));
                }
                int nb = io.writeSync(buffer);
                buffer.limit(limit);
                this.posInIO += (long)nb;
                done += nb;
                this.pos += (long)nb;
                if (!buffer.hasRemaining()) {
                    return done;
                }
            }
            this.nextIOSync();
        }
        return done;
    }

    protected int writeSync(long pos, ByteBuffer buffer) throws IOException {
        long p = 0L;
        int done = 0;
        for (int i = 0; i < this.ios.size(); ++i) {
            IO.Writable.Seekable io;
            Long s = this.sizes.get(i);
            if (s == null) {
                io = (IO.Writable.Seekable)this.ios.get(i);
                s = io.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
                this.sizes.set(i, s);
            }
            if (p + s > pos) {
                io = (IO.Writable.Seekable)this.ios.get(i);
                int len = (int)(s - (pos - p));
                int limit = buffer.limit();
                if (buffer.remaining() > len) {
                    buffer.limit(limit - (buffer.remaining() - len));
                }
                int nb = io.writeSync(pos - p, buffer);
                buffer.limit(limit);
                done += nb;
                pos += (long)nb;
                if (!buffer.hasRemaining()) {
                    return done;
                }
            }
            p += s.longValue();
        }
        return done;
    }

    protected AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
        this.writeAsync(buffer, 0, result, ondone);
        return this.operation(result);
    }

    private void writeAsync(ByteBuffer buffer, int done, AsyncWork<Integer, IOException> result, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Long, IOException> seek;
        if (this.ioIndex == this.ios.size()) {
            IOUtil.success(done, result, ondone);
            return;
        }
        IO.Writable.Seekable io = (IO.Writable.Seekable)this.ios.get(this.ioIndex);
        Long s = this.sizes.get(this.ioIndex);
        if (s == null) {
            AsyncWork<Long, IOException> seek2 = io.seekAsync(IO.Seekable.SeekType.FROM_END, 0L);
            if (!seek2.isUnblocked()) {
                seek2.listenAsync(new Task.Cpu.FromRunnable("LinkedIO.writeAsync", this.getPriority(), () -> {
                    if (seek2.hasError()) {
                        IOUtil.error(seek2.getError(), result, ondone);
                    } else {
                        this.sizes.set(this.ioIndex, (Long)seek2.getResult());
                        this.writeAsync(buffer, done, result, ondone);
                    }
                }), true);
                return;
            }
            s = seek2.getResult();
            this.sizes.set(this.ioIndex, s);
        }
        if (this.posInIO == s) {
            this.nextIOAsync(() -> this.writeAsync(buffer, done, result, ondone), result, ondone);
            return;
        }
        int len = (int)(s - this.posInIO);
        int limit = buffer.limit();
        if (buffer.remaining() > len) {
            buffer.limit(limit - (buffer.remaining() - len));
        }
        if ((seek = io.seekAsync(IO.Seekable.SeekType.FROM_BEGINNING, this.posInIO)).isUnblocked()) {
            this.writeAsync(io, limit, buffer, done, result, ondone);
        } else {
            seek.listenInline(() -> {
                if (seek.hasError()) {
                    IOUtil.error(seek.getError(), result, ondone);
                } else {
                    this.writeAsync(io, limit, buffer, done, result, ondone);
                }
            });
        }
    }

    private void writeAsync(IO.Writable.Seekable io, int limit, ByteBuffer buffer, int done, AsyncWork<Integer, IOException> result, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> write = io.writeAsync(buffer);
        write.listenAsync(new Task.Cpu.FromRunnable("LinkedIO.writeAsync", this.getPriority(), () -> {
            buffer.limit(limit);
            if (write.hasError()) {
                IOUtil.error(write.getError(), result, ondone);
                return;
            }
            int nb = (Integer)write.getResult();
            this.posInIO += (long)nb;
            this.pos += (long)nb;
            if (!buffer.hasRemaining() || this.ioIndex == this.ios.size() - 1) {
                IOUtil.success(done + nb, result, ondone);
                return;
            }
            this.writeAsync(buffer, done + nb, result, ondone);
        }), true);
    }

    protected AsyncWork<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        long p = 0L;
        for (int i = 0; i < this.ios.size(); ++i) {
            Long s = this.sizes.get(i);
            if (s == null) {
                IO.Writable.Seekable io = (IO.Writable.Seekable)this.ios.get(i);
                AsyncWork<Long, IOException> seek = io.seekAsync(IO.Seekable.SeekType.FROM_END, 0L);
                if (!seek.isUnblocked()) {
                    AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
                    int ii = i;
                    seek.listenAsync(new Task.Cpu.FromRunnable("LinkedIO.writeAsync", this.getPriority(), () -> {
                        this.sizes.set(ii, (Long)seek.getResult());
                        this.writeAsync(pos, buffer, ondone).listenInline(result);
                    }), result);
                    return result;
                }
                s = seek.getResult();
                this.sizes.set(i, s);
            }
            if (p + s > pos) {
                AsyncWork<Integer, IOException> result = new AsyncWork<Integer, IOException>();
                this.writeAsync(i, p, pos, 0, buffer, result, ondone);
                return result;
            }
            p += s.longValue();
        }
        if (ondone != null) {
            ondone.run(new Pair<Integer, Object>(-1, null));
        }
        return new AsyncWork<Integer, Object>(-1, null);
    }

    private void writeAsync(int i, long p, long pos, int done, ByteBuffer buffer, AsyncWork<Integer, IOException> result, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        IO.Writable.Seekable io = (IO.Writable.Seekable)this.ios.get(i);
        Long s = this.sizes.get(i);
        if (s == null) {
            AsyncWork<Long, IOException> seek = io.seekAsync(IO.Seekable.SeekType.FROM_END, 0L);
            if (!seek.isUnblocked()) {
                seek.listenAsync(new Task.Cpu.FromRunnable("LinkedIO.writeAsync", this.getPriority(), () -> {
                    this.sizes.set(i, (Long)seek.getResult());
                    this.writeAsync(i, p, pos, done, buffer, result, ondone);
                }), result);
                return;
            }
            s = seek.getResult();
            this.sizes.set(i, s);
        }
        int len = (int)(s - (pos - p));
        int limit = buffer.limit();
        if (buffer.remaining() > len) {
            buffer.limit(limit - (buffer.remaining() - len));
        }
        AsyncWork<Integer, IOException> write = io.writeAsync(pos - p, buffer);
        long ioSize = s;
        write.listenInline(() -> {
            buffer.limit(limit);
            if (write.hasError()) {
                IOUtil.error(write.getError(), result, ondone);
                return;
            }
            int nb = (Integer)write.getResult();
            if (!buffer.hasRemaining() || i == this.ios.size() - 1) {
                IOUtil.success(done + nb, result, ondone);
                return;
            }
            new Task.Cpu.FromRunnable("LinkedIO.writeAsync", this.getPriority(), () -> this.writeAsync(i + 1, p + ioSize, p + ioSize, done + nb, buffer, result, ondone)).start();
        });
    }

    public static class ReadWrite
    extends Readable.Seekable
    implements IO.Writable.Seekable {
        @SafeVarargs
        public <T extends IO.Readable.Seekable & IO.Writable.Seekable> ReadWrite(String description, T ... ios) {
            super(description, (IO.Readable.Seekable[])ios);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartWriting() {
            return super.canStartWriting();
        }

        @Override
        public int writeSync(long pos, ByteBuffer buffer) throws IOException {
            return super.writeSync(pos, buffer);
        }

        @Override
        public int writeSync(ByteBuffer buffer) throws IOException {
            return super.writeSync(buffer);
        }

        @Override
        public AsyncWork<Integer, IOException> writeAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(pos, buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> writeAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.writeAsync(buffer, ondone);
        }
    }

    public static class Readable
    extends LinkedIO
    implements IO.Readable {
        public Readable(String description, IO.Readable ... ios) {
            super(description, ios);
        }

        @Override
        protected void nextIOSync() throws IOException {
            this.nextIOSyncStream();
        }

        @Override
        protected void nextIOAsync(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
            this.nextIOAsyncStream(ondone);
        }

        @Override
        protected void previousIOSync() throws IOException {
            this.previousIOSyncStream();
        }

        @Override
        protected void previousIOAsync(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
            this.previousIOAsyncStream(ondone);
        }

        @Override
        public ISynchronizationPoint<IOException> canStartReading() {
            return super.canStartReading();
        }

        @Override
        public AsyncWork<Integer, IOException> readAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readAsync(buffer, ondone);
        }

        @Override
        public AsyncWork<Integer, IOException> readFullyAsync(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
            return super.readFullyAsync(buffer, ondone);
        }

        @Override
        public int readSync(ByteBuffer buffer) throws IOException {
            return super.readSync(buffer);
        }

        @Override
        public int readFullySync(ByteBuffer buffer) throws IOException {
            return super.readFullySync(buffer);
        }

        @Override
        public long skipSync(long n) throws IOException {
            return super.skipSync(n);
        }

        @Override
        public AsyncWork<Long, IOException> skipAsync(long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
            return super.skipAsync(n, ondone);
        }

        public static class Seekable
        extends Readable
        implements IO.Readable.Seekable {
            public Seekable(String description, IO.Readable.Seekable ... ios) {
                super(description, ios);
            }

            @Override
            protected void nextIOSync() throws IOException {
                this.nextIOSyncSeekable();
            }

            @Override
            protected void nextIOAsync(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
                this.nextIOAsyncSeekable(ondone, onerror, rp);
            }

            @Override
            protected void previousIOSync() throws IOException {
                this.previousIOSyncSeekable();
            }

            @Override
            protected void previousIOAsync(Runnable ondone, ISynchronizationPoint<IOException> onerror, RunnableWithParameter rp) {
                this.previousIOAsyncSeekable(ondone, onerror, rp);
            }

            @Override
            public long getPosition() {
                return super.getPosition();
            }

            @Override
            public long seekSync(IO.Seekable.SeekType type, long move) throws IOException {
                return super.seekSync(type, move);
            }

            @Override
            public AsyncWork<Long, IOException> seekAsync(IO.Seekable.SeekType type, long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
                return super.seekAsync(type, move, ondone);
            }

            @Override
            public int readSync(long pos, ByteBuffer buffer) throws IOException {
                return super.readSync(pos, buffer);
            }

            @Override
            public AsyncWork<Integer, IOException> readAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return super.readAsync(pos, buffer, ondone);
            }

            @Override
            public int readFullySync(long pos, ByteBuffer buffer) throws IOException {
                return super.readFullySync(pos, buffer);
            }

            @Override
            public AsyncWork<Integer, IOException> readFullyAsync(long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return super.readFullyAsync(pos, buffer, ondone);
            }

            public static class DeterminedSize
            extends Seekable
            implements IO.KnownSize {
                public DeterminedSize(String description, IO.Readable.Seekable ... ios) {
                    super(description, ios);
                }

                @Override
                public long getSizeSync() throws IOException {
                    return super.getSizeSync();
                }

                @Override
                public AsyncWork<Long, IOException> getSizeAsync() {
                    return super.getSizeAsync();
                }
            }

            public static class Buffered
            extends Seekable
            implements IO.Readable.Buffered {
                public Buffered(String description, IO.Readable.Seekable ... ios) {
                    super(description, ios);
                }

                @Override
                public int read() throws IOException {
                    return super.read();
                }

                @Override
                public int read(byte[] buf, int off, int len) throws IOException {
                    return super.read(buf, off, len);
                }

                @Override
                public int readFully(byte[] buffer) throws IOException {
                    return super.readFully(buffer);
                }

                @Override
                public AsyncWork<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                    return super.readFullySyncIfPossible(buffer, ondone);
                }

                @Override
                public int readAsync() throws IOException {
                    return super.readAsync();
                }

                @Override
                public int skip(int n) throws IOException {
                    return super.skip(n);
                }

                @Override
                public ISynchronizationPoint<IOException> canStartReading() {
                    return super.canStartReading();
                }

                @Override
                public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
                    return super.readNextBufferAsync(ondone);
                }

                public static class DeterminedSize
                extends Buffered
                implements IO.KnownSize {
                    public DeterminedSize(String description, IO.Readable.Seekable ... ios) {
                        super(description, ios);
                    }

                    @Override
                    public long getSizeSync() throws IOException {
                        return super.getSizeSync();
                    }

                    @Override
                    public AsyncWork<Long, IOException> getSizeAsync() {
                        return super.getSizeAsync();
                    }
                }
            }
        }

        public static class DeterminedSize
        extends Readable
        implements IO.KnownSize {
            public DeterminedSize(String description, IO.Readable ... ios) {
                super(description, ios);
            }

            @Override
            public long getSizeSync() throws IOException {
                return super.getSizeSync();
            }

            @Override
            public AsyncWork<Long, IOException> getSizeAsync() {
                return super.getSizeAsync();
            }
        }

        public static class Buffered
        extends Readable
        implements IO.Readable.Buffered {
            public Buffered(String description, IO.Readable.Buffered ... ios) {
                super(description, ios);
            }

            @Override
            public int read() throws IOException {
                return super.read();
            }

            @Override
            public int read(byte[] buf, int off, int len) throws IOException {
                return super.read(buf, off, len);
            }

            @Override
            public int readFully(byte[] buffer) throws IOException {
                return super.readFully(buffer);
            }

            @Override
            public AsyncWork<Integer, IOException> readFullySyncIfPossible(ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
                return super.readFullySyncIfPossible(buffer, ondone);
            }

            @Override
            public int readAsync() throws IOException {
                return super.readAsync();
            }

            @Override
            public int skip(int n) throws IOException {
                return super.skip(n);
            }

            @Override
            public ISynchronizationPoint<IOException> canStartReading() {
                return super.canStartReading();
            }

            @Override
            public AsyncWork<ByteBuffer, IOException> readNextBufferAsync(RunnableWithParameter<Pair<ByteBuffer, IOException>> ondone) {
                return super.readNextBufferAsync(ondone);
            }

            public static class DeterminedSize
            extends Buffered
            implements IO.KnownSize {
                public DeterminedSize(String description, IO.Readable.Buffered ... ios) {
                    super(description, ios);
                }

                @Override
                public long getSizeSync() throws IOException {
                    return super.getSizeSync();
                }

                @Override
                public AsyncWork<Long, IOException> getSizeAsync() {
                    return super.getSizeAsync();
                }
            }
        }
    }
}

