/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.io;

import java.io.Closeable;
import java.io.File;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.TaskManager;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.TemporaryFiles;
import net.lecousin.framework.io.buffering.ByteBuffersIO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.buffering.SimpleBufferedReadable;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.mutable.Mutable;
import net.lecousin.framework.mutable.MutableInteger;
import net.lecousin.framework.mutable.MutableLong;
import net.lecousin.framework.progress.WorkProgress;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;
import net.lecousin.framework.util.UnprotectedString;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public final class IOUtil {
    private IOUtil() {
    }

    public static int readFully(IO.Readable io, ByteBuffer buffer) throws IOException {
        int nb;
        int read = 0;
        while (buffer.hasRemaining() && (nb = io.readSync(buffer)) > 0) {
            read += nb;
        }
        return read;
    }

    public static int readFully(IO.ReadableByteStream io, byte[] buffer) throws IOException {
        return IOUtil.readFully(io, buffer, 0, buffer.length);
    }

    public static int readFully(IO.ReadableByteStream io, byte[] buffer, int off, int len) throws IOException {
        int read;
        int nb;
        for (read = 0; read < len && (nb = io.read(buffer, off + read, len - read)) > 0; read += nb) {
        }
        return read;
    }

    public static void readFully(IO.Readable io, AsyncWork<byte[], IOException> result) {
        if (io instanceof IO.KnownSize) {
            AsyncWork<Long, IOException> getSize = ((IO.KnownSize)((Object)io)).getSizeAsync();
            Runnable launchRead = () -> {
                if (getSize.hasError()) {
                    result.error((IOException)getSize.getError());
                } else if (getSize.isCancelled()) {
                    result.cancel(getSize.getCancelEvent());
                } else {
                    byte[] bytes;
                    long size = (Long)getSize.getResult();
                    if (size > Integer.MAX_VALUE) {
                        result.error(new IOException("IO too large to be read into memory"));
                        return;
                    }
                    try {
                        bytes = new byte[(int)size];
                    }
                    catch (Throwable t) {
                        result.error(IO.error(t));
                        return;
                    }
                    IOUtil.readFullyAsync(io, ByteBuffer.wrap(bytes), r -> {
                        if (r.getValue2() != null) {
                            result.error((IOException)((Exception)r.getValue2()));
                        } else {
                            result.unblockSuccess(bytes);
                        }
                    });
                }
            };
            if (getSize.isUnblocked()) {
                launchRead.run();
                return;
            }
            getSize.listenAsync(new Task.Cpu.FromRunnable("readFully", io.getPriority(), launchRead), true);
            return;
        }
        AsyncWork<ByteBuffersIO, IOException> read = IOUtil.readFullyAsync(io, 65536);
        read.listenAsync(new Task.Cpu.FromRunnable("readFully: convert ByteArraysIO into byte[]", io.getPriority(), () -> {
            if (read.hasError()) {
                result.error((IOException)read.getError());
            } else if (read.isCancelled()) {
                result.cancel(read.getCancelEvent());
            } else {
                result.unblockSuccess(((ByteBuffersIO)read.getResult()).createSingleByteArray());
            }
        }), result);
    }

    public static int readFullySync(IO.Readable.Seekable io, long pos, ByteBuffer buffer) throws IOException {
        int nb;
        int read = 0;
        while (buffer.hasRemaining() && (nb = io.readSync(pos, buffer)) > 0) {
            read += nb;
            pos += (long)nb;
        }
        return read;
    }

    public static AsyncWork<Integer, IOException> readFullyAsync(IO.Readable io, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        return IOUtil.readFullyAsync(io, buffer, 0, ondone);
    }

    public static AsyncWork<Integer, IOException> readFullyAsync(IO.Readable io, ByteBuffer buffer, int done, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> read = io.readAsync(buffer);
        if (read.isUnblocked()) {
            if (!read.isSuccessful()) {
                if (ondone != null && read.getError() != null) {
                    ondone.run(new Pair<Object, IOException>(null, read.getError()));
                }
                return read;
            }
            if (!buffer.hasRemaining()) {
                if (done == 0) {
                    if (ondone != null) {
                        ondone.run(new Pair<Integer, Object>(read.getResult(), null));
                    }
                    return read;
                }
                if (read.getResult() <= 0) {
                    return IOUtil.success(done, ondone);
                }
                return IOUtil.success(read.getResult() + done, ondone);
            }
            if (read.getResult() <= 0) {
                if (done == 0) {
                    if (ondone != null) {
                        ondone.run(new Pair<Integer, Object>(read.getResult(), null));
                    }
                    return read;
                }
                return IOUtil.success(done, ondone);
            }
            return IOUtil.readFullyAsync(io, buffer, read.getResult() + done, ondone);
        }
        AsyncWork<Integer, IOException> sp = new AsyncWork<Integer, IOException>();
        MutableInteger total = new MutableInteger(done);
        final Mutable<AsyncWork<Integer, IOException>> r = new Mutable<AsyncWork<Integer, IOException>>(read);
        read.listenInline(new AsyncWork.AsyncWorkListenerReady((result, that) -> {
            while (true) {
                if (!buffer.hasRemaining() || result <= 0) {
                    if (total.get() == 0) {
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>((Integer)result, null));
                        }
                        sp.unblockSuccess((Integer)result);
                    } else if (result >= 0) {
                        Integer i = result + total.get();
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>(i, null));
                        }
                        sp.unblockSuccess(i);
                    } else {
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>(total.get(), null));
                        }
                        sp.unblockSuccess(total.get());
                    }
                    return;
                }
                total.add((int)result);
                AsyncWork<Integer, IOException> reading = io.readAsync(buffer);
                r.set(reading);
                if (!reading.isSuccessful()) break;
                result = reading.getResult();
            }
            ((AsyncWork)r.get()).listenInline(that);
        }, sp, ondone));
        sp.onCancel(new Listener<CancelException>(){

            @Override
            public void fire(CancelException event) {
                ((AsyncWork)r.get()).unblockCancel(event);
            }
        });
        return sp;
    }

    public static AsyncWork<Integer, IOException> readFullyAsync(IO.Readable.Seekable io, long pos, ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        AsyncWork<Integer, IOException> read = io.readAsync(pos, buffer);
        if (read.isUnblocked()) {
            if (!read.isSuccessful()) {
                if (ondone != null && read.getError() != null) {
                    ondone.run(new Pair<Object, IOException>(null, read.getError()));
                }
                return read;
            }
            if (!buffer.hasRemaining()) {
                if (ondone != null && read.getResult() != null) {
                    ondone.run(new Pair<Integer, Object>(read.getResult(), null));
                }
                return read;
            }
            if (read.getResult() <= 0) {
                if (ondone != null) {
                    ondone.run(new Pair<Integer, Object>(read.getResult(), null));
                }
                return read;
            }
        }
        AsyncWork<Integer, IOException> sp = new AsyncWork<Integer, IOException>();
        MutableInteger total = new MutableInteger(0);
        final Mutable<AsyncWork<Integer, IOException>> r = new Mutable<AsyncWork<Integer, IOException>>(read);
        read.listenInline(new AsyncWork.AsyncWorkListenerReady((result, that) -> {
            while (true) {
                if (!buffer.hasRemaining() || result <= 0) {
                    Integer i;
                    if (total.get() == 0) {
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>((Integer)result, null));
                        }
                        sp.unblockSuccess((Integer)result);
                    } else if (result >= 0) {
                        i = result + total.get();
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>(i, null));
                        }
                        sp.unblockSuccess(i);
                    } else {
                        i = total.get();
                        if (ondone != null) {
                            ondone.run(new Pair<Integer, Object>(i, null));
                        }
                        sp.unblockSuccess(i);
                    }
                    return;
                }
                total.add((int)result);
                AsyncWork<Integer, IOException> reading = io.readAsync(pos + (long)total.get(), buffer);
                r.set(reading);
                if (!reading.isSuccessful()) break;
                result = reading.getResult();
            }
            ((AsyncWork)r.get()).listenInline(that);
        }, sp, ondone));
        sp.onCancel(new Listener<CancelException>(){

            @Override
            public void fire(CancelException event) {
                ((AsyncWork)r.get()).unblockCancel(event);
            }
        });
        return sp;
    }

    public static AsyncWork<ByteBuffersIO, IOException> readFullyAsync(IO.Readable io, int bufferSize) {
        ByteBuffersIO bb = new ByteBuffersIO(false, io.getSourceDescription(), io.getPriority());
        AsyncWork<ByteBuffersIO, IOException> result = new AsyncWork<ByteBuffersIO, IOException>();
        IOUtil.readFullyAsync(io, bufferSize, bb, result);
        return result;
    }

    private static void readFullyAsync(IO.Readable io, int bufferSize, ByteBuffersIO bb, AsyncWork<ByteBuffersIO, IOException> result) {
        byte[] buffer = new byte[bufferSize];
        AsyncWork<Integer, IOException> read = io.readFullyAsync(ByteBuffer.wrap(buffer));
        read.listenAsync(new Task.Cpu.FromRunnable("readFully", io.getPriority(), () -> {
            int nb = (Integer)read.getResult();
            if (nb > 0) {
                bb.addBuffer(buffer, 0, nb);
            }
            if (nb < bufferSize) {
                result.unblockSuccess(bb);
            } else {
                IOUtil.readFullyAsync(io, bufferSize, bb, result);
            }
        }), result);
    }

    public static Task<Integer, IOException> readAsyncUsingSync(final IO.Readable io, final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Reading from " + io.getSourceDescription(), io.getPriority(), ondone){

            @Override
            public Integer run() throws IOException {
                return io.readSync(buffer);
            }
        };
        task.start();
        return task;
    }

    public static Task<Integer, IOException> readAsyncUsingSync(final IO.Readable.Seekable io, final long pos, final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Reading from " + io.getSourceDescription(), io.getPriority(), ondone){

            @Override
            public Integer run() throws IOException {
                return io.readSync(pos, buffer);
            }
        };
        task.start();
        return task;
    }

    public static Task<Integer, IOException> readFullyAsyncUsingSync(final IO.Readable io, final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Reading from " + io.getSourceDescription(), io.getPriority(), ondone){

            @Override
            public Integer run() throws IOException {
                return io.readFullySync(buffer);
            }
        };
        task.start();
        return task;
    }

    public static Task<Integer, IOException> readFullyAsyncUsingSync(final IO.Readable.Seekable io, final long pos, final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Reading from " + io.getSourceDescription(), io.getPriority(), ondone){

            @Override
            public Integer run() throws IOException {
                return io.readFullySync(pos, buffer);
            }
        };
        task.start();
        return task;
    }

    public static long skipSyncByReading(IO.Readable io, long n) throws IOException {
        long total;
        int nb;
        if (n <= 0L) {
            return 0L;
        }
        int l = n > 65536L ? 65536 : (int)n;
        ByteBuffer b = ByteBuffer.allocate(l);
        for (total = 0L; total < n; total += (long)nb) {
            int len = n - total > (long)l ? l : (int)(n - total);
            b.clear();
            b.limit(len);
            nb = io.readSync(b);
            if (nb <= 0) break;
        }
        return total;
    }

    public static AsyncWork<Long, IOException> skipAsyncUsingSync(final IO.Readable io, final long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        Task.Cpu<Long, IOException> task = new Task.Cpu<Long, IOException>("Skipping bytes", io.getPriority(), ondone){

            @Override
            public Long run() throws IOException {
                long total = IOUtil.skipSyncByReading(io, n);
                return total;
            }
        };
        task.start();
        return task.getOutput();
    }

    public static AsyncWork<Long, IOException> skipAsyncByReading(IO.Readable io, long n, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        if (n <= 0L) {
            if (ondone != null) {
                ondone.run(new Pair<Long, Object>(0L, null));
            }
            return new AsyncWork<Long, Object>(0L, null);
        }
        ByteBuffer b = ByteBuffer.allocate(n > 65536L ? 65536 : (int)n);
        MutableLong done = new MutableLong(0L);
        AsyncWork<Long, IOException> result = new AsyncWork<Long, IOException>();
        io.readAsync(b).listenInline(new AsyncWork.AsyncWorkListenerReady((nb, that) -> {
            AsyncWork<Integer, IOException> next;
            while (true) {
                int read;
                if ((read = nb.intValue()) <= 0) {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(done.get(), null));
                    }
                    result.unblockSuccess(done.get());
                    return;
                }
                done.add(nb.intValue());
                if (done.get() == n) {
                    if (ondone != null) {
                        ondone.run(new Pair<Long, Object>(n, null));
                    }
                    result.unblockSuccess(n);
                    return;
                }
                b.clear();
                if (n - done.get() < (long)b.remaining()) {
                    b.limit((int)(n - done.get()));
                }
                if (!(next = io.readAsync(b)).isSuccessful()) break;
                nb = next.getResult();
            }
            next.listenInline(that);
        }, result));
        return result;
    }

    public static AsyncWork<File, IOException> toTempFile(IO.Readable io) {
        IO.Readable.Buffered bio = io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new SimpleBufferedReadable(io, 65536);
        AsyncWork<FileIO.ReadWrite, IOException> createFile = TemporaryFiles.get().createAndOpenFileAsync("net.lecousin.framework.io", "streamtofile");
        AsyncWork<File, IOException> result = new AsyncWork<File, IOException>();
        createFile.listenInline(() -> {
            File file = ((FileIO.ReadWrite)createFile.getResult()).getFile();
            IOUtil.copy(bio, (IO.Writable)createFile.getResult(), -1L, true, null, 0L).listenInline(() -> result.unblockSuccess(file), (ISynchronizationPoint<IOException>)result);
        }, result);
        return result;
    }

    public static AsyncWork<File, IOException> toTempFile(byte[] bytes) {
        AsyncWork<FileIO.ReadWrite, IOException> createFile = TemporaryFiles.get().createAndOpenFileAsync("net.lecousin.framework.io", "bytestofile");
        AsyncWork<File, IOException> result = new AsyncWork<File, IOException>();
        createFile.listenInline(() -> {
            File file = ((FileIO.ReadWrite)createFile.getResult()).getFile();
            ((FileIO.ReadWrite)createFile.getResult()).writeAsync(ByteBuffer.wrap(bytes)).listenInline(() -> {
                try {
                    ((FileIO.ReadWrite)createFile.getResult()).close();
                    result.unblockSuccess(file);
                }
                catch (Exception e) {
                    result.error(IO.error(e));
                }
            });
        }, result);
        return result;
    }

    public static int readSyncUsingAsync(IO.Readable io, ByteBuffer buffer) throws IOException {
        AsyncWork<Integer, IOException> sp = io.readAsync(buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Cancelled", e);
        }
    }

    public static int readSyncUsingAsync(IO.Readable.Seekable io, long pos, ByteBuffer buffer) throws IOException {
        AsyncWork<Integer, IOException> sp = io.readAsync(pos, buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Cancelled", e);
        }
    }

    public static int readFullySyncUsingAsync(IO.Readable io, ByteBuffer buffer) throws IOException {
        AsyncWork<Integer, IOException> sp = io.readFullyAsync(buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Cancelled", e);
        }
    }

    public static int readFullySyncUsingAsync(IO.Readable.Seekable io, long pos, ByteBuffer buffer) throws IOException {
        AsyncWork<Integer, IOException> sp = io.readFullyAsync(pos, buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Cancelled", e);
        }
    }

    public static long skipSyncUsingAsync(IO.Readable io, long n) throws IOException {
        AsyncWork<Long, IOException> sp = io.skipAsync(n);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Cancelled", e);
        }
    }

    public static int writeSyncUsingAsync(IO.Writable io, ByteBuffer buffer) throws IOException {
        AsyncWork<Integer, IOException> sp = io.writeAsync(buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Cancelled", e);
        }
    }

    public static int writeSyncUsingAsync(IO.Writable.Seekable io, long pos, ByteBuffer buffer) throws IOException {
        AsyncWork<Integer, IOException> sp = io.writeAsync(pos, buffer);
        try {
            return sp.blockResult(0L);
        }
        catch (CancelException e) {
            throw new IOException("Cancelled", e);
        }
    }

    public static Task<Integer, IOException> writeAsyncUsingSync(final IO.Writable io, final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Writing to " + io.getSourceDescription(), io.getPriority(), ondone){

            @Override
            public Integer run() throws IOException {
                return io.writeSync(buffer);
            }
        };
        task.start();
        return task;
    }

    public static Task<Integer, IOException> writeAsyncUsingSync(final IO.Writable.Seekable io, final long pos, final ByteBuffer buffer, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        Task.Cpu<Integer, IOException> task = new Task.Cpu<Integer, IOException>("Writing to " + io.getSourceDescription(), io.getPriority(), ondone){

            @Override
            public Integer run() throws IOException {
                return io.writeSync(pos, buffer);
            }
        };
        task.start();
        return task;
    }

    public static AsyncWork<UnprotectedStringBuffer, IOException> readFullyAsString(IO.Readable io, Charset charset, byte priority) {
        AsyncWork<UnprotectedStringBuffer, IOException> result = new AsyncWork<UnprotectedStringBuffer, IOException>();
        if (io instanceof IO.KnownSize) {
            ((IO.KnownSize)((Object)io)).getSizeAsync().listenInline(size -> new Task.Cpu.FromRunnable("Prepare readFullyAsString", priority, () -> {
                byte[] buf = new byte[size.intValue()];
                io.readFullyAsync(ByteBuffer.wrap(buf)).listenAsync(new Task.Cpu.FromRunnable("readFullyAsString", priority, () -> {
                    try {
                        result.unblockSuccess(new UnprotectedStringBuffer(charset.newDecoder().decode(ByteBuffer.wrap(buf))));
                    }
                    catch (IOException e) {
                        result.error(e);
                    }
                }), result);
            }).start(), result);
            return result;
        }
        new Task.Cpu.FromRunnable("Read file as string: " + io.getSourceDescription(), priority, () -> {
            BufferedReadableCharacterStream stream = new BufferedReadableCharacterStream(io, charset, 1024, 128);
            UnprotectedStringBuffer str = new UnprotectedStringBuffer();
            IOUtil.readFullyAsString(stream, str, result, priority);
        }).startOn(io.canStartReading(), true);
        return result;
    }

    private static void readFullyAsString(BufferedReadableCharacterStream stream, UnprotectedStringBuffer str, AsyncWork<UnprotectedStringBuffer, IOException> result, byte priority) {
        AsyncWork<UnprotectedString, IOException> read;
        while ((read = stream.readNextBufferAsync()).isUnblocked()) {
            if (read.hasError()) {
                result.error(read.getError());
                return;
            }
            if (read.getResult() == null) {
                result.unblockSuccess(str);
                return;
            }
            str.append(read.getResult());
        }
        read.listenAsync(new Task.Cpu.FromRunnable("readFullyAsString: " + stream.getDescription(), priority, () -> {
            if (read.getResult() == null) {
                result.unblockSuccess(str);
                return;
            }
            str.append((CharSequence)read.getResult());
            IOUtil.readFullyAsString(stream, str, result, priority);
        }), result);
    }

    public static void readFullyAsStringSync(IO.Readable io, Charset charset, StringBuilder s) throws IOException {
        int nb;
        byte[] buf = new byte[1024];
        while ((nb = io.readFullySync(ByteBuffer.wrap(buf))) > 0) {
            s.append(new String(buf, 0, nb, charset));
            if (nb >= 1024) continue;
            break;
        }
    }

    public static void readFullyAsStringSync(InputStream input, Charset charset, StringBuilder s) throws IOException {
        int nb;
        byte[] buf = new byte[1024];
        while ((nb = input.read(buf)) > 0) {
            s.append(new String(buf, 0, nb, charset));
            if (nb >= 1024) continue;
            break;
        }
    }

    public static String readFullyAsStringSync(IO.Readable io, Charset charset) throws IOException {
        if (io instanceof IO.KnownSize) {
            byte[] bytes = new byte[(int)((IO.KnownSize)((Object)io)).getSizeSync()];
            io.readFullySync(ByteBuffer.wrap(bytes));
            return new String(bytes, charset);
        }
        StringBuilder s = new StringBuilder(1024);
        IOUtil.readFullyAsStringSync(io, charset, s);
        return s.toString();
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static String readFullyAsStringSync(File file, Charset charset) throws IOException {
        try (FileIO.ReadOnly io = new FileIO.ReadOnly(file, 3);){
            String string = IOUtil.readFullyAsStringSync(io, charset);
            return string;
        }
        catch (Exception e) {
            throw IO.error(e);
        }
    }

    public static String readFullyAsStringSync(InputStream input, Charset charset) throws IOException {
        StringBuilder s = new StringBuilder(1024);
        IOUtil.readFullyAsStringSync(input, charset, s);
        return s.toString();
    }

    public static Task<Long, IOException> seekAsyncUsingSync(final IO.Seekable io, final IO.Seekable.SeekType type, final long move, RunnableWithParameter<Pair<Long, IOException>> ondone) {
        Task.Cpu<Long, IOException> task = new Task.Cpu<Long, IOException>("Seeking", io.getPriority(), ondone){

            @Override
            public Long run() throws IOException {
                return io.seekSync(type, move);
            }
        };
        task.start();
        return task;
    }

    public static long seekSyncUsingAsync(IO.Seekable io, IO.Seekable.SeekType type, long move) throws IOException {
        AsyncWork<Long, IOException> seek = io.seekAsync(type, move);
        seek.blockException(0L);
        return seek.getResult();
    }

    public static Task<Void, IOException> setSizeAsyncUsingSync(final IO.Resizable io, final long newSize, byte priority) {
        Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Resizing " + io.getSourceDescription(), priority){

            @Override
            public Void run() throws IOException {
                io.setSizeSync(newSize);
                return null;
            }
        };
        task.start();
        return task;
    }

    public static AsyncWork<Long, IOException> copy(IO.Readable input, IO.Writable output, long size, boolean closeIOs, WorkProgress progress, long work) {
        AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
        IOUtil.copy(input, output, size, closeIOs, sp, progress, work);
        return sp;
    }

    private static void copy(final IO.Readable input, final IO.Writable output, long size, final boolean closeIOs, final AsyncWork<Long, IOException> sp, final WorkProgress progress, final long work) {
        TaskManager tmOut;
        if (size == 0L) {
            if (progress != null) {
                progress.progress(work);
            }
            IOUtil.copyEnd(input, output, sp, null, null, closeIOs, 0L);
            return;
        }
        if (size < 0L) {
            TaskManager tmOut2;
            if (input instanceof IO.KnownSize) {
                final AsyncWork<Long, IOException> getSize = ((IO.KnownSize)((Object)input)).getSizeAsync();
                getSize.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (getSize.hasError()) {
                            IOUtil.copyEnd(input, output, sp, (IOException)getSize.getError(), null, closeIOs, 0L);
                        } else if (getSize.isCancelled()) {
                            IOUtil.copyEnd(input, output, sp, null, getSize.getCancelEvent(), closeIOs, 0L);
                        } else {
                            IOUtil.copy(input, output, (Long)getSize.getResult(), closeIOs, sp, progress, work);
                        }
                    }
                });
                return;
            }
            TaskManager tmIn = IOUtil.getUnderlyingTaskManager(input);
            if (tmIn == (tmOut2 = IOUtil.getUnderlyingTaskManager(output))) {
                IOUtil.copySameTM(input, output, 0x200000, -1L, sp, closeIOs, progress, work);
                return;
            }
            if (input instanceof IO.Readable.Buffered) {
                IOUtil.copyStep((IO.Readable.Buffered)input, output, sp, 0L, closeIOs, progress, work);
                return;
            }
            PreBufferedReadable binput = new PreBufferedReadable(input, 65536, input.getPriority(), 0x100000, input.getPriority(), 16);
            IOUtil.copyStep(binput, output, sp, 0L, closeIOs, progress, work);
            return;
        }
        if (size <= 262144L) {
            IOUtil.copySameTM(input, output, (int)size, size, sp, closeIOs, progress, work);
            return;
        }
        TaskManager tmIn = IOUtil.getUnderlyingTaskManager(input);
        if (tmIn == (tmOut = IOUtil.getUnderlyingTaskManager(output))) {
            if (size <= 0x400000L) {
                IOUtil.copySameTM(input, output, (int)size, size, sp, closeIOs, progress, work);
                return;
            }
            if (size <= 0x800000L) {
                IOUtil.copySameTM(input, output, (int)(size / 2L + 1L), size, sp, closeIOs, progress, work);
                return;
            }
            IOUtil.copySameTM(input, output, 0x400000, size, sp, closeIOs, progress, work);
            return;
        }
        if (input instanceof IO.Readable.Buffered) {
            IOUtil.copyStep((IO.Readable.Buffered)input, output, sp, 0L, closeIOs, progress, work);
            return;
        }
        PreBufferedReadable binput = size <= 0x100000L ? new PreBufferedReadable(input, size, 65536, input.getPriority(), 131072, input.getPriority(), 6) : (size <= 0x1000000L ? new PreBufferedReadable(input, size, 131072, input.getPriority(), 524288, input.getPriority(), 8) : new PreBufferedReadable(input, size, 262144, input.getPriority(), 0x200000, input.getPriority(), 5));
        IOUtil.copyStep(binput, output, sp, 0L, closeIOs, progress, work);
    }

    private static void copyEnd(IO.Readable input, IO.Writable output, final AsyncWork<Long, IOException> sp, final IOException error, final CancelException cancel, boolean closeIOs, final long written) {
        if (!closeIOs) {
            if (error != null) {
                sp.error(error);
            } else if (cancel != null) {
                sp.cancel(cancel);
            } else {
                sp.unblockSuccess(written);
            }
            return;
        }
        final ISynchronizationPoint sp1 = input.closeAsync();
        final ISynchronizationPoint sp2 = output.closeAsync();
        JoinPoint.fromSynchronizationPoints(sp1, sp2).listenInline(new Runnable(){

            @Override
            public void run() {
                IOException e = error;
                if (e == null) {
                    if (sp1.hasError()) {
                        e = sp1.getError();
                    } else if (sp2.hasError()) {
                        e = sp2.getError();
                    }
                }
                if (e != null) {
                    sp.error(IO.error(e));
                    return;
                }
                if (cancel != null) {
                    sp.cancel(cancel);
                } else {
                    sp.unblockSuccess(written);
                }
            }
        });
    }

    private static void copySameTM(final IO.Readable input, final IO.Writable output, final int bufferSize, final long total, final AsyncWork<Long, IOException> end, final boolean closeIOs, final WorkProgress progress, final long work) {
        new Task.Cpu<Void, NoException>("Allocate buffers to copy IOs", input.getPriority()){

            @Override
            public Void run() {
                IOUtil.copySameTMStep(input, output, ByteBuffer.allocate(bufferSize), 0L, total, end, closeIOs, progress, work);
                return null;
            }
        }.start();
    }

    private static void copySameTMStep(final IO.Readable input, final IO.Writable output, final ByteBuffer buf, final long written, final long total, final AsyncWork<Long, IOException> end, final boolean closeIOs, final WorkProgress progress, final long work) {
        input.readFullyAsync(buf).listenInline(new AsyncWork.AsyncWorkListener<Integer, IOException>(){

            @Override
            public void ready(Integer result) {
                final int nb = result;
                if (nb <= 0) {
                    if (progress != null) {
                        progress.progress(work);
                    }
                    IOUtil.copyEnd(input, output, end, null, null, closeIOs, written);
                } else {
                    buf.flip();
                    if (progress != null) {
                        progress.progress((long)nb * work / (total * 2L));
                    }
                    AsyncWork<Integer, IOException> write = output.writeAsync(buf);
                    write.listenInline(new AsyncWork.AsyncWorkListener<Integer, IOException>(){

                        @Override
                        public void ready(Integer result) {
                            long w;
                            if (progress != null) {
                                w = (long)nb * work / total;
                                progress.progress(w - (long)nb * work / (total * 2L));
                                w = work - w;
                            } else {
                                w = 0L;
                            }
                            if (nb < buf.capacity() || total > 0L && total == written + result.longValue()) {
                                IOUtil.copyEnd(input, output, end, null, null, closeIOs, written + result.longValue());
                            } else {
                                buf.clear();
                                IOUtil.copySameTMStep(input, output, buf, written + result.longValue(), total, end, closeIOs, progress, w);
                            }
                        }

                        @Override
                        public void error(IOException error) {
                            IOUtil.copyEnd(input, output, end, error, null, closeIOs, written);
                        }

                        @Override
                        public void cancelled(CancelException event) {
                            IOUtil.copyEnd(input, output, end, null, event, closeIOs, written);
                        }
                    });
                }
            }

            @Override
            public void error(IOException error) {
                IOUtil.copyEnd(input, output, end, error, null, closeIOs, written);
            }

            @Override
            public void cancelled(CancelException event) {
                IOUtil.copyEnd(input, output, end, null, event, closeIOs, written);
            }
        });
    }

    private static void copyStep(final IO.Readable.Buffered input, final IO.Writable output, final AsyncWork<Long, IOException> sp, final long written, final boolean closeIOs, final WorkProgress progress, final long work) {
        final AsyncWork<ByteBuffer, IOException> read = input.readNextBufferAsync();
        read.listenInline(new Runnable(){

            @Override
            public void run() {
                if (read.hasError()) {
                    IOUtil.copyEnd(input, output, sp, (IOException)read.getError(), null, closeIOs, written);
                    return;
                }
                if (read.isCancelled()) {
                    IOUtil.copyEnd(input, output, sp, null, read.getCancelEvent(), closeIOs, written);
                    return;
                }
                ByteBuffer buf = (ByteBuffer)read.getResult();
                if (buf == null) {
                    if (progress != null) {
                        progress.progress(work);
                    }
                    IOUtil.copyEnd(input, output, sp, null, null, closeIOs, written);
                    return;
                }
                if (progress != null && work >= 2L) {
                    progress.progress(1L);
                }
                final AsyncWork<Integer, IOException> write = output.writeAsync(buf);
                write.listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (write.hasError()) {
                            IOUtil.copyEnd(input, output, sp, (IOException)write.getError(), null, closeIOs, written);
                            return;
                        }
                        if (write.isCancelled()) {
                            IOUtil.copyEnd(input, output, sp, null, write.getCancelEvent(), closeIOs, written);
                            return;
                        }
                        if (progress != null && work >= 1L) {
                            progress.progress(1L);
                        }
                        IOUtil.copyStep(input, output, sp, written + (long)((Integer)write.getResult()).intValue(), closeIOs, progress, work - 2L);
                    }
                });
            }
        });
    }

    public static <T extends IO.Writable.Seekable & IO.Readable.Seekable> SynchronizationPoint<IOException> copy(T io, long src, long dst, long len) {
        SynchronizationPoint<IOException> sp = new SynchronizationPoint<IOException>();
        if (len < 0x400000L) {
            ByteBuffer buffer = ByteBuffer.allocate((int)len);
            IOUtil.copy(io, src, dst, buffer, len, sp);
        } else {
            ByteBuffer buffer = ByteBuffer.allocate(0x400000);
            IOUtil.copy(io, src, dst, buffer, len, sp);
        }
        return sp;
    }

    private static <T extends IO.Writable.Seekable & IO.Readable.Seekable> void copy(final T io, final long src, final long dst, final ByteBuffer buffer, final long len, final SynchronizationPoint<IOException> sp) {
        ((IO.Readable.Seekable)io).readFullyAsync(src, buffer).listenInline(new Runnable(){

            @Override
            public void run() {
                buffer.flip();
                AsyncWork<Integer, IOException> write = io.writeAsync(dst, buffer);
                if (len <= 0x400000L) {
                    write.listenInline(sp);
                } else {
                    write.listenInline(new Runnable(){

                        @Override
                        public void run() {
                            long nl = len - 0x400000L;
                            buffer.clear();
                            if (nl < 0x400000L) {
                                buffer.limit((int)nl);
                            }
                            IOUtil.copy(io, src + 0x400000L, dst + 0x400000L, buffer, nl, sp);
                        }
                    });
                }
            }
        });
    }

    public static AsyncWork<Long, IOException> copy(final File src, final File dst, final byte priority, final long knownSize, final WorkProgress progress, final long work, ISynchronizationPoint<?> startOn) {
        final AsyncWork<Long, IOException> sp = new AsyncWork<Long, IOException>();
        Task.Cpu<Void, NoException> task = new Task.Cpu<Void, NoException>("Start copying files", priority){

            @Override
            public Void run() {
                final FileIO.ReadOnly input = new FileIO.ReadOnly(src, priority);
                final FileIO.WriteOnly output = new FileIO.WriteOnly(dst, priority);
                input.canStart().listenInline(new Runnable(){

                    @Override
                    public void run() {
                        if (input.canStart().hasError()) {
                            IOUtil.copyEnd(input, output, sp, new IOException("Unable to open file " + src.getAbsolutePath(), input.canStart().getError()), null, true, 0L);
                            return;
                        }
                        IOUtil.copy(input, output, knownSize, true, sp, progress, work);
                    }
                });
                return null;
            }
        };
        if (startOn == null) {
            task.start();
        } else {
            task.startOn(startOn, true);
        }
        return sp;
    }

    public static ISynchronizationPoint<IOException> closeAsync(final Closeable toClose) {
        Task.Cpu<Void, IOException> task = new Task.Cpu<Void, IOException>("Closing resource", 3){

            @Override
            public Void run() throws IOException {
                toClose.close();
                return null;
            }
        };
        task.start();
        return task.getOutput();
    }

    public static AsyncWork<byte[], IOException> readFully(File file, byte priority) {
        final AsyncWork<byte[], IOException> result = new AsyncWork<byte[], IOException>();
        final FileIO.ReadOnly f = new FileIO.ReadOnly(file, priority);
        f.getSizeAsync().listenInline(new AsyncWork.AsyncWorkListener<Long, IOException>(){

            @Override
            public void error(IOException error) {
                try {
                    f.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result.error(error);
            }

            @Override
            public void cancelled(CancelException event) {
                try {
                    f.close();
                }
                catch (Throwable throwable) {
                    // empty catch block
                }
                result.cancel(event);
            }

            @Override
            public void ready(Long size) {
                final byte[] buf = new byte[size.intValue()];
                f.readFullyAsync(ByteBuffer.wrap(buf)).listenInline(new AsyncWork.AsyncWorkListener<Integer, IOException>(){

                    @Override
                    public void error(IOException error) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        result.error(error);
                    }

                    @Override
                    public void cancelled(CancelException event) {
                        try {
                            f.close();
                        }
                        catch (Throwable throwable) {
                            // empty catch block
                        }
                        result.cancel(event);
                    }

                    @Override
                    public void ready(Integer read) {
                        if (read != buf.length) {
                            result.error(new IOException("Only " + read + " bytes read on file size " + buf.length));
                        } else {
                            try {
                                f.close();
                            }
                            catch (Throwable throwable) {
                                // empty catch block
                            }
                            result.unblockSuccess(buf);
                        }
                    }
                });
            }
        });
        return result;
    }

    public static TaskManager getUnderlyingTaskManager(IO io) {
        io = IOUtil.getUnderlyingIO(io);
        return io.getTaskManager();
    }

    public static IO getUnderlyingIO(IO io) {
        IO parent;
        while ((parent = io.getWrappedIO()) != null) {
            io = parent;
        }
        return io;
    }

    public static <T> void listenOnDone(AsyncWork<T, IOException> toListen, AsyncWork<T, IOException> toUnblock, RunnableWithParameter<Pair<T, IOException>> ondone) {
        toListen.listenInline(result -> {
            if (ondone != null) {
                ondone.run(new Pair<Object, Object>(result, null));
            }
            toUnblock.unblockSuccess(result);
        }, error -> {
            if (ondone != null) {
                ondone.run(new Pair<Object, IOException>(null, (IOException)error));
            }
            toUnblock.error((IOException)error);
        }, cancel -> toUnblock.cancel((CancelException)cancel));
    }

    public static <T, T2> void listenOnDone(AsyncWork<T, IOException> toListen, Listener<T> onReady, ISynchronizationPoint<IOException> onErrorOrCancel, RunnableWithParameter<Pair<T2, IOException>> ondone) {
        toListen.listenInline(onReady, error -> {
            if (ondone != null) {
                ondone.run(new Pair<Object, IOException>(null, (IOException)error));
            }
            onErrorOrCancel.error((IOException)error);
        }, cancel -> onErrorOrCancel.cancel((CancelException)cancel));
    }

    public static <T, T2> void listenOnDone(AsyncWork<T, IOException> toListen, Task<?, ?> onReady, ISynchronizationPoint<IOException> onErrorOrCancel, RunnableWithParameter<Pair<T2, IOException>> ondone) {
        toListen.listenInline(() -> {
            if (toListen.isCancelled()) {
                if (onErrorOrCancel != null) {
                    onErrorOrCancel.cancel(toListen.getCancelEvent());
                }
            } else if (toListen.hasError()) {
                if (ondone != null) {
                    ondone.run(new Pair(null, toListen.getError()));
                }
                if (onErrorOrCancel != null) {
                    onErrorOrCancel.error((IOException)toListen.getError());
                }
            } else {
                onReady.start();
            }
        });
    }

    public static <T> void listenOnDone(ISynchronizationPoint<IOException> toListen, Runnable onReady, ISynchronizationPoint<IOException> onErrorOrCancel, RunnableWithParameter<Pair<T, IOException>> ondone) {
        toListen.listenInline(onReady, error -> {
            if (ondone != null) {
                ondone.run(new Pair<Object, IOException>(null, (IOException)error));
            }
            onErrorOrCancel.error((IOException)error);
        }, cancel -> onErrorOrCancel.cancel((CancelException)cancel));
    }

    public static <TResult, TError extends Exception> void error(TError error, AsyncWork<TResult, TError> result, RunnableWithParameter<Pair<TResult, TError>> ondone) {
        if (ondone != null) {
            ondone.run(new Pair<Object, TError>(null, error));
        }
        result.error(error);
    }

    public static <TResult, TError extends Exception> AsyncWork<TResult, TError> error(TError error, RunnableWithParameter<Pair<TResult, TError>> ondone) {
        if (ondone != null) {
            ondone.run(new Pair<Object, TError>(null, error));
        }
        return new AsyncWork<Object, TError>(null, error);
    }

    public static <TResult, TError extends Exception> void success(TResult res, AsyncWork<TResult, TError> result, RunnableWithParameter<Pair<TResult, TError>> ondone) {
        if (ondone != null) {
            ondone.run(new Pair<TResult, Object>(res, null));
        }
        result.unblockSuccess(res);
    }

    public static <TResult, TError extends Exception> AsyncWork<TResult, TError> success(TResult result, RunnableWithParameter<Pair<TResult, TError>> ondone) {
        if (ondone != null) {
            ondone.run(new Pair<TResult, Object>(result, null));
        }
        return new AsyncWork<TResult, Object>(result, null);
    }

    public static <TResult, TError extends Exception> void notSuccess(ISynchronizationPoint<TError> sp, AsyncWork<TResult, TError> result, RunnableWithParameter<Pair<TResult, TError>> ondone) {
        if (sp.hasError()) {
            IOUtil.error(sp.getError(), result, ondone);
        } else {
            result.cancel(sp.getCancelEvent());
        }
    }

    public static long getSizeSync(IO.Readable.Seekable io) throws IOException {
        if (io instanceof IO.KnownSize) {
            return ((IO.KnownSize)((Object)io)).getSizeSync();
        }
        long pos = io.getPosition();
        long size = io.seekSync(IO.Seekable.SeekType.FROM_END, 0L);
        io.seekSync(IO.Seekable.SeekType.FROM_BEGINNING, pos);
        return size;
    }
}

