/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.event;

import java.util.ArrayList;
import net.lecousin.framework.event.Listenable;
import net.lecousin.framework.event.Listener;

public class SingleEvent<T>
implements Listenable<T> {
    private boolean occured = false;
    private T data = null;
    private ArrayList<Listener<T>> listeners = null;
    private ArrayList<Runnable> listenersRunnable = null;

    @Override
    public synchronized void addListener(Listener<T> listener) {
        if (this.occured) {
            listener.fire(this.data);
        } else {
            if (this.listeners == null) {
                this.listeners = new ArrayList();
            }
            this.listeners.add(listener);
        }
    }

    @Override
    public synchronized void addListener(Runnable listener) {
        if (this.occured) {
            listener.run();
        } else {
            if (this.listenersRunnable == null) {
                this.listenersRunnable = new ArrayList();
            }
            this.listenersRunnable.add(listener);
        }
    }

    @Override
    public synchronized void removeListener(Listener<T> listener) {
        if (this.listeners == null) {
            return;
        }
        this.listeners.remove(listener);
        if (this.listeners.isEmpty()) {
            this.listeners = null;
        }
    }

    @Override
    public synchronized void removeListener(Runnable listener) {
        if (this.listenersRunnable == null) {
            return;
        }
        this.listenersRunnable.remove(listener);
        if (this.listenersRunnable.isEmpty()) {
            this.listenersRunnable = null;
        }
    }

    @Override
    public boolean hasListeners() {
        return this.listeners != null || this.listenersRunnable != null;
    }

    public synchronized void fire(T event) {
        if (this.occured) {
            throw new IllegalStateException("SingleEvent already fired");
        }
        this.occured = true;
        this.data = event;
        if (this.listeners != null) {
            for (Listener listener : this.listeners) {
                listener.fire(event);
            }
            this.listeners = null;
        }
        if (this.listenersRunnable != null) {
            for (Runnable runnable : this.listenersRunnable) {
                runnable.run();
            }
            this.listenersRunnable = null;
        }
    }

    public boolean occured() {
        return this.occured;
    }
}

