/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.util.production.simple;

import net.lecousin.framework.collections.TurnArray;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.util.production.simple.Consumer;
import net.lecousin.framework.concurrent.util.production.simple.Producer;

public class Production<T> {
    private TurnArray<T> production;
    private boolean endReached = false;
    private Producer<T> producer;
    private Consumer<T> consumer;
    private AsyncWork<?, ? extends Exception> consuming = null;
    private AsyncWork<T, ? extends Exception> producing = null;
    private AsyncWork<Void, Exception> spEnd = new AsyncWork();
    private boolean ended = false;

    public Production(Producer<T> producer, int maxPending, Consumer<T> consumer) {
        this.production = new TurnArray(maxPending);
        this.producer = producer;
        this.consumer = consumer;
    }

    public void start() {
        this.produce();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void endOfProduction() {
        TurnArray<T> turnArray = this.production;
        synchronized (turnArray) {
            this.endReached = true;
        }
    }

    public AsyncWork<Void, Exception> getSyncOnFinished() {
        return this.spEnd;
    }

    private void produce() {
        if (this.endReached) {
            return;
        }
        this.producing = this.producer.produce(this);
        this.producing.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!Production.this.producing.isSuccessful()) {
                    if (Production.this.producing.isCancelled()) {
                        Production.this.consumer.cancel(Production.this.producing.getCancelEvent());
                        Production.this.spEnd.unblockCancel(Production.this.producing.getCancelEvent());
                    } else {
                        Production.this.spEnd.unblockError(Production.this.producing.getError());
                        Production.this.consumer.error((Exception)Production.this.producing.getError());
                    }
                    return;
                }
                Object result = Production.this.producing.getResult();
                boolean canProduceAgain = false;
                TurnArray turnArray = Production.this.production;
                synchronized (turnArray) {
                    Production.this.producing = null;
                    if (result == null) {
                        Production.this.endReached = true;
                        if (Production.this.production.isEmpty() && Production.this.consuming == null) {
                            Production.this.end();
                        }
                    } else {
                        if (Production.this.consuming == null) {
                            Production.this.consume(result);
                        } else {
                            Production.this.production.addLast(result);
                        }
                        boolean bl = canProduceAgain = !Production.this.production.isFull() && Production.this.producing == null && !Production.this.endReached;
                    }
                    if (canProduceAgain) {
                        Production.this.produce();
                    }
                }
            }
        });
    }

    private void consume(T product) {
        this.consuming = this.consumer.consume(product);
        this.consuming.listenInline(new Runnable(){

            /*
             * WARNING - Removed try catching itself - possible behaviour change.
             */
            @Override
            public void run() {
                if (!Production.this.consuming.isSuccessful()) {
                    if (Production.this.consuming.isCancelled()) {
                        Production.this.producer.cancel(Production.this.consuming.getCancelEvent());
                        Production.this.spEnd.unblockCancel(Production.this.consuming.getCancelEvent());
                    } else {
                        Production.this.producer.cancel(new CancelException("Error", (Throwable)Production.this.consuming.getError()));
                        Production.this.spEnd.unblockError(Production.this.consuming.getError());
                    }
                    return;
                }
                TurnArray turnArray = Production.this.production;
                synchronized (turnArray) {
                    Production.this.consuming = null;
                    if (!Production.this.production.isEmpty()) {
                        Production.this.consume(Production.this.production.removeFirst());
                        if (Production.this.producing == null && !Production.this.endReached) {
                            Production.this.produce();
                        }
                    } else if (Production.this.producing == null) {
                        if (Production.this.endReached) {
                            Production.this.end();
                        } else {
                            Production.this.produce();
                        }
                    }
                }
            }
        });
    }

    private void end() {
        if (this.ended) {
            return;
        }
        this.ended = true;
        this.consumer.endOfProduction().listenInline(new Runnable(){

            @Override
            public void run() {
                Production.this.spEnd.unblockSuccess(null);
            }
        });
    }
}

