/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.File;
import java.io.IOException;
import java.nio.file.AccessDeniedException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.progress.WorkProgress;

public class RemoveDirectoryContentTask
extends Task.OnFile<Long, IOException> {
    private File dir;
    private WorkProgress progress;
    private long work;
    private boolean calculateSize;

    public RemoveDirectoryContentTask(File dir, WorkProgress progress, long work, byte priority, boolean calculateSize) {
        super(dir, "Removing directory", priority);
        this.dir = dir;
        this.progress = progress;
        this.work = work;
        this.calculateSize = calculateSize;
    }

    @Override
    public Long run() throws IOException {
        return RemoveDirectoryContentTask.removeDirectoryContent(this.dir, this.progress, this.work, this.calculateSize);
    }

    static long removeDirectoryContent(File dir, WorkProgress progress, long work, boolean calculateSize) throws IOException {
        if (!dir.exists()) {
            if (progress != null) {
                progress.progress(work);
            }
            return 0L;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            if (progress != null) {
                progress.progress(work);
            }
            throw new AccessDeniedException(dir.getAbsolutePath());
        }
        int nb = files.length;
        long size = 0L;
        for (File f : files) {
            long step = work / (long)nb--;
            work -= step;
            if (f.isDirectory()) {
                try {
                    size += RemoveDirectoryContentTask.deleteDirectory(f, progress, step, calculateSize);
                    continue;
                }
                catch (IOException e) {
                    if (progress != null) {
                        progress.progress(work);
                    }
                    throw e;
                }
            }
            if (calculateSize) {
                size += f.length();
            }
            if (!f.delete()) {
                if (progress != null) {
                    progress.progress(work + step);
                }
                throw new IOException("Unable to delete file " + f.getAbsolutePath());
            }
            if (progress == null) continue;
            progress.progress(step);
        }
        if (progress != null && work > 0L) {
            progress.progress(work);
        }
        return size;
    }

    public static long deleteDirectory(File dir, WorkProgress progress, long work, boolean calculateSize) throws IOException {
        if (!dir.exists()) {
            if (progress != null) {
                progress.progress(work);
            }
            return 0L;
        }
        File[] files = dir.listFiles();
        if (files == null) {
            if (progress != null) {
                progress.progress(work);
            }
            throw new AccessDeniedException(dir.getAbsolutePath());
        }
        long size = 0L;
        int nb = 1 + files.length;
        for (File f : files) {
            long step = work / (long)nb--;
            work -= step;
            if (f.isDirectory()) {
                try {
                    size += RemoveDirectoryContentTask.deleteDirectory(f, progress, step, calculateSize);
                    continue;
                }
                catch (IOException e) {
                    if (progress != null) {
                        progress.progress(work);
                    }
                    throw e;
                }
            }
            if (calculateSize) {
                size += f.length();
            }
            if (!f.delete() && f.exists()) {
                if (progress != null) {
                    progress.progress(work + step);
                }
                throw new IOException("Unable to delete file " + f.getAbsolutePath());
            }
            if (progress == null || step <= 0L) continue;
            progress.progress(step);
        }
        if (!dir.delete() && dir.exists()) {
            if (progress != null && work > 0L) {
                progress.progress(work);
            }
            throw new IOException("Unable to delete directory " + dir.getAbsolutePath());
        }
        if (progress != null && work > 0L) {
            progress.progress(work);
        }
        return size;
    }
}

