/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks.drives;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.ClosedChannelException;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.tasks.drives.FileAccess;
import net.lecousin.framework.util.Pair;
import net.lecousin.framework.util.RunnableWithParameter;

class ReadFileTask
extends Task.OnFile<Integer, IOException> {
    private FileAccess file;
    private long pos;
    private ByteBuffer buffer;
    private boolean fully;

    public ReadFileTask(FileAccess file, long pos, ByteBuffer buffer, boolean fully, byte priority, RunnableWithParameter<Pair<Integer, IOException>> ondone) {
        super(file.manager, "Read from file " + file.path + (pos >= 0L ? " at " + pos : ""), priority, ondone);
        this.file = file;
        this.pos = pos;
        this.buffer = buffer;
        this.fully = fully;
        file.openTask.ondone(this, false);
    }

    @Override
    public Integer run() throws IOException, CancelException {
        if (!this.file.openTask.isSuccessful()) {
            throw (IOException)this.file.openTask.getError();
        }
        int nbRead = 0;
        if (this.pos >= 0L) {
            try {
                this.file.channel.position(this.pos);
            }
            catch (ClosedChannelException e) {
                throw new CancelException("File has been closed");
            }
            catch (IOException e) {
                throw new IOException("Unable to seek to position " + this.pos + " in file " + this.file.path, e);
            }
        }
        if (!this.fully) {
            try {
                nbRead = this.file.channel.read(this.buffer);
            }
            catch (ClosedChannelException e) {
                throw new CancelException("File has been closed");
            }
        }
        nbRead = 0;
        while (this.buffer.remaining() > 0) {
            int nb;
            try {
                nb = this.file.channel.read(this.buffer);
            }
            catch (ClosedChannelException e) {
                throw new CancelException("File has been closed");
            }
            if (nb <= 0) break;
            nbRead += nb;
        }
        return nbRead;
    }
}

