/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks;

import java.io.File;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.Iterator;
import java.util.Map;
import java.util.Properties;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedWritableCharacterStream;
import net.lecousin.framework.io.text.ICharacterStream;

public class SavePropertiesFileTask
extends Task.Cpu<Void, IOException> {
    private Properties properties;
    private ICharacterStream.Writable.Buffered output;
    private boolean closeStreamAtEnd;

    public static ISynchronizationPoint<IOException> savePropertiesFile(Properties properties, File file, Charset charset, byte priority) {
        FileIO.ReadWrite io = new FileIO.ReadWrite(file, priority);
        ISynchronizationPoint resize = io.setSizeAsync(0L);
        SynchronizationPoint<IOException> result = new SynchronizationPoint<IOException>();
        ((AsyncWork)resize).listenInline(new Runnable((AsyncWork)resize, result, io, properties, charset, priority){
            final /* synthetic */ AsyncWork val$resize;
            final /* synthetic */ SynchronizationPoint val$result;
            final /* synthetic */ FileIO.ReadWrite val$io;
            final /* synthetic */ Properties val$properties;
            final /* synthetic */ Charset val$charset;
            final /* synthetic */ byte val$priority;
            {
                this.val$resize = asyncWork;
                this.val$result = synchronizationPoint;
                this.val$io = readWrite;
                this.val$properties = properties;
                this.val$charset = charset;
                this.val$priority = by;
            }

            @Override
            public void run() {
                if (this.val$resize.hasError()) {
                    this.val$result.error(this.val$resize.getError());
                    this.val$io.closeAsync();
                    return;
                }
                SavePropertiesFileTask.savePropertiesFile(this.val$properties, this.val$io, this.val$charset, this.val$priority, true).listenInline(this.val$result);
            }
        });
        return result;
    }

    public static ISynchronizationPoint<IOException> savePropertiesFile(Properties properties, IO.Writable output, Charset charset, byte priority, boolean closeIOAtEnd) {
        BufferedWritableCharacterStream stream = new BufferedWritableCharacterStream(output, charset, 4096);
        return SavePropertiesFileTask.savePropertiesFile(properties, stream, priority, closeIOAtEnd);
    }

    public static ISynchronizationPoint<IOException> savePropertiesFile(Properties properties, ICharacterStream.Writable.Buffered output, byte priority, boolean closeStreamAtEnd) {
        SavePropertiesFileTask task = new SavePropertiesFileTask(properties, output, priority, closeStreamAtEnd);
        task.start();
        return task.getOutput();
    }

    public SavePropertiesFileTask(Properties properties, ICharacterStream.Writable.Buffered output, byte priority, boolean closeStreamAtEnd) {
        super("Save properties file", priority);
        this.properties = properties;
        this.output = output;
        this.closeStreamAtEnd = closeStreamAtEnd;
    }

    @Override
    public Void run() throws IOException, CancelException {
        try {
            for (Map.Entry<Object, Object> p : this.properties.entrySet()) {
                this.output.writeSync(p.getKey().toString());
                this.output.writeSync('=');
                this.output.writeSync(p.getValue().toString());
                this.output.writeSync('\n');
            }
            this.output.flush().blockThrow(0L);
            Iterator<Map.Entry<Object, Object>> iterator = null;
            return iterator;
        }
        finally {
            if (this.closeStreamAtEnd) {
                try {
                    this.output.close();
                }
                catch (Throwable throwable) {}
            }
        }
    }
}

