/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.tasks;

import java.io.File;
import java.nio.charset.Charset;
import java.util.Properties;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.PreBufferedReadable;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.PropertiesReader;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class LoadPropertiesFileTask
extends PropertiesReader<Properties> {
    private Properties properties = new Properties();
    private Listener<Properties> onDone;

    public static AsyncWork<Properties, Exception> loadPropertiesFile(File file, Charset charset, byte priority, boolean closeSynchronous, Listener<Properties> onDone) {
        FileIO.ReadOnly input = new FileIO.ReadOnly(file, priority);
        return LoadPropertiesFileTask.loadPropertiesFile(input, charset, priority, closeSynchronous ? IO.OperationType.SYNCHRONOUS : IO.OperationType.ASYNCHRONOUS, onDone);
    }

    public static AsyncWork<Properties, Exception> loadPropertiesFile(IO.Readable input, Charset charset, byte priority, IO.OperationType closeInputAtEnd, Listener<Properties> onDone) {
        if (!(input instanceof IO.Readable.Buffered)) {
            input = new PreBufferedReadable(input, 512, priority, 1024, priority, 16);
        }
        return LoadPropertiesFileTask.loadPropertiesFile((IO.Readable.Buffered)input, charset, priority, closeInputAtEnd, onDone);
    }

    public static AsyncWork<Properties, Exception> loadPropertiesFile(IO.Readable.Buffered input, Charset charset, byte priority, IO.OperationType closeInputAtEnd, Listener<Properties> onDone) {
        BufferedReadableCharacterStream cs = new BufferedReadableCharacterStream((IO.Readable)input, charset, 512, 32);
        return LoadPropertiesFileTask.loadPropertiesFile(cs, priority, closeInputAtEnd, onDone);
    }

    public static AsyncWork<Properties, Exception> loadPropertiesFile(BufferedReadableCharacterStream stream, byte priority, IO.OperationType closeStreamAtEnd, Listener<Properties> onDone) {
        LoadPropertiesFileTask task = new LoadPropertiesFileTask(stream, priority, closeStreamAtEnd, onDone);
        return task.start();
    }

    public LoadPropertiesFileTask(BufferedReadableCharacterStream stream, byte priority, IO.OperationType closeStreamAtEnd, Listener<Properties> onDone) {
        super("Load properties file", stream, priority, closeStreamAtEnd);
        this.onDone = onDone;
    }

    @Override
    protected void processProperty(UnprotectedStringBuffer key, UnprotectedStringBuffer value) {
        this.properties.setProperty(key.asString(), value.asString());
    }

    @Override
    protected Properties generateResult() {
        if (this.onDone != null) {
            this.onDone.fire(this.properties);
        }
        return this.properties;
    }
}

