/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.synch;

import java.util.ArrayList;
import java.util.Collection;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.ThreadingDebugHelper;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.log.Logger;

public class SynchronizationPoint<TError extends Exception>
implements ISynchronizationPoint<TError>,
Future<Void> {
    private boolean unblocked = false;
    private TError error = null;
    private CancelException cancelled = null;
    private ArrayList<Runnable> listenersInline = null;

    public SynchronizationPoint() {
    }

    public SynchronizationPoint(boolean unblocked) {
        this.unblocked = unblocked;
    }

    public SynchronizationPoint(TError error) {
        this.unblocked = true;
        this.error = error;
    }

    public SynchronizationPoint(CancelException cancel) {
        this.unblocked = true;
        this.cancelled = cancel;
    }

    @Override
    public Collection<?> getAllListeners() {
        if (this.listenersInline == null) {
            return new ArrayList(0);
        }
        return new ArrayList<Runnable>(this.listenersInline);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listenInline(Runnable r) {
        SynchronizationPoint synchronizationPoint = this;
        synchronized (synchronizationPoint) {
            if (!this.unblocked || this.listenersInline != null) {
                if (this.listenersInline == null) {
                    this.listenersInline = new ArrayList(5);
                }
                this.listenersInline.add(r);
                return;
            }
        }
        r.run();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unblock() {
        ArrayList<Runnable> listeners;
        if (Threading.debugSynchronization) {
            ThreadingDebugHelper.unblocked(this);
        }
        SynchronizationPoint synchronizationPoint = this;
        synchronized (synchronizationPoint) {
            if (this.unblocked) {
                return;
            }
            this.unblocked = true;
            if (this.listenersInline == null) {
                this.notifyAll();
                return;
            }
            listeners = this.listenersInline;
            this.listenersInline = new ArrayList(2);
        }
        Logger log = LCCore.getApplication().getLoggerFactory().getLogger(SynchronizationPoint.class);
        while (true) {
            int i;
            if (!log.debug()) {
                for (i = 0; i < listeners.size(); ++i) {
                    try {
                        listeners.get(i).run();
                        continue;
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown by an inline listener of SynchronizationPoint", t);
                    }
                }
            } else {
                for (i = 0; i < listeners.size(); ++i) {
                    long start = System.nanoTime();
                    try {
                        listeners.get(i).run();
                    }
                    catch (Throwable t) {
                        log.error("Exception thrown by an inline listener of SynchronizationPoint", t);
                    }
                    long time = System.nanoTime() - start;
                    if (time <= 1000000L) continue;
                    log.debug("Listener took " + (double)time / 1000000.0 + "ms: " + listeners.get(i));
                }
            }
            SynchronizationPoint synchronizationPoint2 = this;
            synchronized (synchronizationPoint2) {
                if (this.listenersInline.isEmpty()) {
                    this.listenersInline = null;
                    listeners = null;
                    this.notifyAll();
                    break;
                }
                listeners.clear();
                ArrayList<Runnable> tmp = listeners;
                listeners = this.listenersInline;
                this.listenersInline = tmp;
            }
        }
    }

    @Override
    public void error(TError error) {
        this.error = error;
        this.unblock();
    }

    @Override
    public void cancel(CancelException reason) {
        this.cancelled = reason;
        this.unblock();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void block(long timeout) {
        BlockedThreadHandler blockedHandler;
        SynchronizationPoint synchronizationPoint = this;
        synchronized (synchronizationPoint) {
            if (this.unblocked && this.listenersInline == null) {
                return;
            }
            Thread t = Thread.currentThread();
            blockedHandler = Threading.getBlockedThreadHandler(t);
            if (blockedHandler == null) {
                if (timeout <= 0L) {
                    while (!this.unblocked || this.listenersInline != null) {
                        try {
                            this.wait(0L);
                        }
                        catch (InterruptedException e) {
                            return;
                        }
                    }
                } else {
                    try {
                        this.wait(timeout);
                    }
                    catch (InterruptedException e) {
                        return;
                    }
                }
            }
        }
        if (blockedHandler != null) {
            blockedHandler.blocked(this, timeout);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockPause(long logAfter) {
        SynchronizationPoint synchronizationPoint = this;
        synchronized (synchronizationPoint) {
            while (!this.unblocked || this.listenersInline != null) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(logAfter + 1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (System.currentTimeMillis() - start <= logAfter) continue;
                System.err.println("Still blocked after " + logAfter / 1000L + "s.");
                new Exception("").printStackTrace(System.err);
            }
        }
    }

    @Override
    public synchronized boolean isUnblocked() {
        return this.unblocked;
    }

    @Override
    public boolean isCancelled() {
        return this.cancelled != null;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public CancelException getCancelEvent() {
        return this.cancelled;
    }

    @Override
    public TError getError() {
        return this.error;
    }

    public synchronized void reset() {
        this.unblocked = false;
        this.cancelled = null;
        this.error = null;
        this.listenersInline = null;
    }

    public synchronized void restart() {
        this.unblocked = false;
        this.cancelled = null;
        this.error = null;
    }

    @Override
    public Void get() throws InterruptedException, ExecutionException {
        this.block(0L);
        if (!this.isUnblocked()) {
            throw new InterruptedException();
        }
        if (this.hasError()) {
            throw new ExecutionException((Throwable)this.error);
        }
        if (this.isCancelled()) {
            throw new ExecutionException(this.cancelled);
        }
        return null;
    }

    @Override
    public Void get(long timeout, TimeUnit unit) throws InterruptedException, ExecutionException, TimeoutException {
        this.block(unit.toMillis(timeout));
        if (!this.isUnblocked()) {
            throw new TimeoutException();
        }
        if (this.hasError()) {
            throw new ExecutionException((Throwable)this.error);
        }
        if (this.isCancelled()) {
            throw new ExecutionException(this.cancelled);
        }
        return null;
    }

    @Override
    public boolean cancel(boolean mayInterruptIfRunning) {
        if (this.isUnblocked()) {
            return false;
        }
        this.cancel(new CancelException("Cancelled"));
        return true;
    }

    @Override
    public boolean isDone() {
        return this.isUnblocked();
    }
}

