/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.synch;

import java.util.ArrayList;
import java.util.Collection;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;

public class MutualExclusion<TError extends Exception>
implements ISynchronizationPoint<TError> {
    private Thread lockingThread = null;
    private int lockedTimes = 0;
    private TError error = null;
    private CancelException cancel = null;
    private ArrayList<Runnable> listeners = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        if (this.cancel != null) {
            return;
        }
        if (this.error != null) {
            return;
        }
        Thread t = Thread.currentThread();
        if (t == this.lockingThread) {
            ++this.lockedTimes;
            return;
        }
        BlockedThreadHandler blockedHandler = null;
        while (true) {
            MutualExclusion mutualExclusion = this;
            synchronized (mutualExclusion) {
                if (this.lockingThread == null) {
                    this.lockingThread = t;
                    this.lockedTimes = 1;
                    return;
                }
                if (blockedHandler == null) {
                    blockedHandler = Threading.getBlockedThreadHandler(t);
                }
                if (blockedHandler == null) {
                    try {
                        this.wait(0L);
                    }
                    catch (InterruptedException interruptedException) {
                        // empty catch block
                    }
                    continue;
                }
            }
            blockedHandler.blocked(this, 0L);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        ArrayList<Runnable> list;
        Thread t = Thread.currentThread();
        Object object = this;
        synchronized (object) {
            if (t != this.lockingThread) {
                return;
            }
            if (--this.lockedTimes > 0) {
                return;
            }
            this.lockingThread = null;
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Runnable r : list) {
                r.run();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    @Override
    public boolean isUnblocked() {
        return this.lockingThread == null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockPause(long logAfter) {
        MutualExclusion mutualExclusion = this;
        synchronized (mutualExclusion) {
            if (this.lockingThread == null) {
                return;
            }
            while (true) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(logAfter + 1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (System.currentTimeMillis() - start <= logAfter) break;
                System.err.println("Still blocked after " + logAfter / 1000L + "s.");
                new Exception("").printStackTrace(System.err);
            }
        }
    }

    @Override
    public Collection<?> getAllListeners() {
        if (this.listeners == null) {
            return new ArrayList(0);
        }
        return new ArrayList<Runnable>(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listenInline(Runnable r) {
        MutualExclusion mutualExclusion = this;
        synchronized (mutualExclusion) {
            if (this.lockingThread == null) {
                r.run();
            } else {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                this.listeners.add(r);
            }
        }
    }

    @Override
    public void block(long timeout) {
        if (this.lockingThread == null) {
            return;
        }
        final SynchronizationPoint sp = new SynchronizationPoint();
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                sp.unblock();
            }
        });
        sp.block(timeout);
    }

    @Override
    public boolean isCancelled() {
        return this.cancel != null;
    }

    @Override
    public void cancel(CancelException reason) {
        this.cancel = reason;
        this.unlock();
    }

    @Override
    public CancelException getCancelEvent() {
        return this.cancel;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public TError getError() {
        return this.error;
    }

    @Override
    public void error(TError error) {
        this.error = error;
        this.unlock();
    }
}

