/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.synch;

import java.util.ArrayList;
import java.util.Collection;
import net.lecousin.framework.concurrent.BlockedThreadHandler;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;

public class LockPoint<TError extends Exception>
implements ISynchronizationPoint<TError> {
    private boolean locked = false;
    private TError error = null;
    private CancelException cancel = null;
    private ArrayList<Runnable> listeners = null;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void lock() {
        BlockedThreadHandler blockedHandler;
        if (this.cancel != null) {
            return;
        }
        if (this.error != null) {
            return;
        }
        while (true) {
            LockPoint lockPoint = this;
            synchronized (lockPoint) {
                if (!this.locked) {
                    this.locked = true;
                    return;
                }
                Thread t = Thread.currentThread();
                blockedHandler = Threading.getBlockedThreadHandler(t);
                if (blockedHandler != null) {
                    break;
                }
                try {
                    this.wait(0L);
                }
                catch (InterruptedException e) {
                }
            }
        }
        blockedHandler.blocked(this, 0L);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void unlock() {
        ArrayList<Runnable> list;
        Object object = this;
        synchronized (object) {
            this.locked = false;
            list = this.listeners;
            this.listeners = null;
        }
        if (list != null) {
            for (Runnable r : list) {
                r.run();
            }
        }
        object = this;
        synchronized (object) {
            this.notifyAll();
        }
    }

    @Override
    public boolean isUnblocked() {
        return !this.locked;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void blockPause(long logAfter) {
        LockPoint lockPoint = this;
        synchronized (lockPoint) {
            if (!this.locked) {
                return;
            }
            while (true) {
                long start = System.currentTimeMillis();
                try {
                    this.wait(logAfter + 1000L);
                }
                catch (InterruptedException e) {
                    return;
                }
                if (System.currentTimeMillis() - start <= logAfter) break;
                System.err.println("Still blocked after " + logAfter / 1000L + "s.");
                new Exception("").printStackTrace(System.err);
            }
        }
    }

    @Override
    public Collection<?> getAllListeners() {
        if (this.listeners == null) {
            return new ArrayList(0);
        }
        return new ArrayList<Runnable>(this.listeners);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listenInline(Runnable r) {
        LockPoint lockPoint = this;
        synchronized (lockPoint) {
            if (!this.locked) {
                r.run();
            } else {
                if (this.listeners == null) {
                    this.listeners = new ArrayList();
                }
                this.listeners.add(r);
            }
        }
    }

    @Override
    public void block(long timeout) {
        if (!this.locked) {
            return;
        }
        final SynchronizationPoint sp = new SynchronizationPoint();
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                sp.unblock();
            }
        });
        sp.block(timeout);
    }

    @Override
    public boolean isCancelled() {
        return this.cancel != null;
    }

    @Override
    public void cancel(CancelException reason) {
        this.cancel = reason;
        this.unlock();
    }

    @Override
    public CancelException getCancelEvent() {
        return this.cancel;
    }

    @Override
    public boolean hasError() {
        return this.error != null;
    }

    @Override
    public TError getError() {
        return this.error;
    }

    @Override
    public void error(TError error) {
        this.error = error;
        this.unlock();
    }
}

