/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.concurrent.synch;

import java.util.Collection;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.Listener;

public interface ISynchronizationPoint<TError extends Exception> {
    public boolean isUnblocked();

    public boolean isCancelled();

    public void cancel(CancelException var1);

    public CancelException getCancelEvent();

    public boolean hasError();

    public void error(TError var1);

    public TError getError();

    default public boolean isSuccessful() {
        return this.isUnblocked() && !this.hasError() && !this.isCancelled();
    }

    public void block(long var1);

    default public void blockException(long timeout) throws TError {
        this.block(timeout);
        if (this.hasError()) {
            throw this.getError();
        }
    }

    default public void blockThrow(long timeout) throws TError, CancelException {
        this.block(timeout);
        if (this.hasError()) {
            throw this.getError();
        }
        if (this.isCancelled()) {
            throw this.getCancelEvent();
        }
    }

    public void blockPause(long var1);

    public void listenInline(Runnable var1);

    default public void listenInline(final Runnable onReady, final Listener<TError> onError, final Listener<CancelException> onCancel) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.hasError()) {
                    onError.fire(ISynchronizationPoint.this.getError());
                } else if (ISynchronizationPoint.this.isCancelled()) {
                    onCancel.fire(ISynchronizationPoint.this.getCancelEvent());
                } else {
                    onReady.run();
                }
            }

            public String toString() {
                return "SynchronzationPoint.listenInline:" + onReady;
            }
        });
    }

    default public void listenInline(final Runnable onReady, final ISynchronizationPoint<TError> onErrorOrCancel) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.hasError()) {
                    onErrorOrCancel.error(ISynchronizationPoint.this.getError());
                } else if (ISynchronizationPoint.this.isCancelled()) {
                    onErrorOrCancel.cancel(ISynchronizationPoint.this.getCancelEvent());
                } else {
                    onReady.run();
                }
            }

            public String toString() {
                return "SynchronzationPoint.listenInline:" + onReady;
            }
        });
    }

    default public void listenInline(final SynchronizationPoint<TError> sp) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.isCancelled()) {
                    sp.cancel(ISynchronizationPoint.this.getCancelEvent());
                } else if (ISynchronizationPoint.this.hasError()) {
                    sp.error(ISynchronizationPoint.this.getError());
                } else {
                    sp.unblock();
                }
            }

            public String toString() {
                return "SynchronzationPoint.listenInline: " + sp;
            }
        });
    }

    default public void listenInlineSP(final Runnable onReady, final ISynchronizationPoint<Exception> onErrorOrCancel) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.hasError()) {
                    onErrorOrCancel.error(ISynchronizationPoint.this.getError());
                } else if (ISynchronizationPoint.this.isCancelled()) {
                    onErrorOrCancel.cancel(ISynchronizationPoint.this.getCancelEvent());
                } else {
                    onReady.run();
                }
            }

            public String toString() {
                return "SynchronzationPoint.listenInline: " + onReady;
            }
        });
    }

    default public void listenInlineSP(final SynchronizationPoint<Exception> sp) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.isCancelled()) {
                    sp.cancel(ISynchronizationPoint.this.getCancelEvent());
                } else if (ISynchronizationPoint.this.hasError()) {
                    sp.error(ISynchronizationPoint.this.getError());
                } else {
                    sp.unblock();
                }
            }

            public String toString() {
                return "SynchronzationPoint.listenInlineSP: " + sp;
            }
        });
    }

    default public void synchWithNoError(final SynchronizationPoint<?> sp) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                sp.unblock();
            }

            public String toString() {
                return "SynchronzationPoint.synchWithNoError: " + sp;
            }
        });
    }

    default public void onSuccess(final Runnable listener) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.isSuccessful()) {
                    listener.run();
                }
            }

            public String toString() {
                return "SynchronzationPoint.onSuccess: " + listener;
            }
        });
    }

    default public void onError(final Listener<TError> listener) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.hasError()) {
                    listener.fire(ISynchronizationPoint.this.getError());
                }
            }

            public String toString() {
                return "SynchronzationPoint.onError: " + listener;
            }
        });
    }

    default public void onException(final Listener<Exception> listener) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.hasError()) {
                    listener.fire(ISynchronizationPoint.this.getError());
                }
            }

            public String toString() {
                return "SynchronzationPoint.onException: " + listener;
            }
        });
    }

    default public void onCancel(final Listener<CancelException> listener) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                if (ISynchronizationPoint.this.isCancelled()) {
                    listener.fire(ISynchronizationPoint.this.getCancelEvent());
                }
            }

            public String toString() {
                return "SynchronzationPoint.onCancel: " + listener;
            }
        });
    }

    default public void forwardCancel(ISynchronizationPoint<?> sp) {
        this.onCancel(reason -> sp.cancel((CancelException)reason));
    }

    default public void forwardError(ISynchronizationPoint<TError> sp) {
        this.onError(error -> sp.error(error));
    }

    default public void listenAsync(Task<?, ? extends Exception> task, boolean evenIfErrorOrCancel) {
        task.startOn(this, evenIfErrorOrCancel);
    }

    default public void listenAsync(final Task<?, ? extends Exception> task, final ISynchronizationPoint<TError> onErrorOrCancel) {
        this.listenInline(new Runnable(){

            @Override
            public void run() {
                task.start();
                task.getOutput().onCancel(cancel -> {
                    if (!onErrorOrCancel.isUnblocked()) {
                        onErrorOrCancel.cancel((CancelException)cancel);
                    }
                });
            }

            public String toString() {
                return "SynchronzationPoint.listenAsync: " + task.getDescription();
            }
        }, onErrorOrCancel);
    }

    default public void listenAsyncSP(final Task<?, ? extends Exception> task, final ISynchronizationPoint<Exception> onErrorOrCancel) {
        this.listenInlineSP(new Runnable(){

            @Override
            public void run() {
                task.start();
                task.getOutput().onCancel(cancel -> {
                    if (!onErrorOrCancel.isUnblocked()) {
                        onErrorOrCancel.cancel((CancelException)cancel);
                    }
                });
            }

            public String toString() {
                return "SynchronzationPoint.listenAsyncSP: " + task.getDescription();
            }
        }, onErrorOrCancel);
    }

    default public AsyncWork<Void, TError> toAsyncWorkVoid() {
        AsyncWork aw = new AsyncWork();
        this.listenInline(() -> {
            if (this.hasError()) {
                aw.error(this.getError());
            } else if (this.isCancelled()) {
                aw.cancel(this.getCancelEvent());
            } else {
                aw.unblockSuccess(null);
            }
        });
        return aw;
    }

    public Collection<?> getAllListeners();
}

