/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections.sort;

import java.util.ArrayList;
import java.util.Iterator;
import net.lecousin.framework.collections.sort.Sorted;
import net.lecousin.framework.util.ObjectUtil;

public class RedBlackTreeLong<T>
implements Sorted.AssociatedWithLong<T> {
    private Node<T> root = null;
    private Node<T> first = null;
    private Node<T> last = null;

    @Override
    public int size() {
        return this.root == null ? 0 : ((Node)this.root).n;
    }

    @Override
    public boolean isEmpty() {
        return this.root == null;
    }

    @Override
    public void clear() {
        this.last = null;
        this.first = null;
        this.root = null;
    }

    public Node<T> get(long value) {
        if (this.root == null) {
            return null;
        }
        if (value == ((Node)this.first).value) {
            return this.first;
        }
        if (value == ((Node)this.last).value) {
            return this.last;
        }
        if (value < ((Node)this.first).value) {
            return null;
        }
        if (value > ((Node)this.last).value) {
            return null;
        }
        return this.get(this.root, value);
    }

    private Node<T> get(Node<T> x, long key) {
        while (x != null) {
            if (x.value == key) {
                return x;
            }
            if (key < x.value) {
                x = x.left;
                continue;
            }
            x = x.right;
        }
        return null;
    }

    public Node<T> getPrevious(long value) {
        if (value == ((Node)this.first).value) {
            return null;
        }
        if (value == ((Node)this.root).value) {
            if (((Node)this.root).left == null) {
                return null;
            }
            Node n = ((Node)this.root).left;
            while (n.right != null) {
                n = n.right;
            }
            return n;
        }
        if (value < ((Node)this.root).value) {
            if (((Node)this.root).left == null) {
                return null;
            }
            return this.getPrevious(((Node)this.root).left, value);
        }
        if (((Node)this.root).right == null) {
            return null;
        }
        return this.getPrevious(this.root, ((Node)this.root).right, value);
    }

    public Node<T> getPrevious(Node<T> node) {
        if (node.left != null) {
            node = node.left;
            while (node.right != null) {
                node = node.right;
            }
            return node;
        }
        if (node == this.first) {
            return null;
        }
        return this.getPrevious(this.root, node.value);
    }

    private Node<T> getPrevious(Node<T> node, long value) {
        if (value == node.value) {
            if (node.left == null) {
                return null;
            }
            node = node.left;
            while (node.right != null) {
                node = node.right;
            }
            return node;
        }
        if (value < node.value) {
            if (node.left == null) {
                return null;
            }
            return this.getPrevious(node.left, value);
        }
        if (node.right == null) {
            return null;
        }
        return this.getPrevious(node, node.right, value);
    }

    private Node<T> getPrevious(Node<T> parentPrevious, Node<T> node, long value) {
        if (node.value == value) {
            if (node.left == null) {
                return parentPrevious;
            }
            node = node.left;
            while (node.right != null) {
                node = node.right;
            }
            return node;
        }
        if (value < node.value) {
            if (node.left == null) {
                return null;
            }
            return this.getPrevious(parentPrevious, node.left, value);
        }
        if (node.right == null) {
            return null;
        }
        return this.getPrevious(node, node.right, value);
    }

    public Node<T> getNext(long value) {
        if (value == ((Node)this.last).value) {
            return null;
        }
        if (value == ((Node)this.root).value) {
            if (((Node)this.root).right == null) {
                return null;
            }
            Node n = ((Node)this.root).right;
            while (n.left != null) {
                n = n.left;
            }
            return n;
        }
        if (value > ((Node)this.root).value) {
            if (((Node)this.root).right == null) {
                return null;
            }
            return this.getNext(((Node)this.root).right, value);
        }
        if (((Node)this.root).left == null) {
            return null;
        }
        return this.getNext(this.root, ((Node)this.root).left, value);
    }

    public Node<T> getNext(Node<T> node) {
        if (node.right != null) {
            node = node.right;
            while (node.left != null) {
                node = node.left;
            }
            return node;
        }
        if (node == this.last) {
            return null;
        }
        return this.getNext(this.root, node.value);
    }

    private Node<T> getNext(Node<T> node, long value) {
        if (value == node.value) {
            if (node.right == null) {
                return null;
            }
            node = node.right;
            while (node.left != null) {
                node = node.left;
            }
            return node;
        }
        if (value > node.value) {
            if (node.right == null) {
                return null;
            }
            return this.getNext(node.right, value);
        }
        if (node.left == null) {
            return null;
        }
        return this.getNext(node, node.left, value);
    }

    private Node<T> getNext(Node<T> parentNext, Node<T> node, long value) {
        if (node.value == value) {
            if (node.right == null) {
                return parentNext;
            }
            node = node.right;
            while (node.left != null) {
                node = node.left;
            }
            return node;
        }
        if (value > node.value) {
            if (node.right == null) {
                return null;
            }
            return this.getNext(parentNext, node.right, value);
        }
        if (node.left == null) {
            return null;
        }
        return this.getNext(node, node.left, value);
    }

    public boolean containsKey(long value) {
        return this.get(value) != null;
    }

    @Override
    public boolean contains(long value, T element) {
        if (this.root == null) {
            return false;
        }
        if (value < ((Node)this.first).value) {
            return false;
        }
        if (value > ((Node)this.last).value) {
            return false;
        }
        if (value == ((Node)this.first).value && ObjectUtil.equalsOrNull(element, ((Node)this.first).element)) {
            return true;
        }
        if (value == ((Node)this.last).value && ObjectUtil.equalsOrNull(element, ((Node)this.last).element)) {
            return true;
        }
        return this.contains(this.root, value, element);
    }

    private boolean contains(Node<T> x, long key, T element) {
        while (x != null) {
            if (key < x.value) {
                x = x.left;
                continue;
            }
            if (x.value == key && ObjectUtil.equalsOrNull(x.element, element)) {
                return true;
            }
            x = x.right;
        }
        return false;
    }

    @Override
    public boolean containsInstance(long value, T instance) {
        if (this.root == null) {
            return false;
        }
        if (value < ((Node)this.first).value) {
            return false;
        }
        if (value > ((Node)this.last).value) {
            return false;
        }
        if (value == ((Node)this.first).value && instance == ((Node)this.first).element) {
            return true;
        }
        if (value == ((Node)this.last).value && instance == ((Node)this.last).element) {
            return true;
        }
        return this.containsInstance(this.root, value, instance);
    }

    private boolean containsInstance(Node<T> x, long key, T instance) {
        while (x != null) {
            if (key < x.value) {
                x = x.left;
                continue;
            }
            if (x.value == key && x.element == instance) {
                return true;
            }
            x = x.right;
        }
        return false;
    }

    public Node<T> getMin() {
        return this.first;
    }

    public Node<T> getMax() {
        return this.last;
    }

    public Node<T> searchNearestLower(long value, boolean acceptEquals) {
        if (this.root == null) {
            return null;
        }
        return this.searchNearestLower(this.root, value, acceptEquals);
    }

    private Node<T> searchNearestLower(Node<T> node, long value, boolean acceptEquals) {
        if (value < ((Node)node).value) {
            if (((Node)node).left == null) {
                return null;
            }
            return this.searchNearestLower(((Node)node).left, value, acceptEquals);
        }
        if (value > ((Node)node).value) {
            if (((Node)node).right == null) {
                return node;
            }
            if (value > ((Node)node).right.value) {
                return this.searchNearestLower(((Node)node).right, value, acceptEquals);
            }
            if (value == ((Node)node).right.value) {
                if (acceptEquals) {
                    return ((Node)node).right;
                }
                Node<T> n = this.searchNearestLower(((Node)node).right, value, false);
                if (n == null) {
                    return node;
                }
                return n;
            }
            Node<T> n = this.searchNearestLower(((Node)node).right, value, acceptEquals);
            if (n == null) {
                return node;
            }
            return n;
        }
        if (acceptEquals) {
            return node;
        }
        if (((Node)node).left == null) {
            return null;
        }
        Node n = ((Node)node).left;
        while (n.right != null) {
            n = n.right;
        }
        return n;
    }

    public Node<T> searchNearestHigher(long value, boolean acceptEquals) {
        if (this.root == null) {
            return null;
        }
        return this.searchNearestHigher(this.root, value, acceptEquals);
    }

    private Node<T> searchNearestHigher(Node<T> node, long value, boolean acceptEquals) {
        if (value > ((Node)node).value) {
            if (((Node)node).right == null) {
                return null;
            }
            return this.searchNearestHigher(((Node)node).right, value, acceptEquals);
        }
        if (value < ((Node)node).value) {
            if (((Node)node).left == null) {
                return node;
            }
            if (value < ((Node)node).left.value) {
                return this.searchNearestHigher(((Node)node).left, value, acceptEquals);
            }
            if (value == ((Node)node).left.value) {
                if (acceptEquals) {
                    return ((Node)node).left;
                }
                Node<T> n = this.searchNearestHigher(((Node)node).left, value, acceptEquals);
                if (n == null) {
                    return node;
                }
                return n;
            }
            Node<T> n = this.searchNearestHigher(((Node)node).left, value, acceptEquals);
            if (n == null) {
                return node;
            }
            return n;
        }
        if (acceptEquals) {
            return node;
        }
        if (((Node)node).right == null) {
            return null;
        }
        Node n = ((Node)node).right;
        while (n.left != null) {
            n = n.left;
        }
        return n;
    }

    @Override
    public void add(long value, T element) {
        if (this.root == null) {
            this.root = new Node(value, element, false);
            this.last = this.root;
            this.first = this.last;
            return;
        }
        this.root = this.add(value, element, this.root);
        ((Node)this.root).red = false;
    }

    private Node<T> add(long value, T element, Node<T> h) {
        if (value < ((Node)h).value) {
            if (((Node)h).left == null) {
                ((Node)h).left = new Node(value, element, true);
                if (value < ((Node)this.first).value) {
                    this.first = ((Node)h).left;
                }
            } else {
                ((Node)h).left = (Node)this.add(value, element, ((Node)h).left);
            }
        } else if (value >= ((Node)h).value) {
            if (((Node)h).right == null) {
                ((Node)h).right = new Node(value, element, true);
                if (value > ((Node)this.last).value) {
                    this.last = ((Node)h).right;
                }
            } else {
                ((Node)h).right = (Node)this.add(value, element, ((Node)h).right);
            }
        }
        if (((Node)h).right != null && ((Node)h).right.red && (((Node)h).left == null || !((Node)h).left.red)) {
            h = this.rotateLeft(h);
        }
        if (((Node)h).left != null && ((Node)h).left.red && ((Node)h).left.left != null && ((Node)h).left.left.red) {
            h = this.rotateRight(h);
        }
        if (((Node)h).left != null && ((Node)h).left.red && ((Node)h).right != null && ((Node)h).right.red) {
            this.flipColors(h);
        }
        ((Node)h).n = (((Node)h).left == null ? 0 : ((Node)h).left.n) + (((Node)h).right == null ? 0 : ((Node)h).right.n) + 1;
        return h;
    }

    public void removeMin() {
        if (this.root == null) {
            return;
        }
        if (!(((Node)this.root).left != null && ((Node)this.root).left.red || ((Node)this.root).right != null && ((Node)this.root).right.red)) {
            ((Node)this.root).red = true;
        }
        this.root = this.removeMin(this.root, true);
        if (this.root != null) {
            ((Node)this.root).red = false;
        } else {
            this.last = null;
            this.first = null;
        }
    }

    private Node<T> removeMin(Node<T> h, boolean updateFirst) {
        if (((Node)h).left == null) {
            return null;
        }
        if (!(((Node)h).left.red || ((Node)h).left.left != null && ((Node)h).left.left.red)) {
            h = this.moveRedLeft(h);
        }
        ((Node)h).left = (Node)this.removeMin(((Node)h).left, updateFirst);
        if (((Node)h).left == null && updateFirst) {
            this.first = h;
        }
        return this.balance(h);
    }

    public void removeMax() {
        if (this.root == null) {
            return;
        }
        if (!(((Node)this.root).left != null && ((Node)this.root).left.red || ((Node)this.root).right != null && ((Node)this.root).right.red)) {
            ((Node)this.root).red = true;
        }
        this.root = this.removeMax(this.root, true);
        if (this.root != null) {
            ((Node)this.root).red = false;
        } else {
            this.last = null;
            this.first = null;
        }
    }

    private Node<T> removeMax(Node<T> h, boolean updateLast) {
        if (((Node)h).left != null && ((Node)h).left.red) {
            h = this.rotateRight(h);
        }
        if (((Node)h).right == null) {
            return null;
        }
        if (!(((Node)h).right.red || ((Node)h).right.left != null && ((Node)h).right.left.red)) {
            h = this.moveRedRight(h);
        }
        ((Node)h).right = (Node)this.removeMax(((Node)h).right, updateLast);
        if (((Node)h).right == null && updateLast) {
            this.last = h;
        }
        return this.balance(h);
    }

    public void remove(Node<T> node) {
        if (this.first == node) {
            this.removeMin();
            return;
        }
        if (this.last == node) {
            this.removeMax();
            return;
        }
        if (!(((Node)this.root).left != null && ((Node)this.root).left.red || ((Node)this.root).right != null && ((Node)this.root).right.red)) {
            ((Node)this.root).red = true;
        }
        this.root = this.remove(this.root, node);
        if (this.root != null) {
            ((Node)this.root).red = false;
        } else {
            this.last = null;
            this.first = null;
        }
    }

    private Node<T> remove(Node<T> h, Node<T> node) {
        if (((Node)node).value < ((Node)h).value) {
            if (((Node)h).left == null || !((Node)h).left.red && (((Node)h).left.left == null || !((Node)h).left.left.red)) {
                h = this.moveRedLeft(h);
            }
            ((Node)h).left = (Node)this.remove(((Node)h).left, node);
        } else {
            if (((Node)h).left != null && ((Node)h).left.red) {
                h = this.rotateRight(h);
            }
            if (((Node)node).value == ((Node)h).value && ((Node)h).right == null) {
                return null;
            }
            if (((Node)h).right == null || !((Node)h).right.red && (((Node)h).right.left == null || !((Node)h).right.left.red)) {
                h = this.moveRedRight(h);
            }
            if (((Node)node).value == ((Node)h).value) {
                Node<T> x = this.min(((Node)h).right);
                ((Node)h).value = ((Node)x).value;
                ((Node)h).element = ((Node)x).element;
                ((Node)h).right = (Node)this.removeMin(((Node)h).right, false);
            } else {
                ((Node)h).right = (Node)this.remove(((Node)h).right, node);
            }
        }
        return this.balance(h);
    }

    @Override
    public void remove(long key, T element) {
        if (((Node)this.first).value == key && ObjectUtil.equalsOrNull(element, ((Node)this.first).element)) {
            this.removeMin();
            return;
        }
        if (((Node)this.last).value == key && ObjectUtil.equalsOrNull(element, ((Node)this.last).element)) {
            this.removeMax();
            return;
        }
        if (!(((Node)this.root).left != null && ((Node)this.root).left.red || ((Node)this.root).right != null && ((Node)this.root).right.red)) {
            ((Node)this.root).red = true;
        }
        this.root = this.remove(this.root, key, element);
        if (this.root != null) {
            ((Node)this.root).red = false;
        }
    }

    private Node<T> remove(Node<T> h, long key, T element) {
        if (key < ((Node)h).value) {
            if (((Node)h).left == null || !((Node)h).left.red && (((Node)h).left.left == null || !((Node)h).left.left.red)) {
                h = this.moveRedLeft(h);
            }
            ((Node)h).left = (Node)this.remove(((Node)h).left, key, element);
        } else {
            if (((Node)h).left != null && ((Node)h).left.red) {
                h = this.rotateRight(h);
            }
            if (key == ((Node)h).value && ObjectUtil.equalsOrNull(element, ((Node)h).element) && ((Node)h).right == null) {
                return null;
            }
            if (((Node)h).right == null || !((Node)h).right.red && (((Node)h).right.left == null || !((Node)h).right.left.red)) {
                h = this.moveRedRight(h);
            }
            if (key == ((Node)h).value && ObjectUtil.equalsOrNull(element, ((Node)h).element)) {
                Node<T> x = this.min(((Node)h).right);
                ((Node)h).value = ((Node)x).value;
                ((Node)h).element = ((Node)x).element;
                ((Node)h).right = (Node)this.removeMin(((Node)h).right, false);
            } else {
                ((Node)h).right = (Node)this.remove(((Node)h).right, key, element);
            }
        }
        return this.balance(h);
    }

    public void removeKey(long key) {
        if (key == ((Node)this.first).value) {
            this.removeMin();
            return;
        }
        if (key == ((Node)this.last).value) {
            this.removeMax();
            return;
        }
        if (!(((Node)this.root).left != null && ((Node)this.root).left.red || ((Node)this.root).right != null && ((Node)this.root).right.red)) {
            ((Node)this.root).red = true;
        }
        this.root = this.removeKey(this.root, key);
        if (this.root != null) {
            ((Node)this.root).red = false;
        }
    }

    private Node<T> removeKey(Node<T> h, long key) {
        if (key < ((Node)h).value) {
            if (((Node)h).left == null || !((Node)h).left.red && (((Node)h).left.left == null || !((Node)h).left.left.red)) {
                h = this.moveRedLeft(h);
            }
            ((Node)h).left = (Node)this.removeKey(((Node)h).left, key);
        } else {
            if (((Node)h).left != null && ((Node)h).left.red) {
                h = this.rotateRight(h);
            }
            if (key == ((Node)h).value && ((Node)h).right == null) {
                return null;
            }
            if (((Node)h).right == null || !((Node)h).right.red && (((Node)h).right.left == null || !((Node)h).right.left.red)) {
                h = this.moveRedRight(h);
            }
            if (key == ((Node)h).value) {
                Node<T> x = this.min(((Node)h).right);
                ((Node)h).value = ((Node)x).value;
                ((Node)h).element = ((Node)x).element;
                ((Node)h).right = (Node)this.removeMin(((Node)h).right, false);
            } else {
                ((Node)h).right = (Node)this.removeKey(((Node)h).right, key);
            }
        }
        return this.balance(h);
    }

    @Override
    public void removeInstance(long key, T instance) {
        if (((Node)this.first).value == key && instance == ((Node)this.first).element) {
            this.removeMin();
            return;
        }
        if (((Node)this.last).value == key && instance == ((Node)this.last).element) {
            this.removeMax();
            return;
        }
        if (!(((Node)this.root).left != null && ((Node)this.root).left.red || ((Node)this.root).right != null && ((Node)this.root).right.red)) {
            ((Node)this.root).red = true;
        }
        this.root = this.removeInstance(this.root, key, instance);
        if (this.root != null) {
            ((Node)this.root).red = false;
        }
    }

    private Node<T> removeInstance(Node<T> h, long key, T instance) {
        if (key < ((Node)h).value) {
            if (((Node)h).left == null || !((Node)h).left.red && (((Node)h).left.left == null || !((Node)h).left.left.red)) {
                h = this.moveRedLeft(h);
            }
            ((Node)h).left = (Node)this.removeInstance(((Node)h).left, key, instance);
        } else {
            if (((Node)h).left != null && ((Node)h).left.red) {
                h = this.rotateRight(h);
            }
            if (key == ((Node)h).value && instance == ((Node)h).element && ((Node)h).right == null) {
                return null;
            }
            if (((Node)h).right == null || !((Node)h).right.red && (((Node)h).right.left == null || !((Node)h).right.left.red)) {
                h = this.moveRedRight(h);
            }
            if (key == ((Node)h).value && instance == ((Node)h).element) {
                Node<T> x = this.min(((Node)h).right);
                ((Node)h).value = ((Node)x).value;
                ((Node)h).element = ((Node)x).element;
                ((Node)h).right = (Node)this.removeMin(((Node)h).right, false);
            } else {
                ((Node)h).right = (Node)this.removeInstance(((Node)h).right, key, instance);
            }
        }
        return this.balance(h);
    }

    private Node<T> rotateRight(Node<T> h) {
        Node x = ((Node)h).left;
        ((Node)h).left = x.right;
        x.right = (Node)h;
        x.red = x.right.red;
        x.right.red = true;
        x.n = ((Node)h).n;
        ((Node)h).n = (((Node)h).left == null ? 0 : ((Node)h).left.n) + (((Node)h).right == null ? 0 : ((Node)h).right.n) + 1;
        return x;
    }

    private Node<T> rotateLeft(Node<T> h) {
        Node x = ((Node)h).right;
        ((Node)h).right = x.left;
        x.left = (Node)h;
        x.red = x.left.red;
        x.left.red = true;
        x.n = ((Node)h).n;
        ((Node)h).n = (((Node)h).left == null ? 0 : ((Node)h).left.n) + (((Node)h).right == null ? 0 : ((Node)h).right.n) + 1;
        return x;
    }

    private void flipColors(Node<T> h) {
        ((Node)h).red = !((Node)h).red;
        ((Node)h).left.red = !((Node)h).left.red;
        ((Node)h).right.red = !((Node)h).right.red;
    }

    private Node<T> moveRedLeft(Node<T> h) {
        this.flipColors(h);
        if (((Node)h).right.left != null && ((Node)h).right.left.red) {
            ((Node)h).right = (Node)this.rotateRight(((Node)h).right);
            h = this.rotateLeft(h);
            this.flipColors(h);
        }
        return h;
    }

    private Node<T> moveRedRight(Node<T> h) {
        this.flipColors(h);
        if (((Node)h).left.left != null && ((Node)h).left.left.red) {
            h = this.rotateRight(h);
            this.flipColors(h);
        }
        return h;
    }

    private Node<T> balance(Node<T> h) {
        if (((Node)h).right != null && ((Node)h).right.red) {
            h = this.rotateLeft(h);
        }
        if (((Node)h).left != null && ((Node)h).left.red && ((Node)h).left.left != null && ((Node)h).left.left.red) {
            h = this.rotateRight(h);
        }
        if (((Node)h).left != null && ((Node)h).left.red && ((Node)h).right != null && ((Node)h).right.red) {
            this.flipColors(h);
        }
        ((Node)h).n = (((Node)h).left == null ? 0 : ((Node)h).left.n) + (((Node)h).right == null ? 0 : ((Node)h).right.n) + 1;
        return h;
    }

    private Node<T> min(Node<T> x) {
        while (x.left != null) {
            x = x.left;
        }
        return x;
    }

    @Override
    public Iterator<T> iterator() {
        return new RBTreeIterator(this.root);
    }

    public Iterator<Node<T>> nodeIterator() {
        return new RBTreeNodeIterator(this.root);
    }

    public Iterator<Node<T>> nodeIteratorOrdered() {
        return new NodeIteratorOrdered(this.root);
    }

    public Iterator<Node<T>> nodeIteratorReverse() {
        return new NodeIteratorReverseOrder(this.root);
    }

    @Override
    public Iterator<T> orderedIterator() {
        return new IteratorOrdered(this.root);
    }

    @Override
    public Iterator<T> reverseOrderIterator() {
        return new IteratorReverseOrder(this.root);
    }

    private static class IteratorReverseOrder<T>
    implements Iterator<T> {
        private NodeIteratorReverseOrder<T> it;

        private IteratorReverseOrder(Node<T> root) {
            this.it = new NodeIteratorReverseOrder(root);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return ((Node)this.it.next()).getElement();
        }
    }

    private static class NodeIteratorReverseOrder<T>
    implements Iterator<Node<T>> {
        private ArrayList<Node<T>> parents;
        private Node<T> next;

        private NodeIteratorReverseOrder(Node<T> root) {
            this.next = root;
            if (root == null) {
                return;
            }
            this.parents = new ArrayList(((Node)root).n / 2);
            while (((Node)this.next).right != null) {
                this.parents.add(this.next);
                this.next = ((Node)this.next).right;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node<T> next() {
            Node<T> res = this.next;
            if (((Node)this.next).left != null) {
                this.next = ((Node)this.next).left;
                while (((Node)this.next).right != null) {
                    this.parents.add(this.next);
                    this.next = ((Node)this.next).right;
                }
                return res;
            }
            if (this.parents.isEmpty()) {
                this.next = null;
                return res;
            }
            this.next = this.parents.remove(this.parents.size() - 1);
            return res;
        }
    }

    private static class IteratorOrdered<T>
    implements Iterator<T> {
        private NodeIteratorOrdered<T> it;

        private IteratorOrdered(Node<T> root) {
            this.it = new NodeIteratorOrdered(root);
        }

        @Override
        public boolean hasNext() {
            return this.it.hasNext();
        }

        @Override
        public T next() {
            return ((Node)this.it.next()).getElement();
        }
    }

    private static class NodeIteratorOrdered<T>
    implements Iterator<Node<T>> {
        private ArrayList<Node<T>> parents;
        private Node<T> next;

        private NodeIteratorOrdered(Node<T> root) {
            this.next = root;
            if (root == null) {
                return;
            }
            this.parents = new ArrayList(((Node)root).n / 2);
            while (((Node)this.next).left != null) {
                this.parents.add(this.next);
                this.next = ((Node)this.next).left;
            }
        }

        @Override
        public boolean hasNext() {
            return this.next != null;
        }

        @Override
        public Node<T> next() {
            Node<T> res = this.next;
            if (((Node)this.next).right != null) {
                this.next = ((Node)this.next).right;
                while (((Node)this.next).left != null) {
                    this.parents.add(this.next);
                    this.next = ((Node)this.next).left;
                }
                return res;
            }
            if (this.parents.isEmpty()) {
                this.next = null;
                return res;
            }
            this.next = this.parents.remove(this.parents.size() - 1);
            return res;
        }
    }

    private class RBTreeNodeIterator
    implements Iterator<Node<T>> {
        private Node<T> node;
        private RBTreeNodeIterator leftIterator = null;
        private RBTreeNodeIterator rightIterator = null;

        private RBTreeNodeIterator(Node<T> node) {
            this.node = node;
        }

        @Override
        public boolean hasNext() {
            return this.node != null || this.leftIterator != null || this.rightIterator != null;
        }

        @Override
        public Node<T> next() {
            if (this.node != null) {
                if (this.node.left != null) {
                    this.leftIterator = new RBTreeNodeIterator(this.node.left);
                }
                if (this.node.right != null) {
                    this.rightIterator = new RBTreeNodeIterator(this.node.right);
                }
                Node n = this.node;
                this.node = null;
                return n;
            }
            if (this.leftIterator != null) {
                Object n = this.leftIterator.next();
                if (!this.leftIterator.hasNext()) {
                    this.leftIterator = null;
                }
                return n;
            }
            Object n = this.rightIterator.next();
            if (!this.rightIterator.hasNext()) {
                this.rightIterator = null;
            }
            return n;
        }
    }

    private class RBTreeIterator
    implements Iterator<T> {
        private Node<T> node;
        private RBTreeIterator leftIterator = null;
        private RBTreeIterator rightIterator = null;

        private RBTreeIterator(Node<T> node) {
            this.node = node;
        }

        @Override
        public boolean hasNext() {
            return this.node != null || this.leftIterator != null || this.rightIterator != null;
        }

        @Override
        public T next() {
            if (this.node != null) {
                if (this.node.left != null) {
                    this.leftIterator = new RBTreeIterator(this.node.left);
                }
                if (this.node.right != null) {
                    this.rightIterator = new RBTreeIterator(this.node.right);
                }
                Object e = this.node.element;
                this.node = null;
                return e;
            }
            if (this.leftIterator != null) {
                Object e = this.leftIterator.next();
                if (!this.leftIterator.hasNext()) {
                    this.leftIterator = null;
                }
                return e;
            }
            Object e = this.rightIterator.next();
            if (!this.rightIterator.hasNext()) {
                this.rightIterator = null;
            }
            return e;
        }
    }

    public static class Node<T> {
        private long value;
        private T element;
        private Node<T> left;
        private Node<T> right;
        private boolean red;
        private int n = 1;

        private Node(long value, T element, boolean red) {
            this.value = value;
            this.element = element;
            this.red = red;
        }

        public long getValue() {
            return this.value;
        }

        public T getElement() {
            return this.element;
        }

        public void setElement(T element) {
            this.element = element;
        }
    }
}

