/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections.sort;

import java.util.Iterator;
import net.lecousin.framework.collections.ArrayIterator;

public class OldestList<T>
implements Iterable<T> {
    private Object[] elements;
    private long[] dates;
    private int size;
    private int oldestIndex = -1;
    private int newestIndex = -1;

    public OldestList(int nb) {
        this.elements = new Object[nb];
        this.dates = new long[nb];
        this.size = 0;
    }

    public void add(long date, T element) {
        if (this.size == 0) {
            this.elements[0] = element;
            this.dates[0] = date;
            this.size = 1;
            this.oldestIndex = 0;
            this.newestIndex = 0;
            return;
        }
        if (this.size < this.elements.length) {
            this.elements[this.size] = element;
            this.dates[this.size] = date;
            if (date < this.dates[this.oldestIndex]) {
                this.oldestIndex = this.size;
            }
            if (date > this.dates[this.newestIndex]) {
                this.newestIndex = this.size;
            }
            ++this.size;
            return;
        }
        if (this.dates[this.oldestIndex] > date) {
            if (this.newestIndex < 0) {
                this.refreshNewestIndex();
            }
            this.elements[this.newestIndex] = element;
            this.dates[this.newestIndex] = date;
            this.oldestIndex = this.newestIndex;
            this.newestIndex = -1;
            return;
        }
        if (this.newestIndex < 0) {
            this.refreshNewestIndex();
        }
        if (this.dates[this.newestIndex] < date) {
            return;
        }
        this.elements[this.newestIndex] = element;
        this.dates[this.newestIndex] = date;
        this.oldestIndex = this.newestIndex;
        this.newestIndex = -1;
    }

    private void refreshNewestIndex() {
        for (int i = this.elements.length - 1; i >= 0; --i) {
            if (this.newestIndex != -1 && this.dates[i] <= this.dates[this.newestIndex]) continue;
            this.newestIndex = i;
        }
    }

    @Override
    public Iterator<T> iterator() {
        return new ArrayIterator<Object>(this.elements, this.size);
    }
}

