/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.lang.reflect.Array;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.Deque;
import java.util.Iterator;
import java.util.List;
import java.util.NoSuchElementException;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.exception.NoException;

public class TurnArray<T>
implements Deque<T> {
    private Object[] array;
    private int start = 0;
    private int end = 0;
    private int minSize;
    private DecreaseTask decreaseTask = null;

    public TurnArray() {
        this(5, 5);
    }

    public TurnArray(int initSize) {
        this(initSize, initSize);
    }

    public TurnArray(int initSize, int minSize) {
        if (initSize <= 0) {
            throw new IllegalArgumentException("initSize must be positive, given: " + initSize);
        }
        if (minSize < 5) {
            minSize = 5;
        }
        this.minSize = minSize;
        this.array = new Object[initSize];
    }

    public synchronized boolean isFull() {
        return this.end == -1;
    }

    @Override
    public synchronized void addLast(T element) {
        if (this.end == -1) {
            this.increase();
        }
        this.array[this.end++] = element;
        if (this.end == this.array.length) {
            this.end = 0;
        }
        if (this.end == this.start) {
            this.end = -1;
        }
    }

    @Override
    public synchronized void addFirst(T e) {
        if (this.end == -1) {
            this.increase();
        }
        if (this.start == 0) {
            this.start = this.array.length - 1;
            this.array[this.start] = e;
        } else {
            this.array[--this.start] = e;
        }
        if (this.end == this.start) {
            this.end = -1;
        }
    }

    @Override
    public synchronized boolean addAll(Collection<? extends T> elements) {
        int a;
        int nb = elements.size();
        if (nb == 0) {
            return false;
        }
        int n = this.end == -1 ? 0 : (a = this.end < this.start ? this.start - this.end : this.start + (this.array.length - this.end));
        if (a < nb) {
            this.increase(this.array.length + (nb - a) + 5);
        }
        for (T e : elements) {
            this.array[this.end++] = e;
            if (this.end == this.array.length) {
                this.end = 0;
            }
            if (this.end != this.start) continue;
            this.end = -1;
        }
        return true;
    }

    @Override
    public synchronized T removeFirst() {
        if (this.end == this.start) {
            throw new NoSuchElementException("Collection is empty");
        }
        if (this.end == -1) {
            this.end = this.start;
        }
        Object e = this.array[this.start];
        this.array[this.start++] = null;
        if (this.start == this.array.length) {
            this.start = 0;
        }
        this.checkDecrease();
        return (T)e;
    }

    @Override
    public synchronized T removeLast() {
        Object e;
        if (this.end == this.start) {
            throw new NoSuchElementException("Collection is empty");
        }
        if (this.end == -1) {
            this.end = this.start;
        }
        if (this.end == 0) {
            this.end = this.array.length - 1;
            e = this.array[this.end];
        } else {
            e = this.array[--this.end];
        }
        this.array[this.end] = null;
        this.checkDecrease();
        return (T)e;
    }

    @Override
    public boolean isEmpty() {
        return this.start == this.end;
    }

    @Override
    public synchronized T getFirst() {
        if (this.end == this.start) {
            throw new NoSuchElementException("Collection is empty");
        }
        return (T)this.array[this.start];
    }

    @Override
    public synchronized T getLast() {
        if (this.end == this.start) {
            throw new NoSuchElementException("Collection is empty");
        }
        if (this.end == -1) {
            if (this.start == 0) {
                return (T)this.array[this.array.length - 1];
            }
            return (T)this.array[this.start - 1];
        }
        if (this.end == 0) {
            return (T)this.array[this.array.length - 1];
        }
        return (T)this.array[this.end - 1];
    }

    @Override
    public synchronized int size() {
        if (this.end == -1) {
            return this.array.length;
        }
        if (this.start == this.end) {
            return 0;
        }
        if (this.end > this.start) {
            return this.end - this.start;
        }
        return this.array.length - this.start + this.end;
    }

    @Override
    public synchronized void clear() {
        if (this.end == this.start) {
            return;
        }
        if (this.end == -1) {
            for (int i = this.array.length - 1; i >= 0; --i) {
                this.array[i] = null;
            }
        } else if (this.end < this.start) {
            while (this.start < this.array.length) {
                this.array[this.start++] = null;
            }
            this.start = 0;
            while (this.start < this.end) {
                this.array[this.start] = null;
                ++this.start;
            }
        } else {
            while (this.start < this.end) {
                this.array[this.start++] = null;
            }
        }
        this.end = 0;
        this.start = 0;
        this.checkDecrease();
    }

    @Override
    public boolean add(T e) {
        this.addLast(e);
        return true;
    }

    @Override
    public boolean offer(T e) {
        this.addLast(e);
        return false;
    }

    @Override
    public boolean offerFirst(T e) {
        this.addFirst(e);
        return true;
    }

    @Override
    public boolean offerLast(T e) {
        this.addLast(e);
        return true;
    }

    @Override
    public T peek() {
        return this.peekFirst();
    }

    @Override
    public synchronized T peekFirst() {
        if (this.end == this.start) {
            return null;
        }
        return (T)this.array[this.start];
    }

    @Override
    public synchronized T peekLast() {
        if (this.end == this.start) {
            return null;
        }
        if (this.end == -1) {
            if (this.start == 0) {
                return (T)this.array[this.array.length - 1];
            }
            return (T)this.array[this.start - 1];
        }
        if (this.end == 0) {
            return (T)this.array[this.array.length - 1];
        }
        return (T)this.array[this.end - 1];
    }

    @Override
    public T poll() {
        return this.pollFirst();
    }

    @Override
    public synchronized T pollFirst() {
        if (this.end == this.start) {
            return null;
        }
        if (this.end == -1) {
            this.end = this.start;
        }
        Object e = this.array[this.start];
        this.array[this.start++] = null;
        if (this.start == this.array.length) {
            this.start = 0;
        }
        this.checkDecrease();
        return (T)e;
    }

    @Override
    public synchronized T pollLast() {
        Object e;
        if (this.end == this.start) {
            return null;
        }
        if (this.end == -1) {
            this.end = this.start;
        }
        if (this.end == 0) {
            this.end = this.array.length - 1;
            e = this.array[this.end];
        } else {
            e = this.array[--this.end];
        }
        this.array[this.end] = null;
        this.checkDecrease();
        return (T)e;
    }

    @Override
    public void push(T e) {
        this.addFirst(e);
    }

    @Override
    public T pop() {
        return this.removeFirst();
    }

    @Override
    public T element() {
        return this.getFirst();
    }

    @Override
    public T remove() {
        return this.removeFirst();
    }

    private void increase() {
        int newSize = this.array.length;
        if ((newSize += newSize >> 1) < this.array.length + 5) {
            newSize = this.array.length + 5;
        }
        this.increase(newSize);
    }

    private void increase(int newSize) {
        if (this.decreaseTask != null) {
            this.decreaseTask.cancel(new CancelException("TurnArray increase again"));
            this.decreaseTask = null;
        }
        Object[] a = new Object[newSize];
        if (this.end == -1) {
            System.arraycopy(this.array, this.start, a, 0, this.array.length - this.start);
            if (this.start > 0) {
                System.arraycopy(this.array, 0, a, this.array.length - this.start, this.start);
            }
            this.start = 0;
            this.end = this.array.length;
        } else if (this.end < this.start) {
            System.arraycopy(this.array, this.start, a, 0, this.array.length - this.start);
            System.arraycopy(this.array, 0, a, this.array.length - this.start, this.end + 1);
            this.end = this.array.length - this.start + this.end;
            this.start = 0;
        } else {
            System.arraycopy(this.array, this.start, a, 0, this.end - this.start + 1);
            this.end -= this.start;
            this.start = 0;
        }
        this.array = a;
    }

    private void checkDecrease() {
        if (this.decreaseTask != null) {
            return;
        }
        if (!Threading.isInitialized()) {
            return;
        }
        if (this.array.length > this.minSize && this.size() < this.array.length - (this.array.length >> 1)) {
            this.decreaseTask = new DecreaseTask();
        }
    }

    private void decrease() {
        int newSize = this.array.length - (this.array.length >> 1);
        if (newSize < this.minSize) {
            newSize = this.minSize;
        }
        if (newSize >= this.array.length) {
            return;
        }
        if (this.size() >= newSize) {
            return;
        }
        if (this.end == -1) {
            return;
        }
        Object[] a = new Object[newSize];
        if (this.end > this.start) {
            System.arraycopy(this.array, this.start, a, 0, this.end - this.start);
            this.end -= this.start;
            this.start = 0;
        } else if (this.end < this.start) {
            System.arraycopy(this.array, this.start, a, 0, this.array.length - this.start);
            if (this.end > 0) {
                System.arraycopy(this.array, 0, a, this.array.length - this.start, this.end);
            }
            this.end = this.array.length - this.start + this.end;
            this.start = 0;
        } else {
            this.end = 0;
            this.start = 0;
        }
        this.array = a;
    }

    @Override
    public synchronized boolean contains(Object o) {
        if (this.start == this.end) {
            return false;
        }
        if (this.end == -1) {
            for (int i = this.array.length - 1; i >= 0; --i) {
                if (!this.array[i].equals(o)) continue;
                return true;
            }
            return false;
        }
        if (this.end < this.start) {
            int i;
            for (i = this.array.length - 1; i >= this.start; --i) {
                if (!this.array[i].equals(o)) continue;
                return true;
            }
            for (i = 0; i < this.end; ++i) {
                if (!this.array[i].equals(o)) continue;
                return true;
            }
            return false;
        }
        for (int i = this.start; i < this.end; ++i) {
            if (!this.array[i].equals(o)) continue;
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean containsAll(Collection<?> c) {
        for (Object o : c) {
            if (this.contains(o)) continue;
            return false;
        }
        return true;
    }

    public synchronized boolean removeAny(Object element) {
        if (this.end == this.start) {
            return false;
        }
        if (this.end == -1) {
            for (int i = this.array.length - 1; i >= 0; --i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }
        if (this.end < this.start) {
            int i;
            for (i = this.array.length - 1; i >= this.start; --i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            for (i = 0; i < this.end; ++i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }
        for (int i = this.start; i < this.end; ++i) {
            if (!this.array[i].equals(element)) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeFirstOccurrence(Object element) {
        if (this.end == this.start) {
            return false;
        }
        if (this.end == -1) {
            int i;
            for (i = this.start; i < this.array.length; ++i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            for (i = 0; i < this.start; ++i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }
        if (this.end < this.start) {
            int i;
            for (i = this.start; i < this.array.length; ++i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            for (i = 0; i < this.end; ++i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }
        for (int i = this.start; i < this.end; ++i) {
            if (!this.array[i].equals(element)) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public synchronized boolean removeLastOccurrence(Object element) {
        if (this.end == this.start) {
            return false;
        }
        if (this.end == -1) {
            int i;
            for (i = this.start - 1; i >= 0; --i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            for (i = this.array.length - 1; i >= this.start; --i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }
        if (this.end < this.start) {
            int i;
            for (i = this.end - 1; i >= 0; --i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            for (i = this.array.length - 1; i >= this.start; --i) {
                if (!this.array[i].equals(element)) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }
        for (int i = this.end - 1; i >= this.start; --i) {
            if (!this.array[i].equals(element)) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    public synchronized boolean removeInstance(T element) {
        if (this.end == this.start) {
            return false;
        }
        if (this.end == -1) {
            for (int i = this.array.length - 1; i >= 0; --i) {
                if (this.array[i] != element) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }
        if (this.end < this.start) {
            int i;
            for (i = this.array.length - 1; i >= this.start; --i) {
                if (this.array[i] != element) continue;
                this.removeAt(i);
                return true;
            }
            for (i = 0; i < this.end; ++i) {
                if (this.array[i] != element) continue;
                this.removeAt(i);
                return true;
            }
            return false;
        }
        for (int i = this.start; i < this.end; ++i) {
            if (this.array[i] != element) continue;
            this.removeAt(i);
            return true;
        }
        return false;
    }

    @Override
    public boolean remove(Object o) {
        return this.removeFirstOccurrence(o);
    }

    @Override
    public synchronized boolean removeAll(Collection<?> c) {
        boolean changed = false;
        for (Object o : c) {
            changed |= this.remove(o);
        }
        return changed;
    }

    private void removeAt(int index) {
        try {
            if (index >= this.start) {
                if (this.end == -1) {
                    if (index < this.array.length - 1) {
                        System.arraycopy(this.array, index + 1, this.array, index, this.array.length - index - 1);
                    }
                    if (this.start == 0) {
                        this.end = this.array.length - 1;
                        this.array[this.end] = null;
                        return;
                    }
                    this.array[this.array.length - 1] = this.array[0];
                    if (this.start == 1) {
                        this.array[0] = null;
                        this.end = 0;
                        return;
                    }
                    System.arraycopy(this.array, 1, this.array, 0, this.start - 1);
                    this.end = this.start - 1;
                    this.array[this.end] = null;
                    return;
                }
                if (index == this.end - 1) {
                    this.array[index] = null;
                    --this.end;
                    return;
                }
                if (this.end > this.start) {
                    System.arraycopy(this.array, index + 1, this.array, index, this.end - index - 1);
                    this.array[--this.end] = null;
                    return;
                }
                if (index < this.array.length - 1) {
                    System.arraycopy(this.array, index + 1, this.array, index, this.array.length - index - 1);
                }
                if (this.end == 0) {
                    this.end = this.array.length - 1;
                    this.array[this.end] = null;
                    return;
                }
                this.array[this.array.length - 1] = this.array[0];
                if (this.end == 1) {
                    this.array[0] = null;
                    this.end = 0;
                    return;
                }
                System.arraycopy(this.array, 1, this.array, 0, this.end - 1);
                this.array[--this.end] = null;
                return;
            }
            if (this.end == -1) {
                if (index == this.start - 1) {
                    this.array[index] = null;
                    this.end = index;
                    return;
                }
                System.arraycopy(this.array, index + 1, this.array, index, this.start - index - 1);
                this.array[this.start - 1] = null;
                this.end = this.start - 1;
                return;
            }
            if (index == this.end - 1) {
                this.array[index] = null;
                --this.end;
                return;
            }
            System.arraycopy(this.array, index + 1, this.array, index, this.end - index);
            this.array[--this.end] = null;
            return;
        }
        finally {
            this.checkDecrease();
        }
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        throw new UnsupportedOperationException("retainAll");
    }

    @Override
    public Iterator<T> iterator() {
        return new It();
    }

    @Override
    public Iterator<T> descendingIterator() {
        return new DIt();
    }

    public synchronized List<T> removeAllNoOrder() {
        if (this.end == -1) {
            List<Object> a = Arrays.asList(this.array);
            this.array = new Object[this.array.length];
            this.end = 0;
            this.start = 0;
            return a;
        }
        if (this.start == this.end) {
            return Collections.EMPTY_LIST;
        }
        if (this.end > this.start) {
            Object[] a = new Object[this.end - this.start];
            System.arraycopy(this.array, this.start, a, 0, this.end - this.start);
            for (int i = this.start; i < this.end; ++i) {
                this.array[i] = null;
            }
            this.end = 0;
            this.start = 0;
            return Arrays.asList(a);
        }
        Object[] a = new Object[this.array.length - this.start + this.end];
        System.arraycopy(this.array, this.start, a, 0, this.array.length - this.start);
        if (this.end > 0) {
            System.arraycopy(this.array, 0, a, this.array.length - this.start, this.end);
        }
        for (int i = this.array.length - 1; i >= 0; --i) {
            this.array[i] = null;
        }
        this.end = 0;
        this.start = 0;
        return Arrays.asList(a);
    }

    @Override
    public synchronized Object[] toArray() {
        if (this.end == this.start) {
            return new Object[0];
        }
        if (this.end == -1) {
            Object[] a = new Object[this.array.length];
            System.arraycopy(this.array, this.start, a, 0, this.array.length - this.start);
            if (this.start > 0) {
                System.arraycopy(this.array, 0, a, this.array.length - this.start, this.start);
            }
            return a;
        }
        Object[] a = new Object[this.size()];
        if (this.end < this.start) {
            System.arraycopy(this.array, this.start, a, 0, this.array.length - this.start);
            if (this.end > 0) {
                System.arraycopy(this.array, 0, a, this.array.length - this.start, this.end);
            }
        } else {
            System.arraycopy(this.array, this.start, a, 0, this.end - this.start);
        }
        return a;
    }

    @Override
    public synchronized <U> U[] toArray(U[] a) {
        if (this.end == this.start) {
            return a;
        }
        int nb = this.size();
        if (a.length < nb) {
            a = (Object[])Array.newInstance(a.getClass().getComponentType(), nb);
        }
        if (this.end == -1) {
            System.arraycopy(this.array, this.start, a, 0, this.array.length - this.start);
            if (this.start > 0) {
                System.arraycopy(this.array, 0, a, this.array.length - this.start, this.start);
            }
            return a;
        }
        if (this.end < this.start) {
            System.arraycopy(this.array, this.start, a, 0, this.array.length - this.start);
            if (this.end > 0) {
                System.arraycopy(this.array, 0, a, this.array.length - this.start, this.end);
            }
        } else {
            System.arraycopy(this.array, this.start, a, 0, this.end - this.start);
        }
        return a;
    }

    private class DIt
    implements Iterator<T> {
        private int pos;

        public DIt() {
            this.pos = TurnArray.this.size() - 1;
        }

        @Override
        public boolean hasNext() {
            return this.pos >= 0;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            if (this.pos < 0) {
                throw new NoSuchElementException();
            }
            TurnArray turnArray = TurnArray.this;
            synchronized (turnArray) {
                int i = TurnArray.this.start + this.pos;
                if (i >= TurnArray.this.array.length) {
                    i -= TurnArray.this.array.length;
                }
                Object e = TurnArray.this.array[i];
                --this.pos;
                return e;
            }
        }
    }

    private class It
    implements Iterator<T> {
        private int pos = 0;

        @Override
        public boolean hasNext() {
            return this.pos < TurnArray.this.size();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public T next() {
            TurnArray turnArray = TurnArray.this;
            synchronized (turnArray) {
                if (this.pos >= TurnArray.this.size()) {
                    throw new NoSuchElementException();
                }
                int i = TurnArray.this.start + this.pos;
                if (i >= TurnArray.this.array.length) {
                    i -= TurnArray.this.array.length;
                }
                Object e = TurnArray.this.array[i];
                ++this.pos;
                return e;
            }
        }
    }

    private class DecreaseTask
    extends Task.Cpu<Void, NoException> {
        public DecreaseTask() {
            super("Decrease Queue_ArrayRound size", (byte)6);
            this.start();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public Void run() {
            TurnArray turnArray = TurnArray.this;
            synchronized (turnArray) {
                if (this.isCancelling()) {
                    return null;
                }
                TurnArray.this.decreaseTask = null;
                TurnArray.this.decrease();
            }
            return null;
        }
    }
}

