/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import net.lecousin.framework.util.ObjectUtil;

public class TreeWithParent<T> {
    private TreeWithParent<T> parent;
    private ArrayList<Node<T>> nodes = new ArrayList();

    public TreeWithParent(TreeWithParent<T> parent) {
        this.parent = parent;
    }

    public TreeWithParent<T> getParent() {
        return this.parent;
    }

    public Node<T> add(T element) {
        Node node = new Node(this, element);
        this.nodes.add(node);
        return node;
    }

    public boolean remove(T element) {
        Iterator<Node<T>> it = this.nodes.iterator();
        while (it.hasNext()) {
            if (!ObjectUtil.equalsOrNull(((Node)it.next()).element, element)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public boolean removeInstance(T element) {
        Iterator<Node<T>> it = this.nodes.iterator();
        while (it.hasNext()) {
            if (((Node)it.next()).element != element) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public Node<T> get(T element) {
        for (Node<T> node : this.nodes) {
            if (!((Node)node).element.equals(element)) continue;
            return node;
        }
        return null;
    }

    public Node<T> get(int index) {
        return this.nodes.get(index);
    }

    public List<Node<T>> getNodes() {
        return new ArrayList<Node<T>>(this.nodes);
    }

    public List<T> getElements() {
        ArrayList<Object> list = new ArrayList<Object>(this.nodes.size());
        for (Node<T> node : this.nodes) {
            list.add(((Node)node).element);
        }
        return list;
    }

    public int size() {
        return this.nodes.size();
    }

    public static class Node<T> {
        private T element;
        private TreeWithParent<T> subNodes;

        private Node(TreeWithParent<T> parent, T element) {
            this.subNodes = new TreeWithParent<T>(parent);
            this.element = element;
        }

        public T getElement() {
            return this.element;
        }

        public TreeWithParent<T> getSubNodes() {
            return this.subNodes;
        }
    }
}

