/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import java.util.ListIterator;
import java.util.NoSuchElementException;
import net.lecousin.framework.collections.ArrayUtil;

public class LinkedArrayList<T>
implements List<T> {
    private int arraySize;
    private Array<T> head = null;
    private Array<T> tail = null;
    private long size = 0L;

    public LinkedArrayList(int arraySize) {
        this.arraySize = arraySize;
    }

    private void double_size() {
        Array a = this.head;
        do {
            Object[] na = new Object[this.arraySize * 2];
            System.arraycopy(a.array, 0, na, 0, a.size);
            Array.access$002(a, na);
            if (a.next == null) break;
            System.arraycopy(a.next.array, 0, a.array, a.size, a.next.size);
            Array array = a;
            array.size = array.size + a.next.size;
            a.next = a.next.next;
            if (a.next != null) {
                a.next.previous = a;
                continue;
            }
            this.tail = a;
        } while ((a = a.next) != null);
        this.arraySize *= 2;
    }

    @Override
    public boolean add(T o) {
        if (this.tail == null) {
            this.tail = new Array(this.arraySize, null, null);
            this.head = this.tail;
        } else if (((Array)this.tail).size == this.arraySize) {
            this.tail = new Array<T>(this.arraySize, this.tail, null);
        }
        ((Array)this.tail).add(o);
        ++this.size;
        if (this.size > (long)(this.arraySize * 100)) {
            this.double_size();
        }
        return true;
    }

    @Override
    public void add(int index, T element) {
        if (this.head == null) {
            this.add(element);
            return;
        }
        if (this.size + 1L > (long)(this.arraySize * 100)) {
            this.double_size();
        }
        if ((long)index >= this.size) {
            this.add(element, this.tail, ((Array)this.tail).size, false);
            return;
        }
        Array a = this.head;
        int i = 0;
        while (i + a.size <= index && a.next != null) {
            i += a.size;
            a = a.next;
        }
        this.add(element, a, index - i, false);
    }

    private void add(T element, Array<T> array, int index, boolean shifting) {
        if (index > ((Array)array).size) {
            index = ((Array)array).size;
        }
        if (index == ((Array)array).size) {
            if (index == this.arraySize) {
                if (((Array)array).next == null) {
                    this.tail = new Array<T>(this.arraySize, array, null);
                    ((Array)this.tail).add(element);
                    if (!shifting) {
                        ++this.size;
                    }
                    return;
                }
                throw new RuntimeException("Unexpected situation");
            }
            ((Array)array).array[index] = element;
            ((Array)array).size++;
            if (!shifting) {
                ++this.size;
            }
            return;
        }
        if (((Array)array).size == this.arraySize) {
            if (((Array)array).next == null) {
                this.tail = new Array<T>(this.arraySize, array, null);
                ((Array)this.tail).add(((Array)array).array[this.arraySize - 1]);
            } else {
                this.add(((Array)array).array[this.arraySize - 1], ((Array)array).next, 0, true);
            }
            ((Array)array).size--;
        }
        System.arraycopy(((Array)array).array, index, ((Array)array).array, index + 1, ((Array)array).size - index);
        ((Array)array).array[index] = element;
        ((Array)array).size++;
        if (!shifting) {
            ++this.size;
        }
    }

    public void addlong(long index, T element) {
        if (this.head == null) {
            this.add(element);
            return;
        }
        if (this.size + 1L > (long)(this.arraySize * 100)) {
            this.double_size();
        }
        if (index >= this.size) {
            this.add(element, this.tail, ((Array)this.tail).size, false);
            return;
        }
        Array a = this.head;
        long i = 0L;
        while (i + (long)a.size <= index && a.next != null) {
            i += (long)a.size;
            a = a.next;
        }
        this.add(element, a, (int)(index - i), false);
    }

    @Override
    public boolean addAll(Collection<? extends T> c) {
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            this.add(it.next());
        }
        return true;
    }

    @Override
    public boolean addAll(int index, Collection<? extends T> c) {
        Iterator<T> it = c.iterator();
        while (it.hasNext()) {
            this.add(index, it.next());
            ++index;
        }
        return true;
    }

    @Override
    public void clear() {
        this.tail = null;
        this.head = null;
        this.size = 0L;
    }

    @Override
    public boolean contains(Object o) {
        return this.indexOf(o) >= 0;
    }

    @Override
    public boolean containsAll(Collection<?> c) {
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            if (this.contains(it.next())) continue;
            return false;
        }
        return true;
    }

    @Override
    public T get(int index) {
        if (this.head == null) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Array a = this.head;
        int i = 0;
        while (i + a.size <= index && a.next != null) {
            i += a.size;
            a = a.next;
        }
        if ((i = index - i) >= a.size) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        return (T)a.array[i];
    }

    public T getlong(long index) {
        if (this.head == null) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        if (index < 0L) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        Array a = this.head;
        long i = 0L;
        while (i + (long)a.size <= index && a.next != null) {
            i += (long)a.size;
            a = a.next;
        }
        if ((i = index - i) >= (long)a.size) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        return (T)a.array[(int)i];
    }

    @Override
    public int indexOf(Object o) {
        int index = 0;
        Array a = this.head;
        while (a != null) {
            int i = a.indexOf(o);
            if (i >= 0) {
                return i + index;
            }
            index += a.size;
            a = a.next;
        }
        return -1;
    }

    @Override
    public boolean isEmpty() {
        return this.head == null;
    }

    private void shiftLeft(Array<T> a, int i) {
        if (i >= ((Array)a).size) {
            return;
        }
        if (((Array)a).size == 1) {
            if (this.head == a) {
                if (this.tail == a) {
                    this.tail = null;
                } else {
                    ((Array)this.head).next.previous = null;
                }
                this.head = ((Array)this.head).next;
            } else if (this.tail == a) {
                ((Array)this.tail).previous.next = null;
                this.tail = ((Array)this.tail).previous;
            } else {
                ((Array)a).previous.next = ((Array)a).next;
                ((Array)a).next.previous = ((Array)a).previous;
            }
            return;
        }
        if (i < ((Array)a).size - 1) {
            System.arraycopy(((Array)a).array, i + 1, ((Array)a).array, i, ((Array)a).size - i - 1);
        }
        ((Array)a).array[((Array)a).size - 1] = null;
        ((Array)a).size--;
    }

    @Override
    public T remove(int index) {
        if (this.head == null) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Array a = this.head;
        int i = 0;
        while (i + a.size <= index && a.next != null) {
            i += a.size;
            a = a.next;
        }
        if ((i = index - i) >= a.size) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Object element = a.array[i];
        this.shiftLeft(a, i);
        --this.size;
        return (T)element;
    }

    @Override
    public boolean remove(Object o) {
        int i = this.indexOf(o);
        if (i == -1) {
            return false;
        }
        this.remove(i);
        return true;
    }

    public T removelong(long index) {
        if (this.head == null) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        if (index < 0L) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        Array a = this.head;
        long i = 0L;
        while (i + (long)a.size <= index && a.next != null) {
            i += (long)a.size;
            a = a.next;
        }
        if ((i = index - i) >= (long)a.size) {
            throw new IndexOutOfBoundsException(Long.toString(index));
        }
        Object element = a.array[(int)i];
        this.shiftLeft(a, (int)i);
        --this.size;
        return (T)element;
    }

    @Override
    public boolean removeAll(Collection<?> c) {
        boolean changed = false;
        Iterator<?> it = c.iterator();
        while (it.hasNext()) {
            changed |= this.remove(it.next());
        }
        return changed;
    }

    @Override
    public T removeLast() {
        if (this.tail == null) {
            return null;
        }
        Object element = ((Array)this.tail).array[--((Array)this.tail).size];
        if (--this.size == 0L) {
            this.tail = null;
            this.head = null;
            return (T)element;
        }
        if (((Array)this.tail).size == 0) {
            ((Array)this.tail).previous.next = null;
            this.tail = ((Array)this.tail).previous;
        }
        return (T)element;
    }

    public T[] removeFirstArray(Class<T> cl) {
        Object[] a;
        if (this.size == 0L) {
            return ArrayUtil.createGenericArrayOf(0, cl);
        }
        if (((Array)this.head).size == ((Array)this.head).array.length) {
            a = ((Array)this.head).array;
        } else {
            a = ArrayUtil.createGenericArrayOf(((Array)this.head).size, cl);
            System.arraycopy(((Array)this.head).array, 0, a, 0, ((Array)this.head).size);
        }
        if (this.head == this.tail) {
            this.tail = null;
            this.head = null;
            this.size = 0L;
            return a;
        }
        this.size -= (long)((Array)this.head).size;
        ((Array)this.head).next.previous = null;
        this.head = ((Array)this.head).next;
        return a;
    }

    public void insertFirstArray(T[] array, int offset, int length) {
        if (length == 0) {
            return;
        }
        if (length > this.arraySize) {
            this.insertFirstArray(array, offset + this.arraySize, length - this.arraySize);
            this.insertFirstArray(array, offset, this.arraySize);
            return;
        }
        Array<T> a = new Array<T>(this.arraySize, null, this.head);
        System.arraycopy(array, offset, ((Array)a).array, 0, length);
        ((Array)a).size = length;
        this.head = a;
        this.size += (long)length;
    }

    public void appendArray(T[] array, int offset, int length) {
        int len;
        if (length == 0) {
            return;
        }
        if (this.size + (long)length > (long)(this.arraySize * 100)) {
            this.double_size();
        }
        if (this.tail != null) {
            while (((Array)this.tail).size < this.arraySize && length > 0) {
                ((Array)this.tail).add(array[offset++]);
                --length;
                ++this.size;
            }
            if (length == 0) {
                return;
            }
        }
        do {
            Array<T> a = new Array<T>(this.arraySize, this.tail, null);
            this.tail = a;
            len = length > this.arraySize ? this.arraySize : length;
            System.arraycopy(a, offset, ((Array)a).array, 0, len);
            ((Array)a).size = len;
            this.size += (long)len;
            offset += len;
        } while ((length -= len) > 0);
    }

    @Override
    public int size() {
        return (int)this.size;
    }

    public long longsize() {
        return this.size;
    }

    @Override
    public boolean retainAll(Collection<?> c) {
        boolean changed = false;
        ListIterator<T> it = this.listIterator();
        while (it.hasNext()) {
            T e = it.next();
            if (c.contains(e)) continue;
            it.remove();
            changed = true;
        }
        return changed;
    }

    @Override
    public ListIterator<T> listIterator(int index) {
        return new LIterator(index);
    }

    @Override
    public ListIterator<T> listIterator() {
        return this.listIterator(0);
    }

    @Override
    public Iterator<T> iterator() {
        return this.listIterator();
    }

    @Override
    public <T2> T2[] toArray(T2[] a) {
        if (a.length < this.size()) {
            a = (Object[])java.lang.reflect.Array.newInstance(a.getClass().getComponentType(), this.size());
        }
        int i = 0;
        Array array = this.head;
        while (array != null) {
            System.arraycopy(array.array, 0, a, i, array.size);
            i += array.size;
            array = array.next;
        }
        return a;
    }

    @Override
    public Object[] toArray() {
        Object[] a = new Object[this.size()];
        int i = 0;
        Array array = this.head;
        while (array != null) {
            System.arraycopy(array.array, 0, a, i, array.size);
            i += array.size;
            array = array.next;
        }
        return a;
    }

    @Override
    public int lastIndexOf(Object o) {
        int i = this.size();
        Array a = this.tail;
        while (a != null) {
            int index = a.lastIndexOf(o);
            if (index >= 0) {
                return i - a.size + index;
            }
            i -= a.size;
            a = a.previous;
        }
        return -1;
    }

    @Override
    public T set(int index, T element) {
        if (this.head == null) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        if (index < 0) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Array a = this.head;
        int i = 0;
        while (i + a.size <= index && a.next != null) {
            i += a.size;
            a = a.next;
        }
        if ((i = index - i) >= a.size) {
            throw new IndexOutOfBoundsException(Integer.toString(index));
        }
        Object old = a.array[i];
        ((Array)a).array[i] = element;
        return (T)old;
    }

    @Override
    public List<T> subList(int fromIndex, int toIndex) {
        ArrayList<T> result = new ArrayList<T>(toIndex - fromIndex);
        for (int i = fromIndex; i < toIndex; ++i) {
            result.add(this.get(i));
        }
        return result;
    }

    private class LIterator
    implements ListIterator<T> {
        private Array<T> ptrNext;
        private int posNext;
        private int nextIndex;

        LIterator(int index) {
            this.ptrNext = LinkedArrayList.this.head;
            this.posNext = 0;
            this.nextIndex = 0;
            while (this.nextIndex < index && this.ptrNext != null) {
                if (index - this.nextIndex < this.ptrNext.size) {
                    this.posNext = index - this.nextIndex;
                    break;
                }
                this.nextIndex += this.ptrNext.size;
                this.ptrNext = this.ptrNext.next;
            }
        }

        @Override
        public boolean hasNext() {
            if (LinkedArrayList.this.head == null || this.ptrNext == null) {
                return false;
            }
            return this.ptrNext != LinkedArrayList.this.tail || this.posNext < this.ptrNext.size;
        }

        @Override
        public boolean hasPrevious() {
            if (LinkedArrayList.this.head == null) {
                return false;
            }
            if (this.ptrNext == null) {
                return true;
            }
            return this.ptrNext != LinkedArrayList.this.head || this.posNext > 0;
        }

        @Override
        public T next() {
            if (this.ptrNext == null || this.posNext == this.ptrNext.size) {
                throw new NoSuchElementException();
            }
            Object e = this.ptrNext.array[this.posNext++];
            while (this.posNext >= this.ptrNext.size) {
                this.ptrNext = this.ptrNext.next;
                if (this.ptrNext == null) break;
                this.posNext = 0;
            }
            ++this.nextIndex;
            return e;
        }

        @Override
        public int nextIndex() {
            return this.nextIndex;
        }

        @Override
        public T previous() {
            Object e;
            if (this.ptrNext == null) {
                this.ptrNext = LinkedArrayList.this.tail;
                this.posNext = this.ptrNext.size;
            }
            if (this.posNext > 0) {
                e = this.ptrNext.array[--this.posNext];
            } else {
                this.ptrNext = this.ptrNext.previous;
                this.posNext = this.ptrNext.size - 1;
                e = this.ptrNext.array[this.posNext];
            }
            --this.nextIndex;
            return e;
        }

        @Override
        public int previousIndex() {
            return this.nextIndex - 1;
        }

        @Override
        public void add(T o) {
            LinkedArrayList.this.add(this.nextIndex, o);
            ++this.posNext;
            while (this.posNext >= this.ptrNext.size) {
                this.ptrNext = this.ptrNext.next;
                if (this.ptrNext == null) break;
                this.posNext = 0;
            }
            ++this.nextIndex;
        }

        @Override
        public void remove() {
            LinkedArrayList.this.remove(--this.nextIndex);
            if (this.posNext > 0) {
                --this.posNext;
            }
        }

        @Override
        public void set(T o) {
            if (this.posNext > 0) {
                ((Array)this.ptrNext).array[this.posNext - 1] = o;
            } else {
                ((Array)((Array)this.ptrNext).previous).array[((LinkedArrayList)LinkedArrayList.this).arraySize - 1] = o;
            }
        }
    }

    private static class Array<T> {
        private T[] array;
        private int size = 0;
        private Array<T> previous;
        private Array<T> next;

        public Array(int size, Array<T> previous, Array<T> next) {
            this.array = new Object[size];
            this.previous = previous;
            this.next = next;
            if (previous != null) {
                previous.next = this;
            }
            if (next != null) {
                next.previous = this;
            }
        }

        private void add(T o) {
            this.array[this.size++] = o;
        }

        private int indexOf(Object o) {
            if (o == null) {
                for (int i = 0; i < this.size; ++i) {
                    if (this.array[i] != null) continue;
                    return i;
                }
                return -1;
            }
            for (int i = 0; i < this.size; ++i) {
                if (!o.equals(this.array[i])) continue;
                return i;
            }
            return -1;
        }

        private int lastIndexOf(Object o) {
            if (o == null) {
                for (int i = this.size - 1; i >= 0; --i) {
                    if (this.array[i] != null) continue;
                    return i;
                }
                return -1;
            }
            for (int i = this.size - 1; i >= 0; --i) {
                if (!o.equals(this.array[i])) continue;
                return i;
            }
            return -1;
        }

        static /* synthetic */ Object[] access$002(Array x0, Object[] x1) {
            x0.array = x1;
            return x1;
        }
    }
}

