/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.LinkedList;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.util.Pair;

public interface CollectionListener<T> {
    default public void elementsReady(Collection<? extends T> elements) {
        this.elementsAdded(elements);
    }

    public void elementsAdded(Collection<? extends T> var1);

    public void elementsRemoved(Collection<? extends T> var1);

    public void elementsChanged(Collection<? extends T> var1);

    public void error(Throwable var1);

    public static class Keep<T>
    implements CollectionListener<T> {
        protected Collection<T> col;
        protected byte priority;
        protected Throwable error = null;
        protected LinkedList<Pair<CollectionListener<T>, Task<Void, NoException>>> listeners = new LinkedList();

        public Keep(Collection<T> implementation, byte listenersCallPriority) {
            this.col = implementation;
            this.priority = listenersCallPriority;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elementsReady(Collection<? extends T> elements) {
            ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>> list;
            Object object = this.col;
            synchronized (object) {
                this.col.clear();
                this.col.addAll(elements);
                list = new ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>>(this.listeners);
            }
            object = list.iterator();
            while (object.hasNext()) {
                Pair l;
                Pair pair = l = (Pair)object.next();
                synchronized (pair) {
                    Task.Cpu.FromRunnable task = new Task.Cpu.FromRunnable("Call CollectionListener.elementsReady", this.priority, () -> ((CollectionListener)l.getValue1()).elementsReady(elements));
                    task.startOnDone((Task)l.getValue2());
                    l.setValue2(task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elementsAdded(Collection<? extends T> elements) {
            ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>> list;
            Object object = this.col;
            synchronized (object) {
                this.col.addAll(elements);
                list = new ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>>(this.listeners);
            }
            object = list.iterator();
            while (object.hasNext()) {
                Pair l;
                Pair pair = l = (Pair)object.next();
                synchronized (pair) {
                    Task.Cpu.FromRunnable task = new Task.Cpu.FromRunnable("Call CollectionListener.elementsAdded", this.priority, () -> ((CollectionListener)l.getValue1()).elementsAdded(elements));
                    task.startOnDone((Task)l.getValue2());
                    l.setValue2(task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elementsRemoved(Collection<? extends T> elements) {
            ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>> list;
            Object object = this.col;
            synchronized (object) {
                this.col.removeAll(elements);
                list = new ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>>(this.listeners);
            }
            object = list.iterator();
            while (object.hasNext()) {
                Pair l;
                Pair pair = l = (Pair)object.next();
                synchronized (pair) {
                    Task.Cpu.FromRunnable task = new Task.Cpu.FromRunnable("Call CollectionListener.elementsRemoved", this.priority, () -> ((CollectionListener)l.getValue1()).elementsRemoved(elements));
                    task.startOnDone((Task)l.getValue2());
                    l.setValue2(task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void elementsChanged(Collection<? extends T> elements) {
            ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>> list;
            Object object = this.col;
            synchronized (object) {
                list = new ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>>(this.listeners);
            }
            object = list.iterator();
            while (object.hasNext()) {
                Pair l;
                Pair pair = l = (Pair)object.next();
                synchronized (pair) {
                    Task.Cpu.FromRunnable task = new Task.Cpu.FromRunnable("Call CollectionListener.elementsChanged", this.priority, () -> ((CollectionListener)l.getValue1()).elementsChanged(elements));
                    task.startOnDone((Task)l.getValue2());
                    l.setValue2(task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void error(Throwable error) {
            ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>> list;
            Object object = this.col;
            synchronized (object) {
                this.error = error;
                list = new ArrayList<Pair<CollectionListener<T>, Task<Void, NoException>>>(this.listeners);
            }
            object = list.iterator();
            while (object.hasNext()) {
                Pair l;
                Pair pair = l = (Pair)object.next();
                synchronized (pair) {
                    Task.Cpu.FromRunnable task = new Task.Cpu.FromRunnable("Call CollectionListener.error", this.priority, () -> ((CollectionListener)l.getValue1()).error(error));
                    task.startOnDone((Task)l.getValue2());
                    l.setValue2(task);
                }
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void addListener(CollectionListener<T> listener) {
            Collection<T> collection = this.col;
            synchronized (collection) {
                if (this.error != null) {
                    listener.error(this.error);
                } else {
                    listener.elementsReady(this.col);
                }
                this.listeners.add(new Pair<CollectionListener<T>, Object>(listener, null));
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void removeListener(CollectionListener<T> listener) {
            Collection<T> collection = this.col;
            synchronized (collection) {
                Iterator it = this.listeners.iterator();
                while (it.hasNext()) {
                    if (((Pair)it.next()).getValue1() != listener) continue;
                    it.remove();
                    break;
                }
            }
        }
    }
}

