/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.collections;

import java.util.ArrayList;
import java.util.Collection;
import java.util.Iterator;
import java.util.List;
import net.lecousin.framework.collections.LinkedArrayList;
import net.lecousin.framework.event.Listener;

public interface AsyncCollection<T> {
    public void newElements(Collection<T> var1);

    public void done();

    public boolean isDone();

    public void error(Exception var1);

    public boolean hasError();

    public static class Keep<T>
    implements AsyncCollection<T> {
        private LinkedArrayList<T> list = new LinkedArrayList(10);
        private boolean done = false;
        private Exception error = null;
        private ArrayList<AsyncCollection<T>> listeners = new ArrayList(5);
        private ArrayList<Runnable> doneListeners = new ArrayList(2);
        private ArrayList<Listener<Exception>> errorListeners = new ArrayList(2);

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void newElements(Collection<T> elements) {
            ArrayList<AsyncCollection<T>> toCall;
            Keep keep = this;
            synchronized (keep) {
                this.list.addAll(elements);
                toCall = new ArrayList<AsyncCollection<T>>(this.listeners);
            }
            for (AsyncCollection asyncCollection : toCall) {
                asyncCollection.newElements(elements);
            }
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void done() {
            Iterator<Runnable> iterator = this;
            synchronized (iterator) {
                this.done = true;
            }
            for (AsyncCollection asyncCollection : this.listeners) {
                asyncCollection.done();
            }
            this.listeners = null;
            for (Runnable runnable : this.doneListeners) {
                runnable.run();
            }
            this.doneListeners = null;
        }

        @Override
        public boolean isDone() {
            return this.done;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void ondone(Runnable listener) {
            Keep keep = this;
            synchronized (keep) {
                if (!this.done) {
                    this.doneListeners.add(listener);
                    return;
                }
            }
            listener.run();
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        @Override
        public void error(Exception error) {
            Iterator<Listener<Exception>> iterator = this;
            synchronized (iterator) {
                this.error = error;
            }
            for (AsyncCollection asyncCollection : this.listeners) {
                asyncCollection.error(error);
            }
            this.listeners = null;
            for (Listener<Exception> listener : this.errorListeners) {
                listener.fire(error);
            }
            this.errorListeners = null;
        }

        @Override
        public boolean hasError() {
            return this.error != null;
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void onerror(Listener<Exception> listener) {
            Keep keep = this;
            synchronized (keep) {
                if (this.error == null) {
                    this.errorListeners.add(listener);
                    return;
                }
            }
            listener.fire(this.error);
        }

        /*
         * WARNING - Removed try catching itself - possible behaviour change.
         */
        public void provideTo(AsyncCollection<T> col) {
            ArrayList<T> already = null;
            Keep keep = this;
            synchronized (keep) {
                if (!this.done && this.error == null) {
                    already = new ArrayList<T>(this.list);
                    this.listeners.add(col);
                }
            }
            if (already != null) {
                col.newElements(this.list);
                return;
            }
            col.newElements(this.list);
            if (this.error == null) {
                col.done();
            } else {
                col.error(this.error);
            }
        }

        public List<T> getCurrentElements() {
            return this.list;
        }
    }

    public static interface OneByOne<T> {
        public void newElement(T var1);

        public void done();

        public void error(Exception var1);

        public static interface Refreshable<T>
        extends OneByOne<T> {
            public void start();
        }
    }

    public static class Aggregator<T>
    implements AsyncCollection<T> {
        private int remainingDone;
        private AsyncCollection<T> collection;

        public Aggregator(int nbSubCollection, AsyncCollection<T> mainCollection) {
            this.remainingDone = nbSubCollection;
            this.collection = mainCollection;
        }

        @Override
        public synchronized void newElements(Collection<T> elements) {
            this.collection.newElements(elements);
        }

        @Override
        public synchronized void done() {
            if (--this.remainingDone == 0 && !this.collection.hasError()) {
                this.collection.done();
            }
        }

        @Override
        public boolean isDone() {
            return this.remainingDone == 0 && !this.collection.hasError();
        }

        @Override
        public void error(Exception error) {
            this.collection.error(error);
        }

        @Override
        public boolean hasError() {
            return this.collection.hasError();
        }
    }

    public static class Listen<T>
    implements AsyncCollection<T> {
        private Listener<Collection<T>> onElementsReady;
        private Runnable onDone;
        private boolean isDone = false;
        private Listener<Exception> onError;
        private boolean hasError = false;

        public Listen(Listener<Collection<T>> onElementsReady, Runnable onDone, Listener<Exception> onError) {
            this.onElementsReady = onElementsReady;
            this.onDone = onDone;
            this.onError = onError;
        }

        @Override
        public void newElements(Collection<T> elements) {
            this.onElementsReady.fire(elements);
        }

        @Override
        public void done() {
            this.isDone = true;
            this.onDone.run();
        }

        @Override
        public boolean isDone() {
            return this.isDone;
        }

        @Override
        public void error(Exception error) {
            if (this.onError != null) {
                this.onError.fire(error);
            }
            this.hasError = true;
        }

        @Override
        public boolean hasError() {
            return this.hasError;
        }
    }
}

