/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.classpath;

import java.io.IOException;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.text.BufferedReadableCharacterStream;
import net.lecousin.framework.io.text.FullReadLines;
import net.lecousin.framework.plugins.CustomExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoint;
import net.lecousin.framework.plugins.ExtensionPoints;
import net.lecousin.framework.util.UnprotectedStringBuffer;

public class LoadLibraryExtensionPointsFile
extends FullReadLines<Void> {
    private ClassLoader classLoader;

    public <T extends ClassLoader> LoadLibraryExtensionPointsFile(BufferedReadableCharacterStream stream, T classLoader) {
        super("Initializing extension points: " + stream.getDescription(), stream, (byte)2, IO.OperationType.ASYNCHRONOUS);
        this.classLoader = classLoader;
    }

    @Override
    protected void processLine(UnprotectedStringBuffer line) throws IOException {
        block4: {
            try {
                Class<?> cl = Class.forName(line.asString(), true, this.classLoader);
                if (ExtensionPoint.class.isAssignableFrom(cl)) {
                    ExtensionPoint ext = (ExtensionPoint)cl.newInstance();
                    ExtensionPoints.add(ext);
                    ((ApplicationClassLoader)((Object)this.classLoader)).getApplication().getDefaultLogger().info("Extension point: " + cl.getName());
                    break block4;
                }
                if (CustomExtensionPoint.class.isAssignableFrom(cl)) {
                    CustomExtensionPoint ext = (CustomExtensionPoint)cl.newInstance();
                    ExtensionPoints.add(ext);
                    break block4;
                }
                throw new Exception("Invalid extension point class: " + line + " must extend ExtensionPoint or CustomExtensionPoint");
            }
            catch (Exception e) {
                throw new IOException(e);
            }
        }
    }

    @Override
    protected Void generateResult() {
        return null;
    }
}

