/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.classloader;

import java.io.File;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URL;
import java.net.URLConnection;
import java.net.URLStreamHandler;
import java.util.List;
import java.util.zip.ZipEntry;
import java.util.zip.ZipFile;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.application.libraries.classloader.AbstractClassLoader;
import net.lecousin.framework.application.libraries.classloader.AppClassLoader;
import net.lecousin.framework.application.libraries.classpath.DefaultLibrariesManager;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.Threading;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.io.FileIO;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.IOFromInputStream;
import net.lecousin.framework.io.IOUtil;
import net.lecousin.framework.io.provider.FileIOProvider;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.memory.IMemoryManageable;
import net.lecousin.framework.memory.MemoryManager;
import net.lecousin.framework.util.Filter;

public class ZipClassLoader
extends AbstractClassLoader
implements IMemoryManageable {
    private IOProvider.Readable zipProvider;
    private ZipFile zip = null;
    private long lastAccess = 0L;

    public ZipClassLoader(AppClassLoader appClassLoader, IOProvider.Readable provider) {
        super(appClassLoader);
        this.zipProvider = provider;
        MemoryManager.register(this);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private synchronized ZipFile getZip() throws IOException {
        block9: {
            this.lastAccess = System.currentTimeMillis();
            if (this.zip != null) {
                return this.zip;
            }
            if (this.zipProvider instanceof FileIOProvider) {
                this.zip = new ZipFile(((FileIOProvider)this.zipProvider).getFile());
                return this.zip;
            }
            IO.Readable io = null;
            try {
                IO i = io = this.zipProvider.provideIOReadable((byte)1);
                do {
                    if (!(i instanceof FileIO)) continue;
                    this.zip = new ZipFile(((FileIO)i).getFile());
                    break;
                } while ((i = i.getWrappedIO()) != null);
                if (i != null) break block9;
                try {
                    File temp = IOUtil.toTempFile(io).blockResult(0L);
                    this.zip = new ZipFile(temp);
                }
                catch (CancelException e) {
                    throw IO.error(e);
                }
            }
            finally {
                if (io != null) {
                    io.closeAsync();
                }
            }
        }
        return this.zip;
    }

    @Override
    public String getDescription() {
        return "ZipClassLoader: " + this.zipProvider.getDescription() + " (" + (this.zip == null ? "unloaded" : "loaded") + ")";
    }

    @Override
    public List<String> getItemsDescription() {
        return null;
    }

    public String toString() {
        return this.getDescription();
    }

    @Override
    public synchronized void freeMemory(IMemoryManageable.FreeMemoryLevel level) {
        long max;
        if (this.zip == null) {
            return;
        }
        switch (level) {
            default: {
                max = 1800000L;
                break;
            }
            case LOW: {
                max = 900000L;
                break;
            }
            case MEDIUM: {
                max = 300000L;
                break;
            }
            case URGENT: {
                max = 0L;
            }
        }
        long now = System.currentTimeMillis();
        if (now - this.lastAccess < max) {
            return;
        }
        try {
            this.zip.close();
        }
        catch (IOException iOException) {
            // empty catch block
        }
        this.zip = null;
    }

    @Override
    protected byte[] loadFile(String name) throws IOException {
        ZipFile zip = this.getZip();
        ZipEntry entry = zip.getEntry(name);
        if (entry == null) {
            throw new FileNotFoundException(name + " in zip file " + this.zipProvider.getDescription());
        }
        try (InputStream in = zip.getInputStream(entry);){
            int nb;
            int size = (int)entry.getSize();
            byte[] buffer = new byte[size];
            int pos = 0;
            while ((nb = in.read(buffer, pos, size - pos)) > 0 && (pos += nb) < size) {
            }
            if (pos < size) {
                throw new IOException("File truncated: " + entry.getName());
            }
            byte[] byArray = buffer;
            return byArray;
        }
    }

    @Override
    public IO.Readable loadResourceAsIO(String name, byte priority) throws IOException {
        ZipFile zip = this.getZip();
        ZipEntry entry = zip.getEntry(name);
        if (entry == null) {
            throw new FileNotFoundException(name + " in zip file " + this.zipProvider.getDescription());
        }
        return new IOFromInputStream.KnownSize(zip.getInputStream(entry), entry.getSize(), this.zipProvider.getDescription() + "/" + name, Threading.getUnmanagedTaskManager(), priority);
    }

    @Override
    protected Object getResourcePointer(String path) {
        ZipFile zip;
        try {
            zip = this.getZip();
        }
        catch (IOException e) {
            return null;
        }
        ZipEntry entry = zip.getEntry(path);
        if (entry == null) {
            return null;
        }
        if (entry.isDirectory()) {
            return null;
        }
        return entry;
    }

    @Override
    protected IO.Readable openResourcePointer(Object pointer, byte priority) throws IOException {
        ZipFile zip = this.getZip();
        ZipEntry entry = (ZipEntry)pointer;
        return new IOFromInputStream.KnownSize(zip.getInputStream(entry), entry.getSize(), this.zipProvider.getDescription() + "/" + entry.getName(), Threading.getUnmanagedTaskManager(), priority);
    }

    @Override
    protected URL loadResourceURL(String name) {
        try {
            ZipFile zip = this.getZip();
            ZipEntry entry = zip.getEntry(name);
            if (entry == null) {
                return null;
            }
            try {
                return new URL((URL)null, "classpath://lc/" + name, new ZipURLStreamHandler());
            }
            catch (MalformedURLException e) {
                return null;
            }
        }
        catch (IOException e) {
            return null;
        }
    }

    @Override
    protected void scan(String rootPackage, boolean includeSubPackages, Filter<String> packageFilter, Filter<String> classFilter, Listener<Class<?>> classScanner) {
        try {
            DefaultLibrariesManager.scanJarLibrary((ApplicationClassLoader)this, this.getZip(), rootPackage, includeSubPackages, packageFilter, classFilter, classScanner);
        }
        catch (Throwable throwable) {
            // empty catch block
        }
    }

    static {
        ClassLoader.registerAsParallelCapable();
    }

    private class ZipURLConnection
    extends URLConnection {
        ZipURLConnection(URL u) {
            super(u);
        }

        @Override
        public void connect() {
        }

        @Override
        public int getContentLength() {
            try {
                ZipFile zip = ZipClassLoader.this.getZip();
                ZipEntry entry = zip.getEntry(this.url.getPath().substring(1));
                return (int)entry.getSize();
            }
            catch (IOException e) {
                return 0;
            }
        }

        @Override
        public InputStream getInputStream() throws IOException {
            ZipFile zip = ZipClassLoader.this.getZip();
            ZipEntry entry = zip.getEntry(this.url.getPath().substring(1));
            return zip.getInputStream(entry);
        }
    }

    private class ZipURLStreamHandler
    extends URLStreamHandler {
        private ZipURLStreamHandler() {
        }

        @Override
        protected URLConnection openConnection(URL u) {
            return new ZipURLConnection(u);
        }
    }
}

