/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.classloader;

import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationClassLoader;
import net.lecousin.framework.application.libraries.classloader.AppClassLoader;
import net.lecousin.framework.collections.CompoundCollection;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.JoinPoint;
import net.lecousin.framework.event.Listener;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFrom;
import net.lecousin.framework.util.Filter;
import net.lecousin.framework.util.Pair;

public abstract class AbstractClassLoader
extends ClassLoader
implements ApplicationClassLoader,
IOProviderFrom.Readable<String> {
    protected AppClassLoader appClassLoader;
    private List<AbstractClassLoader> subLoaders = null;
    private static HashMap<String, Pair<Thread, JoinPoint<NoException>>> classLoadingSP;

    public AbstractClassLoader(AppClassLoader appClassLoader) {
        this.appClassLoader = appClassLoader;
    }

    @Override
    public Application getApplication() {
        return this.appClassLoader.getApplication();
    }

    public abstract String getDescription();

    protected abstract byte[] loadFile(String var1) throws IOException;

    protected abstract IO.Readable loadResourceAsIO(String var1, byte var2) throws IOException;

    protected abstract URL loadResourceURL(String var1);

    protected abstract Object getResourcePointer(String var1);

    protected abstract IO.Readable openResourcePointer(Object var1, byte var2) throws IOException;

    protected abstract void scan(String var1, boolean var2, Filter<String> var3, Filter<String> var4, Listener<Class<?>> var5);

    public final void addSubLoader(AbstractClassLoader loader) {
        if (this.subLoaders == null) {
            this.subLoaders = new ArrayList<AbstractClassLoader>();
        }
        this.subLoaders.add(loader);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static ISynchronizationPoint<NoException> getClassLoadingSP(String name) {
        HashMap<String, Pair<Thread, JoinPoint<NoException>>> hashMap = classLoadingSP;
        synchronized (hashMap) {
            Pair<Thread, JoinPoint<NoException>> p = classLoadingSP.get(name);
            if (p == null) {
                JoinPoint jp = new JoinPoint();
                jp.addToJoin(1);
                jp.start();
                classLoadingSP.put(name, new Pair(Thread.currentThread(), jp));
                return null;
            }
            if (p.getValue1() == Thread.currentThread()) {
                p.getValue2().addToJoin(1);
                return null;
            }
            return p.getValue2();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void releaseClassLoadingSP(String name) {
        HashMap<String, Pair<Thread, JoinPoint<NoException>>> hashMap = classLoadingSP;
        synchronized (hashMap) {
            Pair<Thread, JoinPoint<NoException>> sp = classLoadingSP.get(name);
            JoinPoint<NoException> jp = sp.getValue2();
            jp.joined();
            if (jp.isUnblocked()) {
                classLoadingSP.remove(name);
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    protected final Class<?> loadClass(String name, boolean resolve) throws ClassNotFoundException {
        ISynchronizationPoint<NoException> sp = AbstractClassLoader.getClassLoadingSP(name);
        while (sp != null) {
            sp.blockPause(15000L);
            sp = AbstractClassLoader.getClassLoadingSP(name);
        }
        try {
            Class<?> c = this.isLoaded(name);
            if (c == null) {
                c = this.appClassLoader.loadClassFrom(name, this);
            }
            if (resolve) {
                this.resolveClass(c);
            }
            Class<?> clazz = c;
            return clazz;
        }
        finally {
            AbstractClassLoader.releaseClassLoadingSP(name);
        }
    }

    final Class<?> isLoaded(String name) {
        Class<?> c = this.findLoadedClass(name);
        if (c != null) {
            return c;
        }
        if (this.subLoaders == null) {
            return null;
        }
        for (AbstractClassLoader sub : this.subLoaders) {
            c = sub.isLoaded(name);
            if (c == null) continue;
            return c;
        }
        return null;
    }

    final Class<?> loadClassInLibrary(String name) throws IOException {
        ISynchronizationPoint<NoException> sp = AbstractClassLoader.getClassLoadingSP(name);
        while (sp != null) {
            sp.blockPause(15000L);
            sp = AbstractClassLoader.getClassLoadingSP(name);
        }
        try {
            Class<?> c = this.findLoadedClass(name);
            if (c != null) {
                Class<?> clazz = c;
                return clazz;
            }
            byte[] file = this.loadFile(name.replace('.', '/') + ".class");
            Class<?> clazz = this.defineClass(name, file, 0, file.length);
            return clazz;
        }
        finally {
            AbstractClassLoader.releaseClassLoadingSP(name);
        }
    }

    @Override
    public final IOProvider.Readable get(final String path) {
        Object pointer = this.getResourcePointer(path);
        AbstractClassLoader cl = this;
        if (pointer == null) {
            if (this.subLoaders != null) {
                for (AbstractClassLoader sub : this.subLoaders) {
                    pointer = sub.getResourcePointer(path);
                    if (pointer == null) continue;
                    cl = sub;
                    break;
                }
            }
            if (pointer == null) {
                return null;
            }
        }
        final Object ptr = pointer;
        final AbstractClassLoader owner = cl;
        return new IOProvider.Readable(){

            @Override
            public IO.Readable provideIOReadable(byte priority) throws IOException {
                return owner.openResourcePointer(ptr, priority);
            }

            @Override
            public String getDescription() {
                return path;
            }
        };
    }

    public final IO.Readable open(String path, byte priority) throws IOException {
        Object pointer = this.getResourcePointer(path);
        AbstractClassLoader cl = this;
        if (pointer == null) {
            if (this.subLoaders != null) {
                for (AbstractClassLoader sub : this.subLoaders) {
                    pointer = sub.getResourcePointer(path);
                    if (pointer == null) continue;
                    cl = sub;
                    break;
                }
            }
            if (pointer == null) {
                throw new FileNotFoundException(path);
            }
        }
        return cl.openResourcePointer(pointer, priority);
    }

    public final URL getResourceURL(String name) {
        URL url;
        block1: {
            AbstractClassLoader sub;
            url = this.loadResourceURL(name);
            if (url != null || this.subLoaders == null) break block1;
            Iterator<AbstractClassLoader> iterator = this.subLoaders.iterator();
            while (iterator.hasNext() && (url = (sub = iterator.next()).getResourceURL(name)) == null) {
            }
        }
        return url;
    }

    public final Iterable<URL> getResourcesURL(String name) {
        URL url = this.loadResourceURL(name);
        if (this.subLoaders == null) {
            return url != null ? Collections.singletonList(url) : null;
        }
        CompoundCollection<URL> list = new CompoundCollection<URL>();
        if (url != null) {
            list.addSingleton(url);
        }
        for (AbstractClassLoader sub : this.subLoaders) {
            Iterable<URL> urls = sub.getResourcesURL(name);
            if (urls == null) continue;
            list.add(urls);
        }
        return list;
    }

    @Override
    public URL getResource(String name) {
        return this.appClassLoader.getResourceFrom(name, this);
    }

    @Override
    public Enumeration<URL> getResources(String name) throws IOException {
        return this.appClassLoader.getResources(name);
    }

    @Override
    public InputStream getResourceAsStream(String name) {
        return this.appClassLoader.getResourceAsStreamFrom(name, this);
    }

    @Override
    public IOProvider.Readable getIOProvider(String filename) {
        return this.appClassLoader.getIOProviderFrom(filename, this);
    }

    static {
        ClassLoader.registerAsParallelCapable();
        classLoadingSP = new HashMap();
    }
}

