/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.artifacts.maven;

import java.io.File;
import java.net.URL;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenPOM;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenPOMLoader;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenRepository;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.exception.NoException;
import net.lecousin.framework.io.IO;
import net.lecousin.framework.io.buffering.SimpleBufferedReadable;
import net.lecousin.framework.io.provider.IOProvider;
import net.lecousin.framework.io.provider.IOProviderFromURL;
import net.lecousin.framework.log.Logger;
import net.lecousin.framework.xml.XMLStreamEvents;
import net.lecousin.framework.xml.XMLStreamReader;

public class MavenRemoteRepository
implements MavenRepository {
    private String url;
    private boolean releasesEnabled;
    private boolean snapshotsEnabled;
    private Logger logger;

    public MavenRemoteRepository(String url, boolean releasesEnabled, boolean snapshotsEnabled) {
        if (!url.endsWith("/")) {
            url = url + "/";
        }
        this.url = url;
        this.releasesEnabled = releasesEnabled;
        this.snapshotsEnabled = snapshotsEnabled;
        this.logger = LCCore.getApplication().getLoggerFactory().getLogger(MavenRemoteRepository.class);
    }

    @Override
    public boolean isReleasesEnabled() {
        return this.releasesEnabled;
    }

    @Override
    public boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    @Override
    public boolean isSame(String url, boolean releasesEnabled, boolean snapshotsEnabled) {
        if (releasesEnabled != this.releasesEnabled) {
            return false;
        }
        if (snapshotsEnabled != this.snapshotsEnabled) {
            return false;
        }
        return url.equals(this.url);
    }

    @Override
    public AsyncWork<List<String>, NoException> getAvailableVersions(String groupId, String artifactId, byte priority) {
        IO.Readable io;
        String path = groupId.replace('.', '/') + '/' + artifactId + "/maven-metadata.xml";
        if (this.logger.info()) {
            this.logger.info("Downloading " + this.url + path);
        }
        try {
            IOProvider p = IOProviderFromURL.getInstance().get(new URL(this.url + path));
            if (p == null || !(p instanceof IOProvider.Readable)) {
                return new AsyncWork<Object, Object>(null, null);
            }
            io = ((IOProvider.Readable)p).provideIOReadable(priority);
        }
        catch (Exception e) {
            if (this.logger.error()) {
                this.logger.error("Unable to get IOProvider for " + this.url + path, e);
            }
            return new AsyncWork<Object, Object>(null, null);
        }
        IO.Readable.Buffered bio = io instanceof IO.Readable.Buffered ? (IO.Readable.Buffered)io : new SimpleBufferedReadable(io, 8192);
        AsyncWork<XMLStreamReader, Exception> start = XMLStreamReader.start(bio, 5000);
        AsyncWork<List<String>, NoException> result = new AsyncWork<List<String>, NoException>();
        start.listenAsync(new Task.Cpu.FromRunnable("Read maven-metadata.xml", priority, () -> {
            if (!start.isSuccessful()) {
                if (this.logger.error()) {
                    this.logger.error("Error loading " + this.url + path, (Throwable)start.getError());
                }
                result.unblockSuccess(null);
                return;
            }
            try {
                XMLStreamReader xml = (XMLStreamReader)start.getResult();
                while (!XMLStreamEvents.Event.Type.START_ELEMENT.equals((Object)xml.event.type)) {
                    xml.next();
                }
                if (!xml.goInto(xml.event.context.getFirst(), "versioning", "versions")) {
                    if (this.logger.error()) {
                        this.logger.error(this.url + path + " does not contain element versioning/versions");
                    }
                    result.unblockSuccess(null);
                    return;
                }
                XMLStreamEvents.ElementContext parent = xml.event.context.getFirst();
                LinkedList<String> versions = new LinkedList<String>();
                while (xml.nextInnerElement(parent, "version")) {
                    versions.add(xml.readInnerText().asString());
                }
                result.unblockSuccess(versions);
            }
            catch (Exception e) {
                if (this.logger.error()) {
                    this.logger.error("Error parsing " + this.url + path, e);
                }
                result.unblockSuccess(null);
            }
        }), true);
        result.listenInline(() -> io.closeAsync());
        return result;
    }

    @Override
    public AsyncWork<MavenPOM, Exception> load(String groupId, String artifactId, String version, MavenPOMLoader pomLoader, byte priority) {
        String path = groupId.replace('.', '/') + '/' + artifactId + '/' + version + '/' + artifactId + '-' + version + ".pom";
        if (this.logger.info()) {
            this.logger.info("Downloading " + this.url + path);
        }
        try {
            return pomLoader.loadPOM(new URL(this.url + path), true, priority);
        }
        catch (Exception e) {
            return new AsyncWork<Object, Exception>(null, e);
        }
    }

    @Override
    public File loadFileSync(String groupId, String artifactId, String version, String classifier, String type) {
        return null;
    }

    @Override
    public AsyncWork<File, Exception> loadFile(String groupId, String artifactId, String version, String classifier, String type, byte priority) {
        return new AsyncWork<Object, Object>(null, null);
    }

    public String toString() {
        return "remote maven repository (" + this.url + ")";
    }
}

