/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.libraries.artifacts.maven;

import java.io.File;
import java.net.MalformedURLException;
import java.net.URI;
import java.util.LinkedList;
import java.util.List;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenPOM;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenPOMLoader;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenRepository;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.AsyncWork;
import net.lecousin.framework.exception.NoException;

public class MavenLocalRepository
implements MavenRepository {
    private File dir;
    private boolean releasesEnabled;
    private boolean snapshotsEnabled;

    public MavenLocalRepository(File dir, boolean releasesEnabled, boolean snapshotsEnabled) {
        this.dir = dir;
        this.releasesEnabled = releasesEnabled;
        this.snapshotsEnabled = snapshotsEnabled;
    }

    @Override
    public AsyncWork<List<String>, NoException> getAvailableVersions(final String groupId, final String artifactId, byte priority) {
        Task.OnFile<List<String>, NoException> task = new Task.OnFile<List<String>, NoException>(this.dir, "Search artifact versions in local Maven repository", priority){

            @Override
            public List<String> run() {
                File d = new File(MavenLocalRepository.this.dir, groupId.replace('.', '/'));
                if (!d.exists()) {
                    return null;
                }
                if (!(d = new File(d, artifactId)).exists()) {
                    return null;
                }
                File[] files = d.listFiles();
                if (files == null) {
                    return null;
                }
                LinkedList<String> versions = new LinkedList<String>();
                for (File f : files) {
                    File p;
                    if (!f.isDirectory() || !(p = new File(f, artifactId + '-' + f.getName() + ".pom")).exists()) continue;
                    versions.add(f.getName());
                }
                return versions;
            }
        };
        task.start();
        return task.getOutput();
    }

    @Override
    public AsyncWork<MavenPOM, Exception> load(final String groupId, final String artifactId, final String version, final MavenPOMLoader pomLoader, final byte priority) {
        if (version.toLowerCase().endsWith("-SNAPSHOT") ? !this.snapshotsEnabled : !this.releasesEnabled) {
            return new AsyncWork<Object, Object>(null, null);
        }
        final AsyncWork<MavenPOM, Exception> result = new AsyncWork<MavenPOM, Exception>();
        Task.OnFile<Void, NoException> task = new Task.OnFile<Void, NoException>(this.dir, "Search Maven POM in local repository", priority){

            @Override
            public Void run() {
                File d = new File(MavenLocalRepository.this.dir, groupId.replace('.', '/'));
                if (!d.exists()) {
                    result.unblockSuccess(null);
                    return null;
                }
                if (!(d = new File(d, artifactId)).exists()) {
                    result.unblockSuccess(null);
                    return null;
                }
                if (!(d = new File(d, version)).exists()) {
                    result.unblockSuccess(null);
                    return null;
                }
                File pom = new File(d, artifactId + '-' + version + ".pom");
                if (!pom.exists()) {
                    result.unblockSuccess(null);
                    return null;
                }
                try {
                    pomLoader.loadPOM(pom.toURI().toURL(), true, priority).listenInline(result);
                }
                catch (MalformedURLException e) {
                    result.unblockSuccess(null);
                }
                return null;
            }
        };
        task.start();
        return result;
    }

    @Override
    public File loadFileSync(String groupId, String artifactId, String version, String classifier, String type) {
        File d = new File(this.dir, groupId.replace('.', '/'));
        if (!d.exists()) {
            return null;
        }
        if (!(d = new File(d, artifactId)).exists()) {
            return null;
        }
        if (!(d = new File(d, version)).exists()) {
            return null;
        }
        StringBuilder name = new StringBuilder(100);
        name.append(artifactId).append('-').append(version);
        if (classifier != null && !classifier.isEmpty()) {
            name.append('-').append(classifier);
        }
        if (type != null) {
            name.append('.').append(type);
        } else {
            name.append(".jar");
        }
        File file = new File(d, name.toString());
        if (!file.exists()) {
            return null;
        }
        return file;
    }

    @Override
    public AsyncWork<File, Exception> loadFile(final String groupId, final String artifactId, final String version, final String classifier, final String type, byte priority) {
        return new Task.OnFile<File, Exception>(this.dir, "Search file in Maven repository", priority){

            @Override
            public File run() {
                return MavenLocalRepository.this.loadFileSync(groupId, artifactId, version, classifier, type);
            }
        }.start().getOutput();
    }

    @Override
    public boolean isReleasesEnabled() {
        return this.releasesEnabled;
    }

    @Override
    public boolean isSnapshotsEnabled() {
        return this.snapshotsEnabled;
    }

    @Override
    public boolean isSame(String url, boolean releasesEnabled, boolean snapshotsEnabled) {
        if (releasesEnabled != this.releasesEnabled) {
            return false;
        }
        if (snapshotsEnabled != this.snapshotsEnabled) {
            return false;
        }
        try {
            URI uri = new URI(url);
            if (!"file".equals(uri.getScheme())) {
                return false;
            }
            if (!new File(uri).equals(this.dir)) {
                return false;
            }
        }
        catch (Exception e) {
            return false;
        }
        return true;
    }

    public String toString() {
        return "local maven repository (" + this.dir.getAbsolutePath() + ")";
    }
}

