/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application.launcher;

import java.awt.GraphicsEnvironment;
import java.io.File;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.concurrent.Executors;
import net.lecousin.framework.application.Application;
import net.lecousin.framework.application.ApplicationConfiguration;
import net.lecousin.framework.application.Artifact;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.application.SplashScreen;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.launcher.DynamicLibrariesManager;
import net.lecousin.framework.application.libraries.artifacts.LibrariesRepository;
import net.lecousin.framework.application.libraries.artifacts.LibraryDescriptorLoader;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenLocalRepository;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenPOMLoader;
import net.lecousin.framework.application.libraries.artifacts.maven.MavenRepository;
import net.lecousin.framework.concurrent.Task;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.util.Triple;

public class AppLauncher {
    public static void main(final String[] args) {
        SplashScreen splashScreen = null;
        if (!GraphicsEnvironment.isHeadless() && !"true".equals(System.getProperty("nosplash"))) {
            splashScreen = new SplashScreen(true);
        }
        final SplashScreen splash = splashScreen;
        LCCore.keepMainThread(new Runnable(){

            @Override
            public void run() {
                ISynchronizationPoint appClosed;
                ApplicationConfiguration cfg;
                LibrariesRepository repo;
                Object repo2;
                MavenPOMLoader pomLoader = new MavenPOMLoader();
                ArrayList<LibraryDescriptorLoader> loaders = new ArrayList<LibraryDescriptorLoader>(1);
                loaders.add(pomLoader);
                LinkedList<Object> repositories = new LinkedList<Object>();
                String groupId = null;
                String artifactId = null;
                String version = null;
                String plugins = null;
                String[] appParameters = new String[]{};
                for (int i = 0; i < args.length; ++i) {
                    if (args[i].startsWith("-groupId=")) {
                        groupId = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("-artifactId=")) {
                        artifactId = args[i].substring(12);
                        continue;
                    }
                    if (args[i].startsWith("-version=")) {
                        version = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("-plugins=")) {
                        plugins = args[i].substring(9);
                        continue;
                    }
                    if (args[i].startsWith("-maven-repository=")) {
                        String path = args[i].substring(18);
                        File dir = new File(path);
                        if (!dir.exists()) continue;
                        repo2 = new MavenLocalRepository(dir, true, true);
                        repositories.add(repo2);
                        pomLoader.addRepository((MavenRepository)repo2);
                        continue;
                    }
                    if (args[i].equals("-parameters")) {
                        appParameters = new String[args.length - i - 1];
                        for (int j = 0; j < appParameters.length; ++j) {
                            appParameters[j] = args[i + 1 + j];
                        }
                        break;
                    }
                    System.err.println("Unknown option: " + args[i]);
                    AppLauncher.printUsage();
                    LCCore.stop(true);
                    return;
                }
                boolean stop = true;
                if (groupId == null) {
                    System.err.println("Missing groupId parameter in command line");
                } else if (artifactId == null) {
                    System.err.println("Missing artifactId parameter in command line");
                } else if (version == null) {
                    System.err.println("Missing version parameter in command line");
                } else {
                    stop = false;
                }
                if (stop) {
                    LCCore.stop(true);
                    return;
                }
                File dir = new File(System.getProperty("user.home") + "/.m2/repository");
                if (dir.exists()) {
                    MavenLocalRepository repo3 = new MavenLocalRepository(dir, true, true);
                    pomLoader.addRepository(repo3);
                    repositories.add(repo3);
                }
                File cfgFile = null;
                repo2 = repositories.iterator();
                while (repo2.hasNext() && (cfgFile = (repo = (LibrariesRepository)repo2.next()).loadFileSync(groupId, artifactId, version, "lc-project", "xml")) == null) {
                }
                if (cfgFile == null) {
                    System.err.println("Configuration file does not exist");
                    LCCore.stop(true);
                    return;
                }
                if (splash != null) {
                    splash.setText("Reading application configuration");
                }
                try {
                    cfg = ApplicationConfiguration.load(cfgFile);
                }
                catch (Exception e) {
                    System.err.println("Error reading configuration file " + cfgFile.getAbsolutePath());
                    e.printStackTrace(System.err);
                    LCCore.stop(true);
                    return;
                }
                if (splash != null && cfg.name != null) {
                    splash.setApplicationName(cfg.name);
                }
                File appDir = cfgFile.getParentFile();
                if (splash != null) {
                    splash.endInit();
                }
                if (cfg.properties.get("net.lecousin.application.config.directory") == null && System.getProperty("net.lecousin.application.config.directory") == null) {
                    cfg.properties.put("net.lecousin.application.config.directory", System.getProperty("user.home") + "/.lc.apps/" + groupId + "/" + artifactId + "/cfg");
                }
                if (cfg.properties.get("net.lecousin.application.log.directory") == null && System.getProperty("net.lecousin.application.log.directory") == null) {
                    cfg.properties.put("net.lecousin.application.log.directory", System.getProperty("user.home") + "/.lc.apps/" + groupId + "/" + artifactId + "/log");
                }
                LinkedList<Triple<String, String, String>> addPlugins = new LinkedList<Triple<String, String, String>>();
                if (plugins != null) {
                    String[] list;
                    for (String plugin : list = plugins.split(";")) {
                        if ((plugin = plugin.trim()).length() == 0) continue;
                        int i = plugin.indexOf(58);
                        if (i < 0) {
                            addPlugins.add(new Triple<String, Object, Object>(plugin, null, null));
                            continue;
                        }
                        String pluginGroupId = plugin.substring(0, i);
                        if ((i = (plugin = plugin.substring(i + 1)).indexOf(58)) < 0) {
                            addPlugins.add(new Triple<String, String, Object>(pluginGroupId, plugin, null));
                            continue;
                        }
                        addPlugins.add(new Triple<String, String, String>(pluginGroupId, plugin.substring(0, i), plugin.substring(i + 1)));
                    }
                }
                DynamicLibrariesManager librariesManager = new DynamicLibrariesManager(null, splash, loaders, appDir, cfg, addPlugins);
                ISynchronizationPoint<Exception> start = Application.start(new Artifact(groupId, artifactId, new Version(version)), appParameters, cfg.properties, false, Executors.defaultThreadFactory(), librariesManager);
                start.block(0L);
                if (start.hasError()) {
                    start.getError().printStackTrace(System.err);
                    LCCore.stop(true);
                    return;
                }
                if (start.isCancelled()) {
                    start.getCancelEvent().printStackTrace(System.err);
                    LCCore.stop(true);
                    return;
                }
                Task.Cpu<ISynchronizationPoint<Exception>, Exception> startApp = librariesManager.startApp();
                startApp.getOutput().block(0L);
                if (!startApp.isSuccessful()) {
                    if (startApp.isCancelled()) {
                        System.err.println("Application cancelled:");
                        startApp.getCancelEvent().printStackTrace(System.err);
                    } else {
                        System.err.println("Error while starting application:");
                        ((Throwable)startApp.getError()).printStackTrace(System.err);
                    }
                    LCCore.stop(true);
                }
                if ((appClosed = (ISynchronizationPoint)startApp.getResult()) != null) {
                    appClosed.block(0L);
                    if (appClosed.isCancelled()) {
                        System.err.println("Application cancelled:");
                        appClosed.getCancelEvent().printStackTrace(System.err);
                    } else if (appClosed.hasError()) {
                        System.err.println("Error while running application:");
                        ((Throwable)appClosed.getError()).printStackTrace(System.err);
                    }
                }
                LCCore.stop(true);
            }
        });
    }

    public static void printUsage() {
        System.out.println("Usage: -groupId=<groupId> -artifactId=<artifactId> -version=<artifactVersion> [-maven-repository=<path>] [-parameters <application parameters>]");
    }
}

