/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import java.util.Comparator;
import net.lecousin.framework.application.Version;
import net.lecousin.framework.application.VersionRange;

public interface VersionSpecification
extends Comparator<Version> {
    public boolean isMatching(Version var1);

    public static class RangeWithRecommended
    implements VersionSpecification {
        private VersionRange range;
        Version recommended;

        public RangeWithRecommended(VersionRange range, Version recommended) {
            this.range = range;
            this.recommended = recommended;
        }

        public Version getRecommended() {
            return this.recommended;
        }

        public VersionRange getRange() {
            return this.range;
        }

        @Override
        public boolean isMatching(Version version) {
            return this.range.includes(version);
        }

        @Override
        public int compare(Version o1, Version o2) {
            if (o1.compareTo(this.recommended) == 0) {
                return 1;
            }
            if (o2.compareTo(this.recommended) == 0) {
                return -1;
            }
            return o1.compareTo(o2);
        }

        public String toString() {
            return this.recommended.toString() + " (or " + this.range.toString() + ")";
        }
    }

    public static class Range
    implements VersionSpecification {
        private VersionRange range;

        public Range(VersionRange range) {
            this.range = range;
        }

        public VersionRange getRange() {
            return this.range;
        }

        @Override
        public boolean isMatching(Version version) {
            return this.range.includes(version);
        }

        @Override
        public int compare(Version o1, Version o2) {
            return o1.compareTo(o2);
        }

        public String toString() {
            return this.range.toString();
        }
    }

    public static class SingleVersion
    implements VersionSpecification {
        private Version version;

        public SingleVersion(Version version) {
            this.version = version;
        }

        public Version getVersion() {
            return this.version;
        }

        @Override
        public boolean isMatching(Version version) {
            return version.compareTo(this.version) == 0;
        }

        @Override
        public int compare(Version o1, Version o2) {
            return 0;
        }

        public String toString() {
            return this.version.toString();
        }
    }
}

