/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import java.util.ArrayList;
import net.lecousin.framework.application.Version;

public class VersionRange {
    private int[] min;
    private int[] max;
    private boolean maxIncluded;

    public VersionRange(Version unique) {
        this.min = unique.getNumbers();
        this.max = this.min;
        this.maxIncluded = true;
    }

    public VersionRange(Version min, Version max, boolean maxIncluded) {
        this.min = min != null ? min.getNumbers() : null;
        this.max = max != null ? max.getNumbers() : null;
        this.maxIncluded = maxIncluded;
    }

    public boolean includes(Version version) {
        return this.includes(version.getNumbers());
    }

    public boolean includes(int[] v) {
        if (this.min != null && Version.compare(v, this.min) < 0) {
            return false;
        }
        if (this.max == null) {
            return true;
        }
        int c = Version.compare(v, this.max);
        if (c > 0) {
            return false;
        }
        if (c < 0) {
            return true;
        }
        return this.maxIncluded;
    }

    public String toString() {
        StringBuilder s = new StringBuilder();
        if (this.min == this.max) {
            Version.toString(this.min, s);
        } else {
            s.append('[');
            Version.toString(this.min, s);
            if (this.max != null) {
                s.append('-');
                Version.toString(this.max, s);
                s.append(this.maxIncluded ? (char)']' : '[');
            }
        }
        return s.toString();
    }

    public static int[] parse(String s) {
        int i;
        ArrayList<Integer> n = new ArrayList<Integer>();
        int val = 0;
        boolean hasChar = false;
        for (i = 0; i < s.length(); ++i) {
            char c = s.charAt(i);
            if (c >= '0' && c <= '9') {
                val = val * 10 + (c - 48);
                hasChar = true;
                continue;
            }
            if (c == '.') {
                n.add(val);
                val = 0;
                hasChar = false;
                continue;
            }
            if (!hasChar) break;
            n.add(val);
            break;
        }
        if (i == s.length()) {
            n.add(val);
        }
        int[] numbers = new int[n.size()];
        for (i = 0; i < n.size(); ++i) {
            numbers[i] = (Integer)n.get(i);
        }
        return numbers;
    }
}

