/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import java.awt.Color;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.Font;
import java.awt.GridBagConstraints;
import java.awt.GridBagLayout;
import java.awt.Toolkit;
import java.io.IOException;
import java.io.InputStream;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JProgressBar;
import javax.swing.JWindow;
import javax.swing.RepaintManager;
import javax.swing.border.LineBorder;
import net.lecousin.framework.application.LCCore;
import net.lecousin.framework.concurrent.CancelException;
import net.lecousin.framework.concurrent.synch.ISynchronizationPoint;
import net.lecousin.framework.concurrent.synch.SynchronizationPoint;
import net.lecousin.framework.event.AsyncEvent;
import net.lecousin.framework.progress.WorkProgress;

public class SplashScreen
extends Thread
implements WorkProgress {
    private boolean devMode;
    JWindow win;
    private JPanel logoContainer;
    private JPanel titleContainer;
    private JPanel bottom;
    private JLabel progressText;
    private JLabel progressSubText;
    private JProgressBar progressBar;
    private ImageIcon poweredBy = null;
    private boolean ready = false;
    private JLabel logo = null;
    private JLabel title = null;
    private boolean isCustomLogo = false;
    private String text = "";
    private String subText = "";
    private long amount = 10000L;
    private long worked = 0L;
    private SynchronizationPoint<Exception> synch = new SynchronizationPoint();
    private AsyncEvent event = null;
    private boolean eventInterrupted;

    public SplashScreen(boolean devMode) {
        super("Splash Screen");
        this.devMode = devMode;
        this.start();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void close() {
        JWindow w;
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            if (!this.synch.isUnblocked()) {
                this.synch.unblock();
            }
            if (this.win == null) {
                return;
            }
            w = this.win;
            this.win = null;
        }
        if (this.event != null) {
            this.event.fire();
        }
        w.setVisible(false);
        w.removeAll();
        w.dispose();
        RepaintManager.setCurrentManager(null);
        this.logoContainer = null;
        this.titleContainer = null;
        this.bottom = null;
        this.progressText = null;
        this.progressSubText = null;
        this.progressBar = null;
        this.poweredBy = null;
        this.logo = null;
        this.title = null;
        this.text = null;
        this.subText = null;
        this.event = null;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void run() {
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            this.win = new JWindow();
            this.win.setAlwaysOnTop(true);
            this.win.getRootPane().setBorder(new LineBorder(Color.BLACK));
            this.win.getRootPane().getContentPane().setLayout(new BoxLayout(this.win.getRootPane().getContentPane(), 1));
            this.logoContainer = new JPanel();
            this.win.getRootPane().getContentPane().add(this.logoContainer);
            FlowLayout fl = new FlowLayout();
            fl.setVgap(0);
            fl.setHgap(0);
            this.logoContainer.setLayout(fl);
            this.titleContainer = new JPanel();
            this.win.getRootPane().getContentPane().add(this.titleContainer);
            fl = new FlowLayout();
            fl.setVgap(0);
            fl.setHgap(0);
            this.titleContainer.setLayout(fl);
            this.bottom = new JPanel();
            this.win.getRootPane().getContentPane().add(this.bottom);
            this.bottom.setMinimumSize(new Dimension(400, 40));
            this.bottom.setPreferredSize(new Dimension(400, 40));
            this.bottom.setMaximumSize(new Dimension(400, 40));
            GridBagLayout gb = new GridBagLayout();
            gb.columnWeights = new double[]{1.0, 0.0};
            gb.rowWeights = new double[]{1.0, 0.0};
            this.bottom.setLayout(gb);
            this.bottom.setBackground(Color.WHITE);
            this.progressText = new JLabel("");
            this.progressText.setFont(new Font("Arial", 0, 10));
            GridBagConstraints grid = new GridBagConstraints();
            grid.gridx = 0;
            grid.gridy = 0;
            grid.anchor = 14;
            grid.fill = 2;
            this.bottom.add((Component)this.progressText, grid);
            this.progressSubText = new JLabel("Loading lecousin.net framework");
            this.progressSubText.setFont(new Font("Arial", 0, 10));
            grid = new GridBagConstraints();
            grid.gridx = 0;
            grid.gridy = 1;
            grid.anchor = 14;
            grid.fill = 2;
            this.bottom.add((Component)this.progressSubText, grid);
            this.progressBar = new JProgressBar();
            grid = new GridBagConstraints();
            grid.gridx = 0;
            grid.gridy = 2;
            grid.anchor = 14;
            grid.fill = 2;
            this.bottom.add((Component)this.progressBar, grid);
        }
        if (this.logoContainer.getComponentCount() == 0 || this.isCustomLogo) {
            this.loadPoweredBy();
        }
        splashScreen = this;
        synchronized (splashScreen) {
            this.ready = true;
            this.notifyAll();
        }
        this.update();
        if (this.devMode) {
            for (int i = 0; i < 20; ++i) {
                try {
                    Thread.sleep(1000L);
                }
                catch (InterruptedException e) {
                    break;
                }
                if (this.win == null || LCCore.get() != null && LCCore.get().isStopping()) break;
            }
            this.close();
        }
    }

    public boolean isReady() {
        return this.ready;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void loadPoweredBy() {
        int pos = 0;
        int size = 4363;
        byte[] buffer = new byte[size];
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("net/lecousin/framework/core/logo_110x40.png");){
            int nb;
            do {
                if ((nb = in.read(buffer, pos, size - pos)) > 0) continue;
                break;
            } while ((pos += nb) < size);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pos == size) {
            SplashScreen splashScreen = this;
            synchronized (splashScreen) {
                if (this.win != null) {
                    this.poweredBy = new ImageIcon(buffer);
                }
            }
        }
    }

    private void update() {
        if (!this.ready) {
            return;
        }
        if (this.win == null) {
            return;
        }
        if (this.logo != null && this.logoContainer.getComponentCount() == 0) {
            this.logoContainer.setBackground(Color.WHITE);
            this.logo.setBackground(Color.WHITE);
            this.logoContainer.add(this.logo);
        }
        if (this.logo != null && this.isCustomLogo && this.bottom.getComponentCount() == 2) {
            JPanel panel = new JPanel();
            FlowLayout layout = new FlowLayout();
            layout.setVgap(0);
            layout.setVgap(0);
            panel.setLayout(layout);
            panel.setBackground(Color.WHITE);
            GridBagConstraints grid = new GridBagConstraints();
            grid.gridx = 1;
            grid.gridy = 0;
            grid.gridheight = 3;
            panel.setMinimumSize(new Dimension(110, 40));
            panel.setMaximumSize(new Dimension(110, 40));
            panel.setPreferredSize(new Dimension(110, 40));
            JLabel label = new JLabel(this.poweredBy);
            panel.add(label);
            this.bottom.add((Component)panel, grid);
        }
        if (this.title != null) {
            if (this.isCustomLogo) {
                if (this.titleContainer.getComponentCount() != 0) {
                    this.titleContainer.removeAll();
                }
            } else {
                if (this.titleContainer.getComponentCount() == 0) {
                    this.titleContainer.add(this.title);
                }
                FlowLayout layout = new FlowLayout();
                layout.setVgap(0);
                layout.setVgap(0);
                this.titleContainer.setLayout(layout);
                this.titleContainer.setBackground(Color.WHITE);
                this.title.setForeground(new Color(0, 0, 96));
                this.title.setFont(new Font("Arial", 1, 12));
            }
        }
        int width = 400;
        int height = 0;
        if (this.logoContainer.getComponentCount() > 0) {
            height += this.logo.getPreferredSize().height;
        }
        if (this.titleContainer.getComponentCount() > 0) {
            height += this.titleContainer.getPreferredSize().height;
        }
        height += 40;
        this.win.setSize(width, height += 2);
        if (!this.win.isVisible()) {
            this.win.setVisible(true);
        }
        Dimension screen = Toolkit.getDefaultToolkit().getScreenSize();
        this.win.setLocation(screen.width / 2 - width / 2, screen.height / 2 - height / 2);
    }

    public synchronized void setLogo(ImageIcon logo, boolean isCustom) {
        if (this.win == null) {
            return;
        }
        this.logo = new JLabel(logo);
        Dimension dim = new Dimension(logo.getIconWidth(), logo.getIconHeight());
        if (dim.width > 400) {
            dim.width = 400;
        }
        if (dim.height > 300) {
            dim.height = 300;
        }
        this.logo.setMaximumSize(dim);
        this.logo.setMinimumSize(dim);
        this.logo.setPreferredSize(dim);
        this.isCustomLogo = isCustom;
        this.update();
    }

    public void loadDefaultLogo() {
        int pos = 0;
        int size = 18296;
        byte[] buffer = new byte[size];
        try (InputStream in = this.getClass().getClassLoader().getResourceAsStream("net/lecousin/framework/core/logo_200x200.png");){
            int nb;
            do {
                if ((nb = in.read(buffer, pos, size - pos)) > 0) continue;
                break;
            } while ((pos += nb) < size);
        }
        catch (IOException iOException) {
            // empty catch block
        }
        if (pos == size) {
            this.setLogo(new ImageIcon(buffer), false);
        }
    }

    public synchronized void setApplicationName(String name) {
        if (this.win == null) {
            return;
        }
        this.title = new JLabel("Starting " + name + "...");
        this.update();
    }

    public synchronized void endInit() {
        if (this.win == null) {
            return;
        }
        this.progressText.setText("Starting framework...");
        this.progressBar.setMinimum(0);
        this.progressBar.setMaximum(10050);
        this.progressBar.setValue(50);
        this.bottom.invalidate();
    }

    @Override
    public synchronized void setAmount(long work) {
        if (this.win == null) {
            return;
        }
        this.amount = work;
        this.updateProgress();
    }

    @Override
    public long getAmount() {
        return this.amount;
    }

    @Override
    public synchronized void setPosition(long position) {
        if (this.win == null) {
            return;
        }
        this.worked = position;
        this.updateProgress();
    }

    @Override
    public long getPosition() {
        return this.worked;
    }

    @Override
    public long getRemainingWork() {
        return this.amount - this.worked;
    }

    @Override
    public synchronized void progress(long amountDone) {
        if (this.win == null) {
            return;
        }
        this.worked += amountDone;
        this.updateProgress();
    }

    @Override
    public synchronized void setText(String text) {
        if (this.win == null) {
            return;
        }
        this.text = text;
        this.updateProgress();
    }

    @Override
    public String getText() {
        return this.text;
    }

    @Override
    public synchronized void setSubText(String text) {
        if (this.win == null) {
            return;
        }
        this.subText = text;
        this.updateProgress();
    }

    @Override
    public String getSubText() {
        return this.subText;
    }

    @Override
    public void done() {
        this.close();
    }

    @Override
    public void error(Exception error) {
        this.synch.error(error);
    }

    @Override
    public void cancel(CancelException reason) {
        this.synch.cancel(reason);
    }

    @Override
    public ISynchronizationPoint<Exception> getSynch() {
        return this.synch;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void listen(Runnable onchange) {
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            if (this.event == null) {
                this.event = new AsyncEvent();
            }
            this.event.addListener(onchange);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public void unlisten(Runnable onchange) {
        SplashScreen splashScreen = this;
        synchronized (splashScreen) {
            if (this.event == null) {
                return;
            }
            this.event.removeListener(onchange);
        }
    }

    @Override
    public void interruptEvents() {
        this.eventInterrupted = true;
    }

    @Override
    public void resumeEvents(boolean trigger) {
        this.eventInterrupted = false;
        if (trigger) {
            this.updateProgress();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void updateProgress() {
        if (this.subText.length() == 0) {
            this.progressText.setText("");
            this.progressSubText.setText(this.text);
        } else {
            this.progressText.setText(this.text);
            this.progressSubText.setText(this.subText);
        }
        this.progressBar.setValue((int)(50L + 10000L * this.worked / this.amount));
        this.bottom.invalidate();
        if (!this.eventInterrupted) {
            SplashScreen splashScreen = this;
            synchronized (splashScreen) {
                if (this.event != null) {
                    this.event.fire();
                }
            }
        }
    }
}

