/*
 * Decompiled with CFR 0.152.
 */
package net.lecousin.framework.application;

import java.io.File;
import java.io.FileInputStream;
import java.io.InputStream;
import java.util.HashMap;
import java.util.Map;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamReader;

public class ApplicationConfiguration {
    public String splash;
    public String name;
    public String clazz;
    public Map<String, String> properties = new HashMap<String, String>();

    public static ApplicationConfiguration load(File file) throws Exception {
        try (FileInputStream in = new FileInputStream(file);){
            ApplicationConfiguration applicationConfiguration = ApplicationConfiguration.load(in);
            return applicationConfiguration;
        }
    }

    public static ApplicationConfiguration load(InputStream input) throws Exception {
        XMLStreamReader xml = XMLInputFactory.newFactory().createXMLStreamReader(input);
        while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() != 1) continue;
            if (!"project".equals(xml.getLocalName())) {
                throw new Exception("Root element of an lc-project.xml file must be <project>");
            }
            ApplicationConfiguration cfg = new ApplicationConfiguration();
            boolean found = false;
            while (xml.hasNext()) {
                xml.next();
                if (xml.getEventType() != 1 || !"application".equals(xml.getLocalName())) continue;
                found = true;
                cfg.load(xml);
                break;
            }
            if (!found) {
                throw new Exception("No application element found in lc-project.xml file");
            }
            return cfg;
        }
        throw new Exception("Nothing found in lc-project.xml file");
    }

    private void load(XMLStreamReader xml) throws Exception {
        while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() != 1) continue;
            if ("name".equals(xml.getLocalName())) {
                this.name = xml.getElementText();
                continue;
            }
            if ("class".equals(xml.getLocalName())) {
                this.clazz = xml.getElementText();
                continue;
            }
            if ("splash".equals(xml.getLocalName())) {
                this.splash = xml.getElementText();
                continue;
            }
            if ("properties".equals(xml.getLocalName())) {
                this.loadProperties(xml);
                continue;
            }
            throw new Exception("Unknown element <" + xml.getLocalName() + "> in application");
        }
    }

    private void loadProperties(XMLStreamReader xml) throws Exception {
        while (xml.hasNext()) {
            xml.next();
            if (xml.getEventType() != 1) continue;
            String name = xml.getLocalName();
            String value = xml.getElementText();
            this.properties.put(name, value);
        }
    }
}

