/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.lapiscore;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import net.lapismc.lapiscore.LapisCorePlugin;
import net.lapismc.lapiscore.placeholder.PlaceholderAPIHook;
import net.lapismc.lapiscore.utils.LapisCoreConfigUpdater;
import org.bukkit.Bukkit;
import org.bukkit.ChatColor;
import org.bukkit.OfflinePlayer;
import org.bukkit.configuration.InvalidConfigurationException;
import org.bukkit.configuration.file.YamlConfiguration;

public class LapisCoreConfiguration {
    private final int configVersion;
    private final int messagesVersion;
    private final LapisCorePlugin core;
    private final File messagesFile;
    private YamlConfiguration messages;

    public LapisCoreConfiguration(LapisCorePlugin core, int configVersion, int messagesVersion) {
        this.core = core;
        this.configVersion = configVersion;
        this.messagesVersion = messagesVersion;
        this.messagesFile = new File(core.getDataFolder() + File.separator + "messages.yml");
        this.generateConfigs();
        this.checkConfigVersions();
    }

    public void generateConfigs() {
        this.core.saveDefaultConfig();
        if (!this.messagesFile.exists()) {
            try (InputStream is = this.core.getResource("messages.yml");
                 FileOutputStream os = new FileOutputStream(this.messagesFile);){
                int readBytes;
                byte[] buffer = new byte[4096];
                while ((readBytes = is.read(buffer)) > 0) {
                    ((OutputStream)os).write(buffer, 0, readBytes);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        this.reloadMessages();
    }

    public void reloadMessages() {
        try {
            if (this.messages == null) {
                this.messages = YamlConfiguration.loadConfiguration((File)this.messagesFile);
            } else {
                this.messages.load(this.messagesFile);
            }
        }
        catch (IOException | InvalidConfigurationException e) {
            e.printStackTrace();
        }
        this.core.primaryColor = this.colorMessage(this.messages.getString("PrimaryColor", ChatColor.GOLD.toString()));
        this.core.secondaryColor = this.colorMessage(this.messages.getString("SecondaryColor", ChatColor.RED.toString()));
    }

    private void checkConfigVersions() {
        if (this.core.getConfig().getInt("ConfigVersion") != this.configVersion) {
            new LapisCoreConfigUpdater(this.core, this.configVersion, new File(this.core.getDataFolder(), "config.yml"));
            this.core.reloadConfig();
            this.core.getLogger().info("The config has been updated to version " + this.configVersion + ", this should have happened seamlessly. You might want to check that it is still configured the way you would like and set new values");
        }
        if (this.messages.getInt("ConfigVersion") != this.messagesVersion) {
            new LapisCoreConfigUpdater(this.core, this.messagesVersion, new File(this.core.getDataFolder(), "messages.yml"));
            this.reloadMessages();
            this.core.getLogger().info("The messages yaml has been updated to version " + this.messagesVersion + ", this should have happened seamlessly. You might want to check that it is still configured the way you would like and set new values");
        }
    }

    public YamlConfiguration getMessages() {
        return this.messages;
    }

    private String getRawMessage(String key) {
        if (!this.messages.contains(key)) {
            this.reloadMessages();
        }
        return this.messages.getString(key, "&sError retrieving message from config");
    }

    public String getMessage(String key) {
        return this.colorMessage(this.getRawMessage(key));
    }

    public String getMessage(String key, OfflinePlayer op) {
        return this.colorMessage(this.replacePlaceholders(this.getRawMessage(key), op));
    }

    public String colorMessage(String msg) {
        msg = this.translateHexColorCodes(msg);
        return ChatColor.translateAlternateColorCodes((char)'&', (String)msg.replace("&p", this.core.primaryColor).replace("&s", this.core.secondaryColor));
    }

    private String translateHexColorCodes(String msg) {
        Pattern hexPattern = Pattern.compile("#([A-Fa-f0-9]{6})");
        Matcher matcher = hexPattern.matcher(msg);
        StringBuilder stringBuilder = new StringBuilder(msg.length() + 32);
        while (matcher.find()) {
            String group = matcher.group(1);
            matcher.appendReplacement(stringBuilder, "\u00a7x\u00a7" + group.charAt(0) + "\u00a7" + group.charAt(1) + "\u00a7" + group.charAt(2) + "\u00a7" + group.charAt(3) + "\u00a7" + group.charAt(4) + "\u00a7" + group.charAt(5));
        }
        return matcher.appendTail(stringBuilder).toString();
    }

    public String replacePlaceholders(String s, OfflinePlayer op) {
        if (Bukkit.getPluginManager().isPluginEnabled("PlaceholderAPI")) {
            return PlaceholderAPIHook.processPlaceholders(op, s);
        }
        return s;
    }
}

