/*
 * Decompiled with CFR 0.152.
 */
package net.lapismc.afkplus.util.prettytime.i18n;

import java.util.ListResourceBundle;
import net.lapismc.afkplus.util.prettytime.Duration;
import net.lapismc.afkplus.util.prettytime.TimeFormat;
import net.lapismc.afkplus.util.prettytime.TimeUnit;
import net.lapismc.afkplus.util.prettytime.impl.TimeFormatProvider;
import net.lapismc.afkplus.util.prettytime.units.Century;
import net.lapismc.afkplus.util.prettytime.units.Day;
import net.lapismc.afkplus.util.prettytime.units.Decade;
import net.lapismc.afkplus.util.prettytime.units.Hour;
import net.lapismc.afkplus.util.prettytime.units.JustNow;
import net.lapismc.afkplus.util.prettytime.units.Millennium;
import net.lapismc.afkplus.util.prettytime.units.Millisecond;
import net.lapismc.afkplus.util.prettytime.units.Minute;
import net.lapismc.afkplus.util.prettytime.units.Month;
import net.lapismc.afkplus.util.prettytime.units.Second;
import net.lapismc.afkplus.util.prettytime.units.Week;
import net.lapismc.afkplus.util.prettytime.units.Year;

public class Resources_ru
extends ListResourceBundle
implements TimeFormatProvider {
    private static final Object[][] OBJECTS = new Object[0][0];
    private static final int tolerance = 50;
    private static final int russianPluralForms = 3;

    @Override
    public Object[][] getContents() {
        return OBJECTS;
    }

    @Override
    public TimeFormat getFormatFor(TimeUnit t) {
        if (t instanceof JustNow) {
            return new TimeFormat(){

                @Override
                public String format(Duration duration) {
                    return this.performFormat(duration);
                }

                @Override
                public String formatUnrounded(Duration duration) {
                    return this.performFormat(duration);
                }

                private String performFormat(Duration duration) {
                    if (duration.isInFuture()) {
                        return "\u0441\u0435\u0439\u0447\u0430\u0441";
                    }
                    if (duration.isInPast()) {
                        return "\u0442\u043e\u043b\u044c\u043a\u043e \u0447\u0442\u043e";
                    }
                    return null;
                }

                @Override
                public String decorate(Duration duration, String time) {
                    return time;
                }

                @Override
                public String decorateUnrounded(Duration duration, String time) {
                    return time;
                }
            };
        }
        if (t instanceof Century) {
            return new TimeFormatAided("\u0432\u0435\u043a", "\u0432\u0435\u043a\u0430", "\u0432\u0435\u043a\u043e\u0432");
        }
        if (t instanceof Day) {
            return new TimeFormatAided("\u0434\u0435\u043d\u044c", "\u0434\u043d\u044f", "\u0434\u043d\u0435\u0439");
        }
        if (t instanceof Decade) {
            return new TimeFormatAided("\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0435\u0442\u0438\u0435", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0435\u0442\u0438\u044f", "\u0434\u0435\u0441\u044f\u0442\u0438\u043b\u0435\u0442\u0438\u0439");
        }
        if (t instanceof Hour) {
            return new TimeFormatAided("\u0447\u0430\u0441", "\u0447\u0430\u0441\u0430", "\u0447\u0430\u0441\u043e\u0432");
        }
        if (t instanceof Millennium) {
            return new TimeFormatAided("\u0442\u044b\u0441\u044f\u0447\u0435\u043b\u0435\u0442\u0438\u0435", "\u0442\u044b\u0441\u044f\u0447\u0435\u043b\u0435\u0442\u0438\u044f", "\u0442\u044b\u0441\u044f\u0447\u0435\u043b\u0435\u0442\u0438\u0439");
        }
        if (t instanceof Millisecond) {
            return new TimeFormatAided("\u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u043c\u0438\u043b\u043b\u0438\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (t instanceof Minute) {
            return new TimeFormatAided("\u043c\u0438\u043d\u0443\u0442\u0443", "\u043c\u0438\u043d\u0443\u0442\u044b", "\u043c\u0438\u043d\u0443\u0442");
        }
        if (t instanceof Month) {
            return new TimeFormatAided("\u043c\u0435\u0441\u044f\u0446", "\u043c\u0435\u0441\u044f\u0446\u0430", "\u043c\u0435\u0441\u044f\u0446\u0435\u0432");
        }
        if (t instanceof Second) {
            return new TimeFormatAided("\u0441\u0435\u043a\u0443\u043d\u0434\u0443", "\u0441\u0435\u043a\u0443\u043d\u0434\u044b", "\u0441\u0435\u043a\u0443\u043d\u0434");
        }
        if (t instanceof Week) {
            return new TimeFormatAided("\u043d\u0435\u0434\u0435\u043b\u044e", "\u043d\u0435\u0434\u0435\u043b\u0438", "\u043d\u0435\u0434\u0435\u043b\u044c");
        }
        if (t instanceof Year) {
            return new TimeFormatAided("\u0433\u043e\u0434", "\u0433\u043e\u0434\u0430", "\u043b\u0435\u0442");
        }
        return null;
    }

    private static class TimeFormatAided
    implements TimeFormat {
        private final String[] pluarls;

        public TimeFormatAided(String ... plurals) {
            if (plurals.length != 3) {
                throw new IllegalArgumentException("Wrong plural forms number for russian language!");
            }
            this.pluarls = plurals;
        }

        @Override
        public String format(Duration duration) {
            long quantity = duration.getQuantityRounded(50);
            return String.valueOf(quantity);
        }

        @Override
        public String formatUnrounded(Duration duration) {
            long quantity = Math.abs(duration.getQuantity());
            return String.valueOf(quantity);
        }

        @Override
        public String decorate(Duration duration, String time) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), duration.getQuantityRounded(50), time);
        }

        @Override
        public String decorateUnrounded(Duration duration, String time) {
            return this.performDecoration(duration.isInPast(), duration.isInFuture(), Math.abs(duration.getQuantity()), time);
        }

        private String performDecoration(boolean past, boolean future, long n, String time) {
            int pluralIdx;
            int n2 = n % 10L == 1L && n % 100L != 11L ? 0 : (pluralIdx = n % 10L >= 2L && n % 10L <= 4L && (n % 100L < 10L || n % 100L >= 20L) ? 1 : 2);
            if (pluralIdx > 3) {
                throw new IllegalStateException("Wrong plural index was calculated somehow for russian language");
            }
            StringBuilder result = new StringBuilder();
            if (future) {
                result.append("\u0447\u0435\u0440\u0435\u0437 ");
            }
            result.append(time);
            result.append(' ');
            result.append(this.pluarls[pluralIdx]);
            if (past) {
                result.append(" \u043d\u0430\u0437\u0430\u0434");
            }
            return result.toString();
        }
    }
}

