/*
 * Decompiled with CFR 0.152.
 */
package net.kyori.indra.git;

import java.util.List;
import org.eclipse.jgit.api.Git;
import org.eclipse.jgit.lib.ObjectId;
import org.eclipse.jgit.lib.Ref;
import org.gradle.api.java.archives.Manifest;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

public interface IndraGitExtension {
    public static final String MANIFEST_ATTRIBUTE_GIT_COMMIT = "Git-Commit";
    public static final String MANIFEST_ATTRIBUTE_GIT_BRANCH = "Git-Branch";

    default public boolean isPresent() {
        return this.git() != null;
    }

    @Nullable
    public Git git();

    @NotNull
    public List<Ref> tags();

    @Nullable
    public Ref headTag();

    @Nullable
    public String describe();

    @Nullable
    public String branchName();

    @Nullable
    public Ref branch();

    @Nullable
    public ObjectId commit();

    default public void applyVcsInformationToManifest(Manifest manifest) {
        if (this.isPresent()) {
            @Nullable ObjectId commit = this.commit();
            @Nullable String branchName = this.branchName();
            if (commit != null) {
                manifest.getAttributes().put((Object)MANIFEST_ATTRIBUTE_GIT_COMMIT, (Object)commit.name());
            }
            if (branchName != null) {
                manifest.getAttributes().put((Object)MANIFEST_ATTRIBUTE_GIT_BRANCH, (Object)branchName);
            }
        }
    }
}

