/*
 * Decompiled with CFR 0.152.
 */
package net.kuujo.catalyst.buffer;

import net.kuujo.catalyst.buffer.AbstractBuffer;
import net.kuujo.catalyst.buffer.Buffer;
import net.kuujo.catalyst.buffer.HeapBytes;
import net.kuujo.catalyst.buffer.util.HeapMemory;
import net.kuujo.catalyst.buffer.util.Memory;
import net.kuujo.catalyst.util.ReferenceManager;

public class HeapBuffer
extends AbstractBuffer {
    private final HeapBytes bytes;

    public static HeapBuffer allocate() {
        return HeapBuffer.allocate(4096L, 0x7FFFFFFAL);
    }

    public static HeapBuffer allocate(long initialCapacity) {
        return HeapBuffer.allocate(initialCapacity, 0x7FFFFFFAL);
    }

    public static HeapBuffer allocate(long initialCapacity, long maxCapacity) {
        if (initialCapacity > maxCapacity) {
            throw new IllegalArgumentException("initial capacity cannot be greater than maximum capacity");
        }
        if (initialCapacity > 0x7FFFFFFAL) {
            throw new IllegalArgumentException("initial capacity for HeapBuffer cannot be greater than 2147483642");
        }
        if (maxCapacity > 0x7FFFFFFAL) {
            throw new IllegalArgumentException("maximum capacity for HeapBuffer cannot be greater than 2147483642");
        }
        return new HeapBuffer(new HeapBytes(HeapMemory.allocate(Memory.Util.toPow2(initialCapacity))), 0L, initialCapacity, maxCapacity);
    }

    public static HeapBuffer wrap(byte[] bytes) {
        return new HeapBuffer(HeapBytes.wrap(bytes), 0L, bytes.length, bytes.length);
    }

    protected HeapBuffer(HeapBytes bytes, ReferenceManager<Buffer> referenceManager) {
        super(bytes, referenceManager);
        this.bytes = bytes;
    }

    protected HeapBuffer(HeapBytes bytes, long offset, long initialCapacity, long maxCapacity) {
        super(bytes, offset, initialCapacity, maxCapacity, null);
        this.bytes = bytes;
    }

    @Override
    protected void compact(long from, long to, long length) {
        this.bytes.memory.unsafe().copyMemory(this.bytes.memory.array(), this.bytes.memory.address(from), this.bytes.memory.array(), this.bytes.memory.address(to), length);
        this.bytes.memory.unsafe().setMemory(this.bytes.memory.array(), this.bytes.memory.address(from), length, (byte)0);
    }

    public byte[] array() {
        return this.bytes.memory.array();
    }

    public HeapBuffer reset(byte[] array) {
        this.bytes.memory.reset(array);
        this.clear();
        return this;
    }
}

