/*
 * Decompiled with CFR 0.152.
 */
package net.kuama.wifiSpy;

import android.content.Context;
import android.net.wifi.WifiInfo;
import android.net.wifi.WifiManager;
import android.os.Build;
import androidx.core.content.ContextCompat;
import io.reactivex.Observable;
import io.reactivex.disposables.Disposable;
import io.reactivex.functions.Action;
import io.reactivex.functions.Consumer;
import kotlin.Lazy;
import kotlin.LazyKt;
import kotlin.Metadata;
import kotlin.ResultKt;
import kotlin.TypeCastException;
import kotlin.Unit;
import kotlin.coroutines.Continuation;
import kotlin.coroutines.intrinsics.IntrinsicsKt;
import kotlin.jvm.functions.Function0;
import kotlin.jvm.functions.Function2;
import kotlin.jvm.internal.DefaultConstructorMarker;
import kotlin.jvm.internal.Intrinsics;
import kotlin.jvm.internal.PropertyReference1;
import kotlin.jvm.internal.PropertyReference1Impl;
import kotlin.jvm.internal.Reflection;
import kotlin.reflect.KDeclarationContainer;
import kotlin.reflect.KProperty;
import kotlinx.coroutines.BuildersKt;
import kotlinx.coroutines.CoroutineScope;
import kotlinx.coroutines.Deferred;
import kotlinx.coroutines.GlobalScope;
import kotlinx.coroutines.Job;
import net.kuama.wifiSpy.WiFiListener;
import net.kuama.wifiSpy.WiFiSpy;
import net.kuama.wifiSpy.data.WiFiInfo;
import net.kuama.wifiSpy.data.WiFiState;
import net.kuama.wifiSpy.data.WifiNetworkBand;
import net.kuama.wifiSpy.implementation.AndroidQ;
import net.kuama.wifiSpy.implementation.BeforeAndroidQ;
import net.kuama.wifiSpy.support.HotObservable;
import net.kuama.wifiSpy.support.SingletonHolder;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000P\n\u0002\u0018\u0002\n\u0002\u0010\u0000\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0002\n\u0002\u0018\u0002\n\u0002\u0010\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0005\n\u0002\u0018\u0002\n\u0000\n\u0002\u0010\u000b\n\u0000\n\u0002\u0010\b\n\u0000\n\u0002\u0018\u0002\n\u0000\n\u0002\u0018\u0002\n\u0002\b\u0007\n\u0002\u0018\u0002\n\u0002\b\u0003\u0018\u0000 \"2\u00020\u0001:\u0001\"B\u000f\b\u0002\u0012\u0006\u0010\u0002\u001a\u00020\u0003\u00a2\u0006\u0002\u0010\u0004J\b\u0010\u0019\u001a\u00020\u0007H\u0002J\b\u0010\u001a\u001a\u00020\u0007H\u0002J\b\u0010\u001b\u001a\u00020\u0007H\u0002J\b\u0010\u001c\u001a\u00020\u0007H\u0002J\b\u0010\u001d\u001a\u00020\u0007H\u0002J\u0010\u0010\u001e\u001a\u00020\u00072\u0006\u0010\u001f\u001a\u00020 H\u0002J\b\u0010!\u001a\u00020\u0007H\u0002R\u0016\u0010\u0005\u001a\n\u0012\u0004\u0012\u00020\u0007\u0018\u00010\u0006X\u0082\u000e\u00a2\u0006\u0002\n\u0000R!\u0010\b\u001a\b\u0012\u0004\u0012\u00020\n0\t8FX\u0086\u0084\u0002\u00a2\u0006\f\n\u0004\b\r\u0010\u000e\u001a\u0004\b\u000b\u0010\fR\u0016\u0010\u000f\u001a\n\u0012\u0004\u0012\u00020\n\u0018\u00010\u0010X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0011\u001a\u00020\u0012X\u0082\u0004\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0013\u001a\u00020\u0014X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0015\u001a\u00020\u0016X\u0082\u000e\u00a2\u0006\u0002\n\u0000R\u000e\u0010\u0017\u001a\u00020\u0018X\u0082\u000e\u00a2\u0006\u0002\n\u0000\u00a8\u0006#"}, d2={"Lnet/kuama/wifiSpy/WiFiSpy;", "", "context", "Landroid/content/Context;", "(Landroid/content/Context;)V", "async", "Lkotlinx/coroutines/Deferred;", "", "info", "Lio/reactivex/Observable;", "Lnet/kuama/wifiSpy/data/WiFiInfo;", "getInfo", "()Lio/reactivex/Observable;", "info$delegate", "Lkotlin/Lazy;", "innerInfo", "Lnet/kuama/wifiSpy/support/HotObservable;", "isFineLocationAccessGranted", "", "subscribersCount", "", "wiFiListener", "Lnet/kuama/wifiSpy/WiFiListener;", "wifiManager", "Landroid/net/wifi/WifiManager;", "checkWiFi", "listenWiFiChanges", "noop", "onCouldNotGetWiFiState", "onWiFiDisabled", "onWiFiEnabled", "connectionInfo", "Landroid/net/wifi/WifiInfo;", "stopListeningWiFiChanges", "Companion", "WiFiSpy_release"})
public final class WiFiSpy {
    static final /* synthetic */ KProperty[] $$delegatedProperties;
    private Deferred<Unit> async;
    private WiFiListener wiFiListener;
    private WifiManager wifiManager;
    private final boolean isFineLocationAccessGranted;
    private int subscribersCount;
    private HotObservable<WiFiInfo> innerInfo;
    @NotNull
    private final Lazy info$delegate;
    public static final Companion Companion;

    static {
        $$delegatedProperties = new KProperty[]{(KProperty)Reflection.property1((PropertyReference1)new PropertyReference1Impl((KDeclarationContainer)Reflection.getOrCreateKotlinClass(WiFiSpy.class), "info", "getInfo()Lio/reactivex/Observable;"))};
        Companion = new Companion(null);
    }

    @NotNull
    public final Observable<WiFiInfo> getInfo() {
        Lazy lazy = this.info$delegate;
        WiFiSpy wiFiSpy = this;
        KProperty kProperty = $$delegatedProperties[0];
        boolean bl = false;
        return (Observable)lazy.getValue();
    }

    private final void checkWiFi() {
        switch (this.wifiManager.getWifiState()) {
            case 0: 
            case 1: {
                this.onWiFiDisabled();
                break;
            }
            case 3: {
                WifiInfo wifiInfo = this.wifiManager.getConnectionInfo();
                Intrinsics.checkExpressionValueIsNotNull((Object)wifiInfo, (String)"wifiManager.connectionInfo");
                this.onWiFiEnabled(wifiInfo);
                break;
            }
            case 2: {
                this.noop();
                break;
            }
            default: {
                this.onCouldNotGetWiFiState();
            }
        }
    }

    private final void onWiFiDisabled() {
        block0: {
            HotObservable<WiFiInfo> hotObservable = this.innerInfo;
            if (hotObservable == null) break block0;
            hotObservable.setCurrent(new WiFiInfo(WiFiState.DISCONNECTED, null, null, 6, null));
        }
    }

    private final void onWiFiEnabled(WifiInfo connectionInfo) {
        block0: {
            WifiNetworkBand band = Build.VERSION.SDK_INT >= 21 ? (connectionInfo.getFrequency() > 3000 ? WifiNetworkBand.WIFI_5_GHZ : WifiNetworkBand.WIFI_2_4_GHZ) : WifiNetworkBand.UNKNOWN;
            HotObservable<WiFiInfo> hotObservable = this.innerInfo;
            if (hotObservable == null) break block0;
            hotObservable.setCurrent(new WiFiInfo(this.isFineLocationAccessGranted ? WiFiState.CONNECTED : WiFiState.CONNECTED_MISSING_FINE_LOCATION_PERMISSION, connectionInfo.getSSID(), band));
        }
    }

    private final void onCouldNotGetWiFiState() {
        block0: {
            HotObservable<WiFiInfo> hotObservable = this.innerInfo;
            if (hotObservable == null) break block0;
            hotObservable.setCurrent(new WiFiInfo(WiFiState.UNKNOWN, null, null, 6, null));
        }
    }

    private final void noop() {
    }

    private final void listenWiFiChanges() {
        this.wiFiListener.start((Function0<Unit>)((Function0)new Function0<Unit>(this){
            final /* synthetic */ WiFiSpy this$0;

            public final void invoke() {
                WiFiSpy.access$checkWiFi(this.this$0);
            }
            {
                this.this$0 = wiFiSpy;
                super(0);
            }
        }));
    }

    private final void stopListeningWiFiChanges() {
        this.wiFiListener.stop();
    }

    private WiFiSpy(Context context) {
        this.wiFiListener = Build.VERSION.SDK_INT >= 29 ? (WiFiListener)new AndroidQ(context) : (WiFiListener)new BeforeAndroidQ(context);
        Object object = context.getApplicationContext().getSystemService("wifi");
        if (object == null) {
            throw new TypeCastException("null cannot be cast to non-null type android.net.wifi.WifiManager");
        }
        this.wifiManager = (WifiManager)object;
        this.isFineLocationAccessGranted = ContextCompat.checkSelfPermission((Context)context, (String)"android.permission.ACCESS_FINE_LOCATION") == 0;
        this.info$delegate = LazyKt.lazy((Function0)((Function0)new Function0<Observable<WiFiInfo>>(this){
            final /* synthetic */ WiFiSpy this$0;

            public final Observable<WiFiInfo> invoke() {
                WiFiSpy.access$setInnerInfo$p(this.this$0, new HotObservable<WiFiInfo>(new WiFiInfo(WiFiState.UNKNOWN, null, null, 6, null)));
                HotObservable hotObservable = WiFiSpy.access$getInnerInfo$p(this.this$0);
                if (hotObservable == null) {
                    Intrinsics.throwNpe();
                }
                return hotObservable.observe().doOnSubscribe((Consumer)new Consumer<Disposable>(this){
                    final /* synthetic */ info.2 this$0;

                    public final void accept(Disposable it) {
                        if (WiFiSpy.access$getSubscribersCount$p(this.this$0.this$0) == 0) {
                            WiFiSpy.access$setAsync$p(this.this$0.this$0, BuildersKt.async$default((CoroutineScope)((CoroutineScope)GlobalScope.INSTANCE), null, null, (Function2)((Function2)new Function2<CoroutineScope, Continuation<? super Unit>, Object>(this, null){
                                private CoroutineScope p$;
                                int label;
                                final /* synthetic */ info.1 this$0;

                                @Nullable
                                public final Object invokeSuspend(@NotNull Object $result) {
                                    Object object = IntrinsicsKt.getCOROUTINE_SUSPENDED();
                                    switch (this.label) {
                                        case 0: {
                                            ResultKt.throwOnFailure((Object)$result);
                                            CoroutineScope $this$async = this.p$;
                                            WiFiSpy.access$listenWiFiChanges(this.this$0.this$0.this$0);
                                            return Unit.INSTANCE;
                                        }
                                    }
                                    throw new IllegalStateException("call to 'resume' before 'invoke' with coroutine");
                                }
                                {
                                    this.this$0 = var1_1;
                                    super(2, continuation);
                                }

                                @NotNull
                                public final Continuation<Unit> create(@Nullable Object value, @NotNull Continuation<?> completion) {
                                    Intrinsics.checkParameterIsNotNull(completion, (String)"completion");
                                    Function2<CoroutineScope, Continuation<? super Unit>, Object> function2 = new /* invalid duplicate definition of identical inner class */;
                                    CoroutineScope coroutineScope = function2.p$ = (CoroutineScope)value;
                                    return function2;
                                }

                                public final Object invoke(Object object, Object object2) {
                                    return (this.create(object, (Continuation)object2)).invokeSuspend(Unit.INSTANCE);
                                }
                            }), (int)3, null));
                        }
                        WiFiSpy wiFiSpy = this.this$0.this$0;
                        WiFiSpy.access$setSubscribersCount$p(wiFiSpy, WiFiSpy.access$getSubscribersCount$p(wiFiSpy) + 1);
                        String string = "we got " + WiFiSpy.access$getSubscribersCount$p(this.this$0.this$0) + " subscribers";
                        boolean bl = false;
                        System.out.println((Object)string);
                    }
                    {
                        this.this$0 = var1_1;
                    }
                }).doOnError((Consumer)info.2.INSTANCE).doOnDispose(new Action(this){
                    final /* synthetic */ info.2 this$0;

                    public final void run() {
                        block1: {
                            WiFiSpy wiFiSpy = this.this$0.this$0;
                            WiFiSpy.access$setSubscribersCount$p(wiFiSpy, WiFiSpy.access$getSubscribersCount$p(wiFiSpy) - 1);
                            if (WiFiSpy.access$getSubscribersCount$p(this.this$0.this$0) != 0) break block1;
                            WiFiSpy.access$stopListeningWiFiChanges(this.this$0.this$0);
                            Deferred deferred = WiFiSpy.access$getAsync$p(this.this$0.this$0);
                            if (deferred != null) {
                                Job.DefaultImpls.cancel$default((Job)deferred, null, (int)1, null);
                            }
                        }
                    }
                    {
                        this.this$0 = var1_1;
                    }
                });
            }
            {
                this.this$0 = wiFiSpy;
                super(0);
            }
        }));
    }

    public static final /* synthetic */ void access$checkWiFi(WiFiSpy $this) {
        $this.checkWiFi();
    }

    public static final /* synthetic */ HotObservable access$getInnerInfo$p(WiFiSpy $this) {
        return $this.innerInfo;
    }

    public static final /* synthetic */ void access$setInnerInfo$p(WiFiSpy $this, HotObservable hotObservable) {
        $this.innerInfo = hotObservable;
    }

    public static final /* synthetic */ int access$getSubscribersCount$p(WiFiSpy $this) {
        return $this.subscribersCount;
    }

    public static final /* synthetic */ void access$setSubscribersCount$p(WiFiSpy $this, int n) {
        $this.subscribersCount = n;
    }

    public static final /* synthetic */ Deferred access$getAsync$p(WiFiSpy $this) {
        return $this.async;
    }

    public static final /* synthetic */ void access$setAsync$p(WiFiSpy $this, Deferred deferred) {
        $this.async = deferred;
    }

    public static final /* synthetic */ void access$listenWiFiChanges(WiFiSpy $this) {
        $this.listenWiFiChanges();
    }

    public static final /* synthetic */ void access$stopListeningWiFiChanges(WiFiSpy $this) {
        $this.stopListeningWiFiChanges();
    }

    public /* synthetic */ WiFiSpy(Context context, DefaultConstructorMarker $constructor_marker) {
        this(context);
    }

    @Metadata(mv={1, 1, 15}, bv={1, 0, 3}, k=1, d1={"\u0000\u0014\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\u0018\u0002\n\u0002\b\u0002\b\u0086\u0003\u0018\u00002\u000e\u0012\u0004\u0012\u00020\u0002\u0012\u0004\u0012\u00020\u00030\u0001B\u0007\b\u0002\u00a2\u0006\u0002\u0010\u0004\u00a8\u0006\u0005"}, d2={"Lnet/kuama/wifiSpy/WiFiSpy$Companion;", "Lnet/kuama/wifiSpy/support/SingletonHolder;", "Lnet/kuama/wifiSpy/WiFiSpy;", "Landroid/content/Context;", "()V", "WiFiSpy_release"})
    public static final class Companion
    extends SingletonHolder<WiFiSpy, Context> {
        private Companion() {
            super(1.INSTANCE);
        }

        public /* synthetic */ Companion(DefaultConstructorMarker $constructor_marker) {
            this();
        }
    }
}

