/*
 * Decompiled with CFR 0.152.
 */
package net.kennychua.phantomjs_qunit_runner;

import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

public class QunitHtmlWrapperMojo
extends AbstractMojo {
    private File jsSourceDirectory;
    private File jsTestDirectory;
    private File buildDirectory;
    private FileSet includeLibsInDir;
    private static final String jQueryFileName = "jquery-1.7.1-min.js";
    private static final String domTestUtilsFileName = "DOMTestUtils.js";
    private static final String qUnitJsFileName = "qunit-git.js";
    private static final String qUnitCssFileName = "qunit-git.css";
    private static final String jsTestFileSuffix = "Test.js";
    private static final String qUnitHtmlOutputDirectoryName = "qunit-html";
    private static final String qUnitHeader = "<html><head><title>QUnit Test Suite</title><link rel=\"stylesheet\" href=\"qunit-git.css\" type=\"text/css\" media=\"screen\"><script type=\"text/javascript\" src=\"qunit-git.js\"></script><script type=\"text/javascript\" src=\"jquery-1.7.1-min.js\"></script><script type=\"text/javascript\" src=\"DOMTestUtils.js\"></script>";
    private static final String qUnitFooter = "</head><body><h1 id=\"qunit-header\">QUnit Test Suite</h1><h2 id=\"qunit-banner\"></h2><div id=\"qunit-testrunner-toolbar\"></div><h2 id=\"qunit-userAgent\"></h2><ol id=\"qunit-tests\"></ol></body></html>";
    private static String qUnitHtmlOutputPath;
    private static FileSetManager fileSetManager;

    public void execute() throws MojoExecutionException, MojoFailureException {
        qUnitHtmlOutputPath = this.buildDirectory + "/" + qUnitHtmlOutputDirectoryName;
        for (File temp : this.getJsTestFiles(this.jsTestDirectory.toString())) {
            this.generateQunitHtmlOutput(temp.getName().toString(), this.jsTestDirectory.toString());
        }
    }

    private void generateQunitHtmlOutput(String testFile, String testFileDirectory) {
        new File(qUnitHtmlOutputPath).mkdir();
        this.writeQunitHtmlFile(testFile);
        this.copyQunitResources();
        this.copyJsFiles(testFile);
        this.copyUserDefinedLibraries();
    }

    private void copyUserDefinedLibraries() {
        if (this.includeLibsInDir != null) {
            for (String libraryFileName : fileSetManager.getIncludedFiles(this.includeLibsInDir)) {
                try {
                    File libraryFile = new File(this.includeLibsInDir.getDirectory() + File.separatorChar + libraryFileName);
                    FileUtils.copyFile((File)libraryFile, (File)new File(qUnitHtmlOutputPath + File.separatorChar + libraryFile.getName()));
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
    }

    private void copyQunitResources() {
        try {
            FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(qUnitCssFileName), (File)new File(qUnitHtmlOutputPath + "/" + qUnitCssFileName));
            FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(qUnitJsFileName), (File)new File(qUnitHtmlOutputPath + "/" + qUnitJsFileName));
            FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(jQueryFileName), (File)new File(qUnitHtmlOutputPath + "/" + jQueryFileName));
            FileUtils.copyInputStreamToFile((InputStream)((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(domTestUtilsFileName), (File)new File(qUnitHtmlOutputPath + "/" + domTestUtilsFileName));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private void copyJsFiles(String jsTestFile) {
        String jsSrcFile = jsTestFile.substring(0, jsTestFile.indexOf(jsTestFileSuffix)) + ".js";
        try {
            FileUtils.copyFile((File)new File(this.jsTestDirectory + "/" + jsTestFile), (File)new File(qUnitHtmlOutputPath + "/" + jsTestFile));
            FileUtils.copyFile((File)new File(this.jsSourceDirectory + "/" + jsSrcFile), (File)new File(qUnitHtmlOutputPath + "/" + jsSrcFile));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private File[] getJsTestFiles(String dirName) {
        File dir = new File(dirName);
        return dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return filename.endsWith(QunitHtmlWrapperMojo.jsTestFileSuffix);
            }
        });
    }

    private String generateScriptTag(String fileName) {
        return "<script type=\"text/javascript\" src=\"" + fileName + "\"></script>";
    }

    private void writeQunitHtmlFile(String jsTestFile) {
        String jsSrcFile = jsTestFile.substring(0, jsTestFile.indexOf(jsTestFileSuffix)) + ".js";
        try {
            BufferedWriter output = new BufferedWriter(new FileWriter(qUnitHtmlOutputPath + "/" + jsTestFile + ".html"));
            output.write(qUnitHeader);
            output.write(this.generateScriptTag(jsSrcFile));
            output.write(this.generateScriptTag(jsTestFile));
            if (this.includeLibsInDir != null) {
                for (String libraryFileName : fileSetManager.getIncludedFiles(this.includeLibsInDir)) {
                    try {
                        output.write(this.generateScriptTag(libraryFileName));
                    }
                    catch (IOException e) {
                        this.getLog().error((Throwable)e);
                    }
                }
            }
            output.write(qUnitFooter);
            output.close();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    static {
        fileSetManager = new FileSetManager();
    }
}

