/*
 * Decompiled with CFR 0.152.
 */
package net.kennychua.phantomjs_qunit_runner;

import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileWriter;
import java.io.FilenameFilter;
import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.util.ArrayList;
import org.apache.commons.io.FileUtils;
import org.apache.maven.plugin.AbstractMojo;
import org.apache.maven.plugin.MojoExecutionException;
import org.apache.maven.plugin.MojoFailureException;
import org.apache.maven.shared.model.fileset.FileSet;
import org.apache.maven.shared.model.fileset.util.FileSetManager;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PhantomJsQunitRunnerMojo
extends AbstractMojo {
    private File jsSourceDirectory;
    private File jsTestDirectory;
    private File baseDirectory;
    private File buildDirectory;
    private boolean ignoreFailures;
    private String phantomJsExec;
    private FileSet includeLibsInDir;
    private static final String[] qunitLibraries = new String[]{"phantomjs-qunit-runner.js", "qunit-git.js"};
    private static final String[] tailLibraries = new String[]{"jquery-1.7.1-min.js", "DOMTestUtils.js"};
    private static final String jsTestFileSuffix = "Test.js";
    private static final String jUnitXmlDirectoryName = "junitxml";
    private static FileSetManager fileSetManager = new FileSetManager();

    private String createStringArrayLogString(String[] fileNames) {
        String logString = new String();
        if (fileNames != null) {
            for (String libFile : fileNames) {
                logString = logString + libFile;
                logString = logString + ", ";
            }
        }
        return logString;
    }

    public void execute() throws MojoExecutionException, MojoFailureException {
        int retCode = 0;
        this.printConfigurationToLog();
        this.copyFilesToTargetDirectory();
        for (File jsTestFile : this.getJsTestFiles(this.jsTestDirectory.getAbsolutePath())) {
            retCode += this.runQUnitInPhantomJs(jsTestFile.getName(), this.jsTestDirectory.getAbsolutePath());
        }
        if (!this.ignoreFailures && retCode > 0) {
            throw new MojoFailureException("One or more QUnit tests failed");
        }
    }

    private void copyFilesToTargetDirectory() {
        this.copyLibraries(qunitLibraries);
        this.copyLibraries(tailLibraries);
        this.copyUserDefinedLibraries();
    }

    private void printConfigurationToLog() {
        this.getLog().debug((CharSequence)("jsTestDirectory=" + String.valueOf(this.jsTestDirectory)));
        this.getLog().debug((CharSequence)("jsSourceDirectory=" + String.valueOf(this.jsSourceDirectory)));
        this.getLog().debug((CharSequence)("phantomJsExec=" + String.valueOf(this.phantomJsExec)));
        if (this.includeLibsInDir != null) {
            String[] fileNames = fileSetManager.getIncludedFiles(this.includeLibsInDir);
            this.getLog().debug((CharSequence)("includeLibsInDir=" + this.createStringArrayLogString(fileNames)));
        } else {
            this.getLog().debug((CharSequence)"includeLibsInDir=none");
        }
    }

    private int runQUnitInPhantomJs(String testFile, String testFileDirectory) {
        int exitVal = 255;
        this.getLog().debug((CharSequence)("testFile=" + testFile));
        this.getLog().debug((CharSequence)("testFileDirectory=" + testFileDirectory));
        try {
            ArrayList<String> paramsList = new ArrayList<String>();
            paramsList.addAll(this.convertPhantomJsExecToParameterList());
            paramsList.addAll(this.createFileList(this.buildDirectory.getAbsolutePath(), qunitLibraries));
            paramsList.add(testFileDirectory + "/" + testFile);
            paramsList.add(this.findFileUnderTest(testFile));
            paramsList.addAll(this.createFileList(this.buildDirectory.getAbsolutePath(), tailLibraries));
            if (this.includeLibsInDir != null) {
                paramsList.addAll(this.createFileList(this.buildDirectory.getAbsolutePath(), fileSetManager.getIncludedFiles(this.includeLibsInDir)));
            }
            this.getLog().debug((CharSequence)("params passed to process = " + paramsList.toString()));
            Process pr = new ProcessBuilder(paramsList).start();
            this.captureOutput(testFile, pr);
            exitVal = pr.waitFor();
        }
        catch (Exception e) {
            this.getLog().error((Throwable)e);
        }
        return exitVal;
    }

    private String findFileUnderTest(String testFile) {
        return this.jsSourceDirectory + "/" + testFile.substring(0, testFile.indexOf(jsTestFileSuffix)) + ".js";
    }

    private void captureOutput(String testFile, Process pr) throws IOException {
        BufferedReader input = new BufferedReader(new InputStreamReader(pr.getInputStream()));
        File jUnitXmlOutputPath = new File(this.buildDirectory + "/" + jUnitXmlDirectoryName);
        jUnitXmlOutputPath.mkdir();
        File resultsFile = new File(jUnitXmlOutputPath, testFile + ".xml");
        BufferedWriter output = new BufferedWriter(new FileWriter(resultsFile));
        String line = null;
        while ((line = input.readLine()) != null) {
            output.write(line);
        }
        output.close();
    }

    private ArrayList<String> convertPhantomJsExecToParameterList() {
        ArrayList<String> phantomJsParams = new ArrayList<String>();
        for (String arg : this.phantomJsExec.split(" ")) {
            phantomJsParams.add(arg);
        }
        return phantomJsParams;
    }

    private ArrayList<String> createFileList(String directory, String[] filenames) {
        ArrayList<String> prefixedFiles = new ArrayList<String>();
        for (String filename : filenames) {
            prefixedFiles.add(directory + "/" + filename);
        }
        return prefixedFiles;
    }

    private void copyUserDefinedLibraries() {
        if (this.includeLibsInDir != null) {
            for (String libraryFileName : fileSetManager.getIncludedFiles(this.includeLibsInDir)) {
                try {
                    File libraryFile = new File(this.includeLibsInDir.getDirectory() + File.separatorChar + libraryFileName);
                    FileUtils.copyFile((File)libraryFile, (File)new File(this.buildDirectory + "/" + libraryFile.getName()));
                }
                catch (IOException e) {
                    this.getLog().error((Throwable)e);
                }
            }
        }
    }

    private void copyLibraries(String[] filenames) {
        for (String filename : filenames) {
            this.copyResourceToDirectory(filename, this.buildDirectory);
        }
    }

    private void copyResourceToDirectory(String filename, File buildDirectory) {
        try {
            FileUtils.copyInputStreamToFile((InputStream)this.getFileAsStream(filename), (File)new File(buildDirectory + "/" + filename));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    private InputStream getFileAsStream(String filename) {
        return ((Object)((Object)this)).getClass().getClassLoader().getResourceAsStream(filename);
    }

    private File[] getJsTestFiles(String dirName) {
        File dir = new File(dirName);
        return dir.listFiles(new FilenameFilter(){

            public boolean accept(File dir, String filename) {
                return filename.endsWith(PhantomJsQunitRunnerMojo.jsTestFileSuffix);
            }
        });
    }
}

