/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.samples.wikidata.parser;

import java.time.ZoneId;
import java.util.Objects;
import net.kafujo.samples.wikidata.parser.WikidataParser;

public class TimeZoneParser
extends WikidataParser<ZoneId> {
    public static final TimeZoneParser DEFAULT = new TimeZoneParser();

    @Override
    public ZoneId parseFbk(String raw, ZoneId fbk) {
        try {
            return this.parse(raw);
        }
        catch (Exception any) {
            this.lgr.debug("could not get timezone from '{}': {}", (Object)raw, (Object)any.toString());
            this.fallbackCounter.merge(raw, 1, Integer::sum);
            return fbk;
        }
    }

    @Override
    public ZoneId parse(String raw) {
        String clean;
        Objects.requireNonNull(raw, "REQUIRE raw input to parse time zone");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse time zone");
        }
        switch (clean = raw.strip()) {
            case "Pacific Time Zone": {
                clean = "UTC-08:00";
                break;
            }
            case "Mountain Time Zone": {
                clean = "UTC-07:00";
                break;
            }
            case "Central Time Zone": {
                clean = "UTC-06:00";
                break;
            }
            case "Eastern Time Zone": 
            case "Pakistan Standard Time": {
                clean = "UTC-05:00";
                break;
            }
            case "Atlantic Time Zone": {
                clean = "UTC-04:00";
                break;
            }
            case "Central European Summer Time": {
                clean = "UTC-02:00";
                break;
            }
            case "Greenwich Mean Time": 
            case "Western European Time": {
                clean = "UTC+00:00";
                break;
            }
            case "Central European Time": {
                clean = "UTC+01:00";
                break;
            }
            case "Eastern European Time": 
            case "Central Africa Time": 
            case "Israel time zone": {
                clean = "UTC+02:00";
                break;
            }
            case "Eastern European Summer Time": 
            case "East Africa Time": 
            case "Moscow Time": {
                clean = "UTC+03:00";
                break;
            }
            case "Indian Standard Time": {
                clean = "UTC+05:30";
                break;
            }
            case "\u0628\u062b +00:00": {
                clean = "UTC+04:30";
                break;
            }
            case "Nepal Standard Time": {
                clean = "UTC+05:45";
                break;
            }
            case "Indonesia Western Standard Time": 
            case "Bangladesh Standard Time": 
            case "Indochina Time": {
                clean = "UTC+07:00";
                break;
            }
            case "Singapore Standard Time": 
            case "time in Malaysia": 
            case "Taiwan time": {
                clean = "UTC+08:00";
                break;
            }
            case "Japan Standard Time": {
                clean = "UTC+09:00";
            }
        }
        if (clean.equals(raw.strip())) {
            clean = clean.replace("UTC\u2212", "UTC-");
            clean = clean.replace("UTC\u00b1", "UTC-");
        }
        if (!clean.equals(raw)) {
            this.lgr.debug("fixed timezone from '" + raw + "' to '" + clean + "'");
        }
        return ZoneId.of(clean);
    }
}

