/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.samples.wikidata.parser;

import java.util.Objects;
import net.kafujo.samples.wikidata.parser.WikidataParser;

public class LongParser
extends WikidataParser<Long> {
    public static final LongParser DEFAULT = new LongParser();

    @Override
    public Long parseFbk(String raw, Long fbk) {
        try {
            return this.parse(raw);
        }
        catch (Exception any) {
            this.lgr.debug("could not get Long from '{}': {}", (Object)raw, (Object)any.toString());
            this.fallbackCounter.merge(raw, 1, Integer::sum);
            return fbk;
        }
    }

    @Override
    public Long parse(String raw) {
        Objects.requireNonNull(raw, "REQUIRE raw input to parse long");
        if (raw.isBlank()) {
            throw new IllegalArgumentException("Need not blank raw input to parse long");
        }
        String clean = raw.strip().replace(".", "").replace(",", "");
        return Long.parseLong(clean);
    }
}

