/*
 * Decompiled with CFR 0.152.
 */
package net.kafujo.samples.wikidata;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.io.Reader;
import java.io.UncheckedIOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.time.LocalDate;
import java.time.ZoneId;
import java.util.Collection;
import java.util.HashSet;
import java.util.LinkedList;
import java.util.List;
import java.util.Objects;
import java.util.Optional;
import java.util.Set;
import net.kafujo.samples.wikidata.parser.IntParser;
import net.kafujo.samples.wikidata.parser.LocalDateParser;
import net.kafujo.samples.wikidata.parser.LocationParser;
import net.kafujo.samples.wikidata.parser.LongParser;
import net.kafujo.samples.wikidata.parser.TimeZoneParser;
import net.kafujo.samples.wikidata.parser.UrlParser;
import net.kafujo.units.Location;
import org.apache.commons.csv.CSVFormat;
import org.apache.commons.csv.CSVRecord;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class WikidataCity
implements Comparable<WikidataCity> {
    private static final Logger lgr = LoggerFactory.getLogger(WikidataCity.class);
    private final String wikidataId;
    private final String name;
    private final String country;
    private final URL website;
    private final Long population;
    private final boolean capital;
    private final LocalDate inception;
    private final Integer elevation;
    private final Location location;
    private final ZoneId timeZone;

    public WikidataCity(String wikidataId, String name, String country, URL website, Long population, boolean capital, LocalDate inception, Integer elevation, Location location, ZoneId timeZone) {
        this.wikidataId = Objects.requireNonNull(wikidataId);
        this.name = Objects.requireNonNull(name);
        this.country = Objects.requireNonNull(country);
        this.website = website;
        this.population = population;
        this.capital = capital;
        this.inception = inception;
        this.elevation = elevation;
        this.location = location;
        this.timeZone = timeZone;
    }

    public static Set<WikidataCity> read(InputStream is) {
        HashSet<WikidataCity> cities = new HashSet<WikidataCity>();
        int count = 0;
        int ignoredForDuplicate = 0;
        int ignoredForCorruption = 0;
        try (InputStream inputStream = is;
             InputStreamReader reader = new InputStreamReader(is);){
            for (CSVRecord record : CSVFormat.RFC4180.withHeader(new String[0]).withCommentMarker('#').withIgnoreEmptyLines().parse((Reader)reader)) {
                ++count;
                try {
                    if (cities.add(WikidataCity.from(record))) continue;
                    ++ignoredForDuplicate;
                }
                catch (Exception rt) {
                    lgr.info("Ignore " + record);
                    lgr.info("  Because of: " + rt);
                    ++ignoredForCorruption;
                }
            }
        }
        catch (IOException e) {
            throw new UncheckedIOException(e);
        }
        lgr.info("IGNORED {} of total {}", (Object)(ignoredForCorruption + ignoredForDuplicate), (Object)count);
        lgr.info("   corrupt datasets: {}", (Object)ignoredForCorruption);
        lgr.info("   duplicate ids:    {}", (Object)ignoredForDuplicate);
        return cities;
    }

    public static WikidataCity from(CSVRecord rec) throws MalformedURLException {
        String wikidataId = rec.get("city");
        String name = rec.get("cityLabel");
        String country = rec.get("countryLabel");
        URL website = UrlParser.DEFAULT.parseFbk(rec.get("websiteLabel"), null);
        LocalDate inception = LocalDateParser.DEFAULT.parseFbk(rec.get("inception"), null);
        Long population = LongParser.DEFAULT.parseFbk(rec.get("population"), null);
        Integer elevation = IntParser.DEFAULT.parseFbk(rec.get("elevation"), null);
        boolean capital = !rec.get("capitalOf").isBlank();
        Location location = LocationParser.DEFAULT.parseFbk(rec.get("location"), null);
        ZoneId timezone = TimeZoneParser.DEFAULT.parseFbk(rec.get("timezoneLabel"), null);
        return new WikidataCity(wikidataId, name, country, website, population, capital, inception, elevation, location, timezone);
    }

    public static List<WikidataCity> byName(Collection<WikidataCity> set, String name) {
        LinkedList<WikidataCity> collect = new LinkedList<WikidataCity>();
        for (WikidataCity city : set) {
            if (!name.equalsIgnoreCase(city.getName())) continue;
            collect.add(city);
        }
        return collect;
    }

    public static Optional<WikidataCity> byId(Collection<WikidataCity> set, String id) {
        for (WikidataCity city : set) {
            if (!id.equalsIgnoreCase(city.getWikidataId())) continue;
            return Optional.of(city);
        }
        return Optional.empty();
    }

    public String toString() {
        return this.name + " ," + this.country + " [" + this.wikidataId + "]";
    }

    public boolean equals(Object o) {
        if (this == o) {
            return true;
        }
        if (o == null || this.getClass() != o.getClass()) {
            return false;
        }
        WikidataCity that = (WikidataCity)o;
        return this.wikidataId.equals(that.wikidataId);
    }

    public int hashCode() {
        return Objects.hash(this.wikidataId);
    }

    @Override
    public int compareTo(WikidataCity o) {
        return this.wikidataId.compareTo(o.wikidataId);
    }

    public String getWikidataId() {
        return this.wikidataId;
    }

    public String getName() {
        return this.name;
    }

    public String getCountry() {
        return this.country;
    }

    public LocalDate getInception() {
        return this.inception;
    }

    public boolean isCapital() {
        return this.capital;
    }

    public Long getPopulation() {
        return this.population;
    }

    public Integer getElevation() {
        return this.elevation;
    }

    public URL getWebsite() {
        return this.website;
    }

    public Location getLocation() {
        return this.location;
    }

    public ZoneId getTimeZone() {
        return this.timeZone;
    }
}

